(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19317,        615]
NotebookOptionsPosition[     13123,        459]
NotebookOutlinePosition[     16403,        520]
CellTagsIndexPosition[     16360,        517]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Representation of Numbers", "GuideTitle",
 CellID->12628],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " handles both integers and real numbers with any number of digits, \
automatically tagging numerical precision when appropriate. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " internally uses several highly optimized number representations, but \
nevertheless provides a uniform interface for digit and precision \
manipulation, while allowing numerical analysts to study representation \
details when desired. "
}], "GuideAbstract",
 CellID->21979],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerDigits"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "digits of an integer in any base"
}], "GuideText",
 CellID->13245],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerLength",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/IntegerLength"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "total number of digits in any base"
}], "GuideText",
 CellID->102928006],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerExponent",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerExponent"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "number of trailing 0s in a given base"
}], "GuideText",
 CellID->25128],

Cell[TextData[{
 Cell[TextData[ButtonBox["BitAnd",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BitAnd"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitXor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BitXor"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DigitCount",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DigitCount"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Mod",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Mod"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/IntegerFunctions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->14062],

Cell["\t", "GuideDelimiter",
 CellID->10426],

Cell[TextData[{
 Cell[TextData[ButtonBox["RealDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RealDigits"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "digits and exponent of a real number in any base"
}], "GuideText",
 CellID->4719],

Cell[TextData[{
 Cell[TextData[ButtonBox["Precision",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Precision"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " total ",
 "number of digits of precision"
}], "GuideText",
 CellID->10677],

Cell[TextData[{
 Cell[TextData[ButtonBox["Accuracy",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Accuracy"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "number of significant digits to the right of the decimal point"
}], "GuideText",
 CellID->302706794],

Cell[TextData[{
 Cell[TextData[ButtonBox["RealExponent",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RealExponent"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the overall scale of a number"
}], "GuideText",
 CellID->801824983],

Cell[TextData[{
 Cell[TextData[ButtonBox["MantissaExponent",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MantissaExponent"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "break a number into mantissa and exponent"
}], "GuideText",
 CellID->29091],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerPart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerPart"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FractionalPart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FractionalPart"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Floor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Floor"]], "InlineFunctionSans"],
 " ",
 "\[EmptyVerySmallSquare] ",
 ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NumericalFunctions"]
}], "InlineGuideFunctionListing",
 CellID->4047],

Cell["\t", "GuideDelimiter",
 CellID->13785],

Cell[TextData[{
 Cell[TextData[ButtonBox["FromDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FromDigits"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a number from its digits"
}], "GuideText",
 CellID->23231],

Cell[CellGroupData[{

Cell["Testing for Types", "GuideFunctionsSubsection",
 CellID->7406],

Cell[TextData[{
 Cell[TextData[ButtonBox["NumberQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NumberQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test whether an expression is a number"
}], "GuideText",
 CellID->8684],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test whether an expression is an integer"
}], "GuideText",
 CellID->21954],

Cell[TextData[{
 Cell[TextData[ButtonBox["MachineNumberQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MachineNumberQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test whether an expression is a machine-precision number"
}], "GuideText",
 CellID->16769],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExactNumberQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ExactNumberQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InexactNumberQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InexactNumberQ"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->311454873],

Cell["\t", "GuideDelimiter",
 CellID->14709],

Cell[TextData[{
 Cell[TextData[ButtonBox["Head",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Head"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find the symbolic head of a number"
}], "GuideText",
 CellID->27956],

Cell[TextData[{
 Cell[TextData[ButtonBox["Integer",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Integer"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Real",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Real"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Rational",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rational"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Complex",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Complex"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->22421],

Cell["\t", "GuideDelimiterSubsection",
 CellID->15945]
}, Open  ]],

Cell[CellGroupData[{

Cell["Internal Representation", "GuideFunctionsSubsection",
 CellID->13465],

Cell[TextData[{
 Cell[TextData[ButtonBox["$MaxNumber",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$MaxNumber"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$MinNumber",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$MinNumber"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$MaxPrecision",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$MaxPrecision"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$MinPrecision",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$MinPrecision"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->16016],

Cell[TextData[{
 Cell[TextData[ButtonBox["$MachinePrecision",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$MachinePrecision"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$MachineEpsilon",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$MachineEpsilon"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$MaxMachineNumber",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$MaxMachineNumber"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$MinMachineNumber",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$MinMachineNumber"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->21860]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->16497],

Cell[TextData[ButtonBox["Types of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TypesOfNumbers"]], "GuideTutorial",
 CellID->263556595],

Cell[TextData[ButtonBox["Digits in Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DigitsInNumbers"]], "GuideTutorial",
 CellID->92128837],

Cell[TextData[ButtonBox["Numerical Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalPrecision"]], "GuideTutorial",
 CellID->234102130],

Cell[TextData[ButtonBox["The Uncertainties of Numerical Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheUncertaintiesOfNumericalMathematics"]], "GuideTutorial",\

 CellID->497406344]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->5677],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "GuideMoreAbout",
 CellID->28049],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "GuideMoreAbout",
 CellID->21005],

Cell[TextData[ButtonBox["Display of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DisplayOfNumbers"]], "GuideMoreAbout",
 CellID->7886],

Cell[TextData[ButtonBox["Number Recognition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberRecognition"]], "GuideMoreAbout",
 CellID->141088],

Cell[TextData[ButtonBox["Number Digits",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberDigits"]], "GuideMoreAboutSub",
 CellID->113031937],

Cell[TextData[ButtonBox["Continued Fractions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ContinuedFractionsAndRationalApproximations"]], \
"GuideMoreAboutSub",
 CellID->13143],

Cell[TextData[ButtonBox["Diophantine Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiophantineEquations"]], "GuideMoreAboutSub",
 CellID->780661589]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->291616856],

Cell[TextData[{
 ButtonBox["Demonstrations related to Representation of Numbers",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22representations+of+numbers%22+content%3AAccuracy+OR+BitAnd+OR+BitXor+OR+\
Complex+OR+DigitCount+OR+ExactNumberQ+OR+Floor+OR+FractionalPart+OR+\
FromDigits+OR+Head+OR+InexactNumberQ+OR+Integer+OR+IntegerDigits+OR+\
IntegerExponent+OR+IntegerLength+OR+IntegerPart+OR+IntegerQ+OR+MachineNumberQ+\
OR+MantissaExponent+OR+Mod+OR+NumberQ+OR+Precision+OR+Rational+OR+Real+OR+\
RealDigits+OR+RealExponent+OR+$MachineEpsilon+OR+$MachinePrecision+OR+$\
MaxMachineNumber+OR+$MaxNumber+OR+$MaxPrecision+OR+$MinMachineNumber+OR+$\
MinNumber+OR+$MinPrecision"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->415429210]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Representation of Numbers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 56.9405086}", "context" -> "", 
    "keywords" -> {
     "absolute error", "add", "aliquant", "approximate numbers", "arrays", 
      "bases", "binary digits", "bit and", "bit count", "bit xor", "carry", 
      "conformity", "congruence", "conversion", "count of digits", 
      "cyclic indices", "decimal digits", "decode", "digit count", 
      "digit sequences", "digital sums", "digits", "digits count", 
      "digits of real numbers", "encode", "entier", "entire", "exact number", 
      "explode", "exponents of numbers", "finite fields", "fix", 
      "floating-point decomposition", "floating-point numbers", "frac", 
      "fractal", "fractional part", "from digits", "function name", 
      "granularity of machine numbers", "greatest dividing exponent", 
      "greatest integer function", "half adder", "Hamming weight", "height", 
      "hexadecimal digits", "implode", "inexact number", "int", 
      "integer digits", "integer exponent", "integer length", "integer part", 
      "integers", "intrz", "irem", "length", "machine epsilon", 
      "machine number", "machine precision", "Mantissa exponent", "mask", 
      "max machine number", "max number", "max precision", 
      "min machine number", "min number", "min precision", "modp", "mods", 
      "modulo", "names of operators", "nearest integer function", 
      "Nim addition", "non-integer part", "number conversion", 
      "number of decimal places", "number reconstruction", "numbers", 
      "octal digits", "one-origin arrays", "ones", "origin", "padding", 
      "population count", "radix conversion", "real digits", "real exponent", 
      "real numbers", "reconstruction", "recurring decimals", 
      "relative error", "rem", "remainder", "roman numerals", "round down", 
      "rounddown", "ruler function", "ternary digits", "testing for integers",
       "testing for numbers", "testing for numerical expressions", "trunc", 
      "truncate to integer", "unpack", "veracity", "zeros"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica handles both integers and real numbers with any number of \
digits, automatically tagging numerical precision when appropriate. \
Mathematica internally uses several highly optimized number representations, \
but nevertheless provides a uniform interface for digit and precision \
manipulation, while allowing numerical analysts to study representation \
details when desired. ", "synonyms" -> {}, "title" -> 
    "Representation of Numbers", "type" -> "Guide", "uri" -> 
    "guide/RepresentationOfNumbers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 63, 1, 70, "GuideTitle",
 CellID->12628],
Cell[685, 28, 524, 12, 70, "GuideAbstract",
 CellID->21979],
Cell[1212, 42, 267, 9, 70, "GuideText",
 CellID->13245],
Cell[1482, 53, 418, 12, 70, "GuideText",
 CellID->102928006],
Cell[1903, 67, 276, 9, 70, "GuideText",
 CellID->25128],
Cell[2182, 78, 1007, 29, 70, "InlineGuideFunctionListing",
 CellID->14062],
Cell[3192, 109, 44, 1, 70, "GuideDelimiter",
 CellID->10426],
Cell[3239, 112, 276, 9, 70, "GuideText",
 CellID->4719],
Cell[3518, 123, 262, 9, 70, "GuideText",
 CellID->10677],
Cell[3783, 134, 291, 9, 70, "GuideText",
 CellID->302706794],
Cell[4077, 145, 266, 9, 70, "GuideText",
 CellID->801824983],
Cell[4346, 156, 282, 9, 70, "GuideText",
 CellID->29091],
Cell[4631, 167, 735, 22, 70, "InlineGuideFunctionListing",
 CellID->4047],
Cell[5369, 191, 44, 1, 70, "GuideDelimiter",
 CellID->13785],
Cell[5416, 194, 263, 9, 70, "GuideText",
 CellID->23231],
Cell[CellGroupData[{
Cell[5704, 207, 68, 1, 70, "GuideFunctionsSubsection",
 CellID->7406],
Cell[5775, 210, 260, 9, 70, "GuideText",
 CellID->8684],
Cell[6038, 221, 265, 9, 70, "GuideText",
 CellID->21954],
Cell[6306, 232, 293, 9, 70, "GuideText",
 CellID->16769],
Cell[6602, 243, 416, 11, 70, "InlineGuideFunctionListing",
 CellID->311454873],
Cell[7021, 256, 44, 1, 70, "GuideDelimiter",
 CellID->14709],
Cell[7068, 259, 251, 9, 70, "GuideText",
 CellID->27956],
Cell[7322, 270, 796, 23, 70, "InlineGuideFunctionListing",
 CellID->22421],
Cell[8121, 295, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->15945]
}, Open  ]],
Cell[CellGroupData[{
Cell[8212, 301, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->13465],
Cell[8290, 304, 836, 23, 70, "InlineGuideFunctionListing",
 CellID->16016],
Cell[9129, 329, 876, 23, 70, "InlineGuideFunctionListing",
 CellID->21860]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10054, 358, 58, 1, 70, "GuideTutorialsSection",
 CellID->16497],
Cell[10115, 361, 149, 3, 70, "GuideTutorial",
 CellID->263556595],
Cell[10267, 366, 150, 3, 70, "GuideTutorial",
 CellID->92128837],
Cell[10420, 371, 156, 3, 70, "GuideTutorial",
 CellID->234102130],
Cell[10579, 376, 204, 5, 70, "GuideTutorial",
 CellID->497406344]
}, Open  ]],
Cell[CellGroupData[{
Cell[10820, 386, 58, 1, 70, "GuideMoreAboutSection",
 CellID->5677],
Cell[10881, 389, 150, 3, 70, "GuideMoreAbout",
 CellID->28049],
Cell[11034, 394, 146, 3, 70, "GuideMoreAbout",
 CellID->21005],
Cell[11183, 399, 146, 3, 70, "GuideMoreAbout",
 CellID->7886],
Cell[11332, 404, 149, 3, 70, "GuideMoreAbout",
 CellID->141088],
Cell[11484, 409, 145, 3, 70, "GuideMoreAboutSub",
 CellID->113031937],
Cell[11632, 414, 183, 5, 70, "GuideMoreAboutSub",
 CellID->13143],
Cell[11818, 421, 161, 3, 70, "GuideMoreAboutSub",
 CellID->780661589]
}, Open  ]],
Cell[CellGroupData[{
Cell[12016, 429, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->291616856],
Cell[12088, 432, 993, 22, 70, "GuideRelatedLinks",
 CellID->415429210]
}, Open  ]],
Cell[13096, 457, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

