(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8933,        306]
NotebookOptionsPosition[      5415,        209]
NotebookOutlinePosition[      7279,        251]
CellTagsIndexPosition[      7236,        248]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Rules", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "Everything that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does can be thought of as derived from its ability to apply general \
transformation rules to arbitrary symbolic expressions",
 ". ",
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language provides flexible functions that give direct access to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s powerful rule transformation engine."
}], "GuideAbstract",
 CellID->81760071],

Cell[CellGroupData[{

Cell["Representing Rules", "GuideFunctionsSubsection",
 CellID->645854084],

Cell[TextData[{
 Cell[TextData[ButtonBox["Rule",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rule"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["->",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rule"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " immediate replacement rule for any pattern"
}], "GuideText",
 CellID->136647404],

Cell[TextData[{
 Cell[TextData[ButtonBox["RuleDelayed",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RuleDelayed"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox[":>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RuleDelayed"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " delayed rule, with right-hand side evaluated only when used"
}], "GuideText",
 CellID->1463276848],

Cell["\t", "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],

Cell[CellGroupData[{

Cell["Applying Rules", "GuideFunctionsSubsection",
 CellID->89419573],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReplaceAll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplaceAll"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["/.",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplaceAll"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " apply replacement rules throughout an expression"
}], "GuideText",
 CellID->1205848],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReplaceRepeated",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplaceRepeated"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["//.",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplaceRepeated"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " apply replacement rules repeatedly until no change occurs"
}], "GuideText",
 CellID->548753366],

Cell["\t", "GuideDelimiter",
 CellID->539752626],

Cell[TextData[{
 Cell[TextData[ButtonBox["Replace",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Replace"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " apply replacement rules to a complete expression"
}], "GuideText",
 CellID->748605182],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReplaceList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplaceList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " a list of all possible ways to apply rules"
}], "GuideText",
 CellID->300030997],

Cell["\t", "GuideDelimiter",
 CellID->556141864],

Cell[TextData[{
 Cell[TextData[ButtonBox["SparseArray",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SparseArray"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " give rules for values at particular positions in an array"
}], "GuideText",
 CellID->182369888]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Patterns and Transformation Rules",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PatternsAndTransformationRules"]], "GuideTutorial",
 CellID->231261676],

Cell[TextData[ButtonBox["Applying Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ApplyingTransformationRules"]], "GuideTutorial",\

 CellID->302153571],

Cell[TextData[ButtonBox["Variables in Pure Functions and Rules",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/VariablesInPureFunctionsAndRules"]], "GuideTutorial",
 CellID->413462860]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Options Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OptionsManagement"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Assignments",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Assignments"]], "GuideMoreAboutSub",
 CellID->323869103],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rules - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 58.3155438}", "context" -> "", 
    "keywords" -> {
     "apply rules to whole expression", "arrow", "controlled transformations",
       "deferred evaluation", "delayed evaluation", "delayed rules", 
      "evaluation at a point", "immediate rules", 
      "multiple matches for patterns", "preventing evaluation in rules", 
      "production rules", "repeated rule application", "replace all", 
      "replace list", "replace repeated", "replacement", "replacements", 
      "ReplaceRepeated", "rewrite rules", "rule delayed", "rules", 
      "searching", "selecting sublists", "sparse array", "sparse matrix", 
      "sparse representation", "sparse vector", "sublists", "substitution", 
      "temporary binding"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Everything that Mathematica does can be thought of as derived from its \
ability to apply general transformation rules to arbitrary symbolic \
expressions. The Mathematica language provides flexible functions that give \
direct access to Mathematica's powerful rule transformation engine.", 
    "synonyms" -> {}, "title" -> "Rules", "type" -> "Guide", "uri" -> 
    "guide/Rules"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 47, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[669, 28, 482, 15, 70, "GuideAbstract",
 CellID->81760071],
Cell[CellGroupData[{
Cell[1176, 47, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->645854084],
Cell[1253, 50, 381, 13, 70, "GuideText",
 CellID->136647404],
Cell[1637, 65, 420, 13, 70, "GuideText",
 CellID->1463276848],
Cell[2060, 80, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],
Cell[CellGroupData[{
Cell[2155, 86, 69, 1, 70, "GuideFunctionsSubsection",
 CellID->89419573],
Cell[2227, 89, 403, 13, 70, "GuideText",
 CellID->1205848],
Cell[2633, 104, 430, 13, 70, "GuideText",
 CellID->548753366],
Cell[3066, 119, 48, 1, 70, "GuideDelimiter",
 CellID->539752626],
Cell[3117, 122, 270, 8, 70, "GuideText",
 CellID->748605182],
Cell[3390, 132, 272, 8, 70, "GuideText",
 CellID->300030997],
Cell[3665, 142, 48, 1, 70, "GuideDelimiter",
 CellID->556141864],
Cell[3716, 145, 287, 8, 70, "GuideText",
 CellID->182369888]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4052, 159, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[4117, 162, 185, 4, 70, "GuideTutorial",
 CellID->231261676],
Cell[4305, 168, 177, 4, 70, "GuideTutorial",
 CellID->302153571],
Cell[4485, 174, 191, 4, 70, "GuideTutorial",
 CellID->413462860]
}, Open  ]],
Cell[CellGroupData[{
Cell[4713, 183, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[4778, 186, 134, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[4915, 191, 152, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[5070, 196, 142, 3, 70, "GuideMoreAboutSub",
 CellID->323869103],
Cell[5215, 201, 158, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],
Cell[5388, 207, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

