(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13313,        433]
NotebookOptionsPosition[      8620,        313]
NotebookOutlinePosition[     11299,        366]
CellTagsIndexPosition[     11256,        363]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Scoping Constructs", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "The flexibility of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic architecture is reflected in its rich collection of carefully \
defined constructs for localization and modularization",
 ". ",
 "The use of multiple forms of scoping allows for more elegant, readable and \
efficient programs, supports the concept of programs as data, and allows \
direct correspondence with mathematical notions of variables."
}], "GuideAbstract",
 CellID->486416810],

Cell[TextData[{
 Cell[TextData[ButtonBox["With",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/With"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "evaluate with specified variables replaced by values "
}], "GuideText",
 CellID->672895452],

Cell["\t", "GuideDelimiter",
 CellID->289813065],

Cell[TextData[{
 Cell[TextData[ButtonBox["Module",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Module"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " localize names of variables (lexical scoping)"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Block",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Block"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " localize values of variables (dynamic scoping)"
}], "GuideText",
 CellID->1463276848],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["DynamicModule",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DynamicModule"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "localize names of variables in dynamic interface constructs"
}], "GuideText",
 CellID->565692224],

Cell["\t", "GuideDelimiterSubsection",
 CellID->127318665],

Cell[CellGroupData[{

Cell["Constructs with Automatic Name Scoping", "GuideFunctionsSubsection",
 CellID->34103915],

Cell[TextData[{
 Cell[TextData[ButtonBox["Function",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Function"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a pure function, with formal variables automatically scoped"
}], "GuideText",
 CellID->215987777],

Cell[TextData[{
 Cell[TextData[ButtonBox["Rule",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rule"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["->",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rule"]], "InlineFunctionSans"],
 "), ",
 Cell[TextData[ButtonBox["RuleDelayed",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RuleDelayed"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox[":>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RuleDelayed"]], "InlineFunctionSans"],
 ") \[LongDash] named pattern variables automatically scoped"
}], "GuideText",
 CellID->361364205],

Cell[TextData[{
 Cell[TextData[ButtonBox["Set",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Set"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Set"]], "InlineFunctionSans"],
 "), ",
 Cell[TextData[ButtonBox["SetDelayed",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SetDelayed"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox[":=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SetDelayed"]], "InlineFunctionSans"],
 ") \[LongDash] named pattern variables automatically scoped"
}], "GuideText",
 CellID->525591177]
}, Open  ]],

Cell[CellGroupData[{

Cell["Constructs with Automatic Value Scoping", "GuideFunctionsSubsection",
 CellID->61991050],

Cell[TextData[{
 Cell[TextData[ButtonBox["Table",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Table"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "create a table, with iterator variables automatically scoped"
}], "GuideText",
 CellID->184149195],

Cell[TextData[{
 Cell[TextData[ButtonBox["Do",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Do"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sum",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sum"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Plot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Plot"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Plot3D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Plot3D"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NDSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NDSolve"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData["..."], "InlineFormula"]
}], "InlineGuideFunctionListing",
 CellID->84591516]
}, Open  ]],

Cell[CellGroupData[{

Cell["Other Forms of Scoping", "GuideFunctionsSubsection",
 CellID->974031185],

Cell[TextData[{
 Cell[TextData[ButtonBox["Begin",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Begin"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["End",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/End"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "localize symbol namespace"
}], "GuideText",
 CellID->156600903],

Cell[TextData[{
 Cell[TextData[ButtonBox["Throw",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Throw"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Catch",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Catch"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "localize exceptions"
}], "GuideText",
 CellID->570313627],

Cell[TextData[{
 Cell[TextData[ButtonBox["Quiet",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Quiet"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["Check",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Check"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "localize messages"
}], "GuideText",
 CellID->11796423],

Cell[TextData[{
 Cell[TextData[ButtonBox["BlockRandom",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BlockRandom"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "localize pseudorandom variables"
}], "GuideText",
 CellID->248430354]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Modules and Local Variables",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ModulesAndLocalVariables"]], "GuideTutorial",
 CellID->127062955],

Cell[TextData[ButtonBox["Blocks Compared with Modules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BlocksComparedWithModules"]], "GuideTutorial",
 CellID->781792460],

Cell[TextData[ButtonBox["Variables in Pure Functions and Rules",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/VariablesInPureFunctionsAndRules"]], "GuideTutorial",
 CellID->144363650]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Namespace Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NamespaceManagement"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Assumptions & Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Scoping Constructs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 33, 58.8780582}", "context" -> "", 
    "keywords" -> {
     "abort", "ampersand", "anonymous functions", "assign value", 
      "assignments", "binding", "binding environment", "block random", 
      "blocks", "bound variables", "closures", "computed goto", 
      "deferred evaluation", "defining values", "definitions", 
      "delayed assignment", "delayed definitions", "delayed evaluation", 
      "delayed rules", "dummy variables", "dynamic module", "dynamic scoping",
       "errors", "evaluation", "evaluation control", "exception handling", 
      "fixed variables", "fluid variables", "free variables", 
      "handling of errors", "immediate assignment", "immediate definition", 
      "immediate rules", "immediate value", "iteration", "jump", 
      "lambda expression", "lexical scoping", "local constants", 
      "local values", "localize random generator", "localize random state", 
      "longjmp", "macros", "modularization", "non-local returns", 
      "preventing evaluation in rules", "procedure", "programs", 
      "pure function", "quiet evaluation", "replacements", 
      "reset random state", "returns", "rule delayed", "scope", "scoping", 
      "section", "sequences", "set delayed", "setting values", 
      "shut off messages", "silence messages", "static scoping", 
      "substitution", "temporary values", "trapping errors", 
      "turn off messages", "unnamed function"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "The flexibility of Mathematica's symbolic architecture is reflected in \
its rich collection of carefully defined constructs for localization and \
modularization. The use of multiple forms of scoping allows for more elegant, \
readable and efficient programs, supports the concept of programs as data, \
and allows direct correspondence with mathematical notions of variables.", 
    "synonyms" -> {}, "title" -> "Scoping Constructs", "type" -> "Guide", 
    "uri" -> "guide/ScopingConstructs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 60, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[682, 28, 488, 11, 70, "GuideAbstract",
 CellID->486416810],
Cell[1173, 41, 274, 9, 70, "GuideText",
 CellID->672895452],
Cell[1450, 52, 48, 1, 70, "GuideDelimiter",
 CellID->289813065],
Cell[1501, 55, 265, 8, 70, "GuideText",
 CellID->203374175],
Cell[1769, 65, 265, 8, 70, "GuideText",
 CellID->1463276848],
Cell[2037, 75, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[2088, 78, 443, 12, 70, "GuideText",
 CellID->565692224],
Cell[2534, 92, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->127318665],
Cell[CellGroupData[{
Cell[2617, 97, 93, 1, 70, "GuideFunctionsSubsection",
 CellID->34103915],
Cell[2713, 100, 288, 9, 70, "GuideText",
 CellID->215987777],
Cell[3004, 111, 601, 18, 70, "GuideText",
 CellID->361364205],
Cell[3608, 131, 594, 18, 70, "GuideText",
 CellID->525591177]
}, Open  ]],
Cell[CellGroupData[{
Cell[4239, 154, 94, 1, 70, "GuideFunctionsSubsection",
 CellID->61991050],
Cell[4336, 157, 283, 9, 70, "GuideText",
 CellID->184149195],
Cell[4622, 168, 1111, 33, 70, "InlineGuideFunctionListing",
 CellID->84591516]
}, Open  ]],
Cell[CellGroupData[{
Cell[5770, 206, 78, 1, 70, "GuideFunctionsSubsection",
 CellID->974031185],
Cell[5851, 209, 365, 13, 70, "GuideText",
 CellID->156600903],
Cell[6219, 224, 363, 13, 70, "GuideText",
 CellID->570313627],
Cell[6585, 239, 505, 16, 70, "GuideText",
 CellID->11796423],
Cell[7093, 257, 411, 12, 70, "GuideText",
 CellID->248430354]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7553, 275, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[7618, 278, 170, 3, 70, "GuideTutorial",
 CellID->127062955],
Cell[7791, 283, 172, 3, 70, "GuideTutorial",
 CellID->781792460],
Cell[7966, 288, 191, 4, 70, "GuideTutorial",
 CellID->144363650]
}, Open  ]],
Cell[CellGroupData[{
Cell[8194, 297, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[8259, 300, 157, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[8419, 305, 159, 3, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[8593, 311, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

