(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14828,        459]
NotebookOptionsPosition[     10646,        352]
NotebookOutlinePosition[     13072,        402]
CellTagsIndexPosition[     13029,        399]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Signal Processing", "GuideTitle",
 CellID->16600],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has powerful capabilities for explicit signal processing with large \
volumes of data, imported and exported in many formats, and for symbolic \
analysis of signal processing algorithms using state-of-the-art algebraic \
methods."
}], "GuideAbstract",
 CellID->31864],

Cell[TextData[{
 Cell[TextData[ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Export",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Export"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " import and export data in standard formats"
}], "GuideText",
 CellID->1710],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"SND\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SND"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"WAV\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/WAV"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"AIFF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/AIFF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"MAT\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MAT"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"EDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/EDF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ImportingAndExporting"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->94476466],

Cell[TextData[{
 Cell[TextData[ButtonBox["BinaryReadList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BinaryReadList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BinaryWrite",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BinaryWrite"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/BinaryData"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->105980327],

Cell["\t", "GuideDelimiter",
 CellID->2641],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListPlot"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "plot a list of values"
}], "GuideText",
 CellID->27732],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListPlay",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListPlay"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "play a list of amplitude values as a sound"
}], "GuideText",
 CellID->12437],

Cell["\t", "GuideDelimiter",
 CellID->11684],

Cell[TextData[{
 Cell[TextData[ButtonBox["Fourier",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Fourier"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["FourierDCT",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FourierDCT"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["FourierDST",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FourierDST"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "discrete Fourier transforms"
}], "GuideText",
 CellID->32499],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListConvolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListConvolve"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convolve with a kernel"
}], "GuideText",
 CellID->32701],

Cell[TextData[{
 Cell[TextData[ButtonBox["Clip",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Clip"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Rescale",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rescale"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MovingAverage",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MovingAverage"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ExponentialMovingAverage",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ExponentialMovingAverage"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->11827417],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Linear Algebra \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MatricesAndLinearAlgebra"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->128992300],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dot"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox[".",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dot"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LinearSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinearSolve"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LeastSquares",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LeastSquares"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SingularValueDecomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SingularValueDecomposition"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->470594622],

Cell["\t", "GuideDelimiter",
 CellID->28583],

Cell[TextData[{
 Cell[TextData[ButtonBox["ZTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ZTransform"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "symbolic Z transform for constructing filters"
}], "GuideText",
 CellID->29256],

Cell[TextData[{
 Cell[TextData[ButtonBox["LaplaceTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LaplaceTransform"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FourierTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FourierTransform"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sinc",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Sinc"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->17272077]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->13810],

Cell[TextData[ButtonBox["Sound & Sonification",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SoundAndSonification"]], "GuideMoreAbout",
 CellID->5820],

Cell[TextData[ButtonBox["Handling Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "GuideMoreAbout",
 CellID->14835],

Cell[TextData[ButtonBox["Scientific & Medical Data Formats",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ScientificAndMedicalDataFormats"]], "GuideMoreAboutSub",
 CellID->25897],

Cell[TextData[ButtonBox["Image Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImageProcessing"]], "GuideMoreAboutSub",
 CellID->109147049],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "GuideMoreAbout",
 CellID->140580976]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->348263634],

Cell[TextData[{
 ButtonBox["Demonstrations related to Signal Processing",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22signal+processing%22+content%3ABinaryReadList+OR+BinaryWrite+OR+Clip+OR+Dot+\
OR+ExponentialMovingAverage+OR+Export+OR+Fourier+OR+FourierDCT+OR+FourierDST+\
OR+FourierTransform+OR+Import+OR+LaplaceTransform+OR+LeastSquares+OR+\
LinearSolve+OR+ListConvolve+OR+ListPlay+OR+ListPlot+OR+MovingAverage+OR+\
Rescale+OR+Sinc+OR+SingularValueDecomposition+OR+ZTransform"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->64159565]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Signal Processing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 3.4094242}", "context" -> "", 
    "keywords" -> {
     "binary read list", "binary write", "convolutions", "data filter", 
      "data filtering", "data smoother", "data smoothing", "EMA", "EWMA", 
      "exponential moving average", "exponential smoother", 
      "exponential smoothing", "exponential weighted moving average", 
      "fast cosine transform", "fast Fourier transform", 
      "fast sine transform", "FFT", "files", "filtering", "filter taps", 
      "finite impulse response filter", "Fourier transform", 
      "Fourier transforms", "frequency dimension", "frequency spectrum", 
      "generalized singular value decomposition", "integral transform", 
      "inverse Fourier transform", "kernel", "Laplace transform", 
      "least-squares", "least squares", "linear moving average", 
      "list convolve", "MA", "moving average", "moving mean", 
      "power spectrum", "real Fourier transform", 
      "real odd Fourier transform", "sequence transform", "signal processing",
       "simple moving average", "singular value decomposition", "SMA", 
      "smoothing", "spectrum", "square wave", "time series", 
      "transfer function", "transform", "transient analysis", 
      "trigonometric transform", "vectors", "weighted moving average", 
      "writing binary files"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica has powerful capabilities for explicit signal processing \
with large volumes of data, imported and exported in many formats, and for \
symbolic analysis of signal processing algorithms using state-of-the-art \
algebraic methods.", "synonyms" -> {}, "title" -> "Signal Processing", "type" -> 
    "Guide", "uri" -> "guide/SignalProcessing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 55, 1, 70, "GuideTitle",
 CellID->16600],
Cell[677, 28, 335, 8, 70, "GuideAbstract",
 CellID->31864],
Cell[1015, 38, 380, 12, 70, "GuideText",
 CellID->1710],
Cell[1398, 52, 1244, 35, 70, "InlineGuideFunctionListing",
 CellID->94476466],
Cell[2645, 89, 621, 17, 70, "InlineGuideFunctionListing",
 CellID->105980327],
Cell[3269, 108, 43, 1, 70, "GuideDelimiter",
 CellID->2641],
Cell[3315, 111, 246, 9, 70, "GuideText",
 CellID->27732],
Cell[3564, 122, 267, 9, 70, "GuideText",
 CellID->12437],
Cell[3834, 133, 44, 1, 70, "GuideDelimiter",
 CellID->11684],
Cell[3881, 136, 802, 23, 70, "GuideText",
 CellID->32499],
Cell[4686, 161, 255, 9, 70, "GuideText",
 CellID->32701],
Cell[4944, 172, 1133, 29, 70, "InlineGuideFunctionListing",
 CellID->11827417],
Cell[CellGroupData[{
Cell[6102, 205, 226, 5, 70, "GuideFunctionsSubsection",
 CellID->128992300],
Cell[6331, 212, 1326, 39, 70, "InlineGuideFunctionListing",
 CellID->470594622],
Cell[7660, 253, 44, 1, 70, "GuideDelimiter",
 CellID->28583],
Cell[7707, 256, 274, 9, 70, "GuideText",
 CellID->29256],
Cell[7984, 267, 772, 20, 70, "InlineGuideFunctionListing",
 CellID->17272077]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8805, 293, 59, 1, 70, "GuideMoreAboutSection",
 CellID->13810],
Cell[8867, 296, 152, 3, 70, "GuideMoreAbout",
 CellID->5820],
Cell[9022, 301, 149, 3, 70, "GuideMoreAbout",
 CellID->14835],
Cell[9174, 306, 183, 4, 70, "GuideMoreAboutSub",
 CellID->25897],
Cell[9360, 312, 151, 3, 70, "GuideMoreAboutSub",
 CellID->109147049],
Cell[9514, 317, 180, 3, 70, "GuideMoreAbout",
 CellID->140580976]
}, Open  ]],
Cell[CellGroupData[{
Cell[9731, 325, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->348263634],
Cell[9803, 328, 801, 19, 70, "GuideRelatedLinks",
 CellID->64159565]
}, Open  ]],
Cell[10619, 350, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

