(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10754,        383]
NotebookOptionsPosition[      7192,        278]
NotebookOutlinePosition[      8802,        316]
CellTagsIndexPosition[      8759,        313]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Sound and Sonification", "GuideTitle",
 CellID->18677],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports state-of-the-art sound generation, providing both arbitrary \
waveform synthesis from functions and data, and symbolic note-based \
MIDI-style sound synthesis",
 ". "
}], "GuideAbstract",
 CellID->2774],

Cell[TextData[{
 Cell[TextData[ButtonBox["Play",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Play"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "play a function by taking it as the waveform for a sound"
}], "GuideText",
 CellID->28878],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListPlay",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListPlay"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "play a list of amplitude values"
}], "GuideText",
 CellID->2286],

Cell["\t", "GuideDelimiterSubsection",
 CellID->18108832],

Cell[CellGroupData[{

Cell["Sound Primitives", "GuideFunctionsSubsection",
 CellID->25624],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sound",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sound"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "sound wrapper with timing information"
}], "GuideText",
 CellID->2734],

Cell[TextData[{
 Cell[TextData[ButtonBox["SoundNote",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SoundNote"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "music-like sound note"
}], "GuideText",
 CellID->18075],

Cell[TextData[{
 Cell[TextData[ButtonBox["SampledSoundList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SampledSoundList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "sampled sound from a list of data"
}], "GuideText",
 CellID->15349],

Cell["\t", "GuideDelimiter",
 CellID->30712],

Cell[TextData[{
 Cell[TextData[ButtonBox["EmitSound",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/EmitSound"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "emit a symbolically specified sound"
}], "GuideText",
 CellID->26984],

Cell[TextData[{
 Cell[TextData[ButtonBox["Beep",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Beep"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "generate a beep"
}], "GuideText",
 CellID->30624],

Cell["\t", "GuideDelimiter",
 CellID->27792],

Cell[TextData[{
 Cell[TextData[ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Export",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Export"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "import and export sounds"
}], "GuideText",
 CellID->6504],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"MIDI\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MIDI"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "music-oriented note format"
}], "GuideText",
 CellID->28822],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"WAV\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/WAV"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["\"AU\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/AU"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["\"FLAC\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/FLAC"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AudioFormats"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sampled sounds"
}], "GuideText",
 CellID->4055],

Cell["\t", "GuideDelimiter",
 CellID->187812787],

Cell[TextData[{
 Cell[TextData[ButtonBox["SystemDialogInput",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SystemDialogInput"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "use your computer system to record a sound for input"
}], "GuideText",
 CellID->643019206]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->18913],

Cell[TextData[ButtonBox["Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Sound"]], "GuideTutorial",
 CellID->94388984],

Cell[TextData[ButtonBox["The Representation of Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheRepresentationOfSound"]], "GuideTutorial",
 CellID->31782571]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->20084],

Cell[TextData[ButtonBox["Audio Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AudioFormats"]], "GuideMoreAbout",
 CellID->24160],

Cell[TextData[ButtonBox["Signal Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SignalProcessing"]], "GuideMoreAbout",
 CellID->31122],

Cell[TextData[ButtonBox["Audio Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Audio/guide/AudioPackage"]], "GuideMoreAboutSub",
 CellID->19397],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/guide/MusicPackage"]], "GuideMoreAboutSub",
 CellID->11822],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "GuideMoreAboutSub",
 CellID->78797111]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1373958563],

Cell[TextData[{
 ButtonBox["Demonstrations related to Sound and Sonification",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(Beep+\
OR+EmitSound+OR+Export+OR+Import+OR+ListPlay+OR+Play+OR+SampledSoundList+OR+\
Sound+OR+SoundNote+OR+SystemDialogInput)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->183976665]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Sound and Sonification - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 3.8938116}", "context" -> "", 
    "keywords" -> {
     "AIFF format", "animations", "audio", "AU format", "AVI", "emit sound", 
      "exporting sounds", "list play", "Microsoft wave format", 
      "mu law format", "play sound list", "rasterized sound", "sampled sound",
       "sampled sound list", "sampled sound primitive", "SND format", 
      "sound note", "sounds", "tone", "WAV format", "audio", 
      "aural representation", "hearing data", "MIDI", "multimedia", 
      "music synthesis", "waveform synthesis"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica supports state-of-the-art sound generation, providing both \
arbitrary waveform synthesis from functions and data, and symbolic note-based \
MIDI-style sound synthesis. ", "synonyms" -> {}, "title" -> 
    "Sound and Sonification", "type" -> "Guide", "uri" -> 
    "guide/SoundAndSonification"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 60, 1, 70, "GuideTitle",
 CellID->18677],
Cell[682, 28, 279, 8, 70, "GuideAbstract",
 CellID->2774],
Cell[964, 38, 273, 9, 70, "GuideText",
 CellID->28878],
Cell[1240, 49, 255, 9, 70, "GuideText",
 CellID->2286],
Cell[1498, 60, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->18108832],
Cell[CellGroupData[{
Cell[1580, 65, 68, 1, 70, "GuideFunctionsSubsection",
 CellID->25624],
Cell[1651, 68, 255, 9, 70, "GuideText",
 CellID->2734],
Cell[1909, 79, 393, 12, 70, "GuideText",
 CellID->18075],
Cell[2305, 93, 274, 9, 70, "GuideText",
 CellID->15349],
Cell[2582, 104, 44, 1, 70, "GuideDelimiter",
 CellID->30712],
Cell[2629, 107, 407, 12, 70, "GuideText",
 CellID->26984],
Cell[3039, 121, 377, 12, 70, "GuideText",
 CellID->30624],
Cell[3419, 135, 44, 1, 70, "GuideDelimiter",
 CellID->27792],
Cell[3466, 138, 367, 13, 70, "GuideText",
 CellID->6504],
Cell[3836, 153, 254, 9, 70, "GuideText",
 CellID->28822],
Cell[4093, 164, 618, 20, 70, "GuideText",
 CellID->4055],
Cell[4714, 186, 48, 1, 70, "GuideDelimiter",
 CellID->187812787],
Cell[4765, 189, 444, 12, 70, "GuideText",
 CellID->643019206]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5258, 207, 58, 1, 70, "GuideTutorialsSection",
 CellID->18913],
Cell[5319, 210, 128, 3, 70, "GuideTutorial",
 CellID->94388984],
Cell[5450, 215, 169, 3, 70, "GuideTutorial",
 CellID->31782571]
}, Open  ]],
Cell[CellGroupData[{
Cell[5656, 223, 59, 1, 70, "GuideMoreAboutSection",
 CellID->20084],
Cell[5718, 226, 138, 3, 70, "GuideMoreAbout",
 CellID->24160],
Cell[5859, 231, 146, 3, 70, "GuideMoreAbout",
 CellID->31122],
Cell[6008, 236, 147, 3, 70, "GuideMoreAboutSub",
 CellID->19397],
Cell[6158, 241, 147, 3, 70, "GuideMoreAboutSub",
 CellID->11822],
Cell[6308, 246, 164, 3, 70, "GuideMoreAboutSub",
 CellID->78797111]
}, Open  ]],
Cell[CellGroupData[{
Cell[6509, 254, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1373958563],
Cell[6582, 257, 568, 16, 70, "GuideRelatedLinks",
 CellID->183976665]
}, Open  ]],
Cell[7165, 276, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

