(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40252,       1119]
NotebookOptionsPosition[     27643,        852]
NotebookOutlinePosition[     36550,        996]
CellTagsIndexPosition[     36507,        993]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Special Functions", "GuideTitle",
 CellID->9034],

Cell[TextData[{
 "Two decades of intense R&D at Wolfram Research have given ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by far the world's broadest and deepest coverage of special functions\
\[LongDash]and greatly expanded the whole domain of practical closed-form \
solutions. Often using original results and methods, all special functions in \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " support arbitrary-precision evaluation for all complex values of \
parameters, arbitrary series expansion even at branch points, and an immense \
web of exact relations, transformations and simplifications."
}], "GuideAbstract",
 CellID->121864640],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox[ButtonBox["Gamma, Beta, Etc",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GammaFunctionsAndRelatedFunctions"], 
  "GuideFunctionsSubsection"],
 ".",
 StyleBox[ButtonBox[" \[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GammaFunctionsAndRelatedFunctions"], 
  "GuideFunctionsSubsection"]
}], "GuideFunctionsSubsection",
 CellID->1344],

Cell[TextData[{
 Cell[TextData[ButtonBox["Gamma",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Gamma"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Pochhammer",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Pochhammer"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Beta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Beta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PolyGamma",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PolyGamma"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LogGamma",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LogGamma"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GammaFunctionsAndRelatedFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->32736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Error Functions, Exponential Integrals, \
Etc. \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ErrorAndExponentialIntegralFunctions"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->22037],

Cell[TextData[{
 Cell[TextData[ButtonBox["Erf",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Erf"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Erfc",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Erfc"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ExpIntegralE",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ExpIntegralE"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ExpIntegralEi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ExpIntegralEi"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LogIntegral",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LogIntegral"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FresnelS",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FresnelS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SinIntegral",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SinIntegral"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ErrorAndExponentialIntegralFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->5416]
}, Open  ]],

Cell[CellGroupData[{

Cell["Orthogonal Polynomials", "GuideFunctionsSubsection",
 CellID->5893],

Cell[TextData[{
 Cell[TextData[ButtonBox["LegendreP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LegendreP"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HermiteH",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HermiteH"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LaguerreL",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LaguerreL"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JacobiP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiP"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GegenbauerC",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GegenbauerC"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ChebyshevT",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ChebyshevT"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ChebyshevU",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ChebyshevU"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ZernikeR",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ZernikeR"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SphericalHarmonicY",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SphericalHarmonicY"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1949]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Bessel-Related Functions \[RightGuillemet]",
 
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/BesselRelatedFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->69504582],

Cell[TextData[{
 Cell[TextData[ButtonBox["BesselJ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BesselJ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BesselY",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BesselY"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BesselI",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BesselI"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BesselK",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BesselK"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AiryAi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AiryAi"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AiryAiPrime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AiryAiPrime"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SphericalBesselJ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SphericalBesselJ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["KelvinBer",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/KelvinBer"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HankelH1",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HankelH1"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StruveH",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StruveH"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/BesselRelatedFunctions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->10844]
}, Open  ]],

Cell[CellGroupData[{

Cell["Legendre-Related Functions", "GuideFunctionsSubsection",
 CellID->22777],

Cell[TextData[{
 Cell[TextData[ButtonBox["LegendreP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LegendreP"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LegendreQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LegendreQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SpheroidalPS",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalPS"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SpheroidalQS",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalQS"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->19285]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Hypergeometric Functions \[RightGuillemet]",
 
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/HypergeometricFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->26200],

Cell[TextData[{
 Cell[TextData[ButtonBox["Hypergeometric2F1",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hypergeometric2F1"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HypergeometricPFQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HypergeometricPFQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HypergeometricU",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HypergeometricU"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MeijerG",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MeijerG"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AppellF1",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AppellF1"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/HypergeometricFunctions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->14590]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Elliptic Integrals \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/EllipticIntegrals"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->10285],

Cell[TextData[{
 Cell[TextData[ButtonBox["EllipticK",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticK"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EllipticF",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EllipticE",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticE"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EllipticPi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticPi"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/EllipticIntegrals"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->28325]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Elliptic Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/EllipticFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->17118],

Cell[TextData[{
 Cell[TextData[ButtonBox["JacobiSN",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiSN"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseJacobiSN",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseJacobiSN"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WeierstrassP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/WeierstrassP"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EllipticTheta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticTheta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/EllipticFunctions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->25668]
}, Open  ]],

Cell[CellGroupData[{

Cell["Modular Forms", "GuideFunctionsSubsection",
 CellID->10006],

Cell[TextData[{
 Cell[TextData[ButtonBox["DedekindEta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DedekindEta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["KleinInvariantJ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/KleinInvariantJ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ModularLambda",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ModularLambda"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SiegelTheta",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SiegelTheta"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->9729]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Zeta Functions & Polylogarithms \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ZetaFunctionsAndPolylogarithms"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->24008],

Cell[TextData[{
 Cell[TextData[ButtonBox["Zeta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Zeta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PolyLog",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PolyLog"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LerchPhi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LerchPhi"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RiemannSiegelZ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RiemannSiegelZ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ZetaFunctionsAndPolylogarithms"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->14541]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Mathieu Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathieuAndRelatedFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->225],

Cell[TextData[{
 Cell[TextData[ButtonBox["MathieuS",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MathieuS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MathieuSPrime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MathieuSPrime"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MathieuC",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MathieuC"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MathieuCharacteristicA",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MathieuCharacteristicA"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathieuAndRelatedFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->15536]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Spheroidal Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/SpheroidalAndRelatedFunctions"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->11980],

Cell[TextData[{
 Cell[TextData[ButtonBox["SpheroidalPS",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalPS"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SpheroidalS1",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalS1"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SpheroidalEigenvalue",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalEigenvalue"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/SpheroidalAndRelatedFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->716]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Inverse Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/InverseFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->30470],

Cell[TextData[{
 Cell[TextData[ButtonBox["ProductLog",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ProductLog"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseErf",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseErf"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseGammaRegularized",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseGammaRegularized"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseEllipticNomeQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseEllipticNomeQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseWeierstrassP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseWeierstrassP"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BesselJZero",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BesselJZero"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ZetaZero",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ZetaZero"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InverseFunctions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->15384],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["N",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/N"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " numerical evaluation to any precision"
}], "GuideText",
 CellID->20328],

Cell[TextData[{
 Cell[TextData[ButtonBox["FunctionExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FunctionExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " expand in terms of simpler functions"
}], "GuideText",
 CellID->27936],

Cell[TextData[{
 Cell[TextData[ButtonBox["FullSimplify",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FullSimplify"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " apply full symbolic simplification "
}], "GuideText",
 CellID->6204],

Cell["\t", "GuideDelimiter",
 CellID->300702272],

Cell[TextData[{
 Cell[TextData[ButtonBox["Derivative",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Derivative"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["'",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Derivative"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " symbolic and numerical derivatives for arguments and parameters"
}], "GuideText",
 CellID->7523],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindRoot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindRoot"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " find numerical zeros of functions"
}], "GuideText",
 CellID->26364]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->1411],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "GuideTutorial",
 CellID->16541]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->11504],

Cell[TextData[ButtonBox["Functions for Separable Coordinate Systems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsForSeparableCoordinateSystems"]], "GuideMoreAbout",
 CellID->23483],

Cell[TextData[ButtonBox["Functions Used in Optics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInOptics"]], "GuideMoreAboutSub",
 CellID->21766],

Cell[TextData[ButtonBox["Functions Used in Quantum Mechanics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsUsedInQuantumMechanics"]], "GuideMoreAbout",
 CellID->16141],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "GuideMoreAbout",
 CellID->2670],

Cell[TextData[ButtonBox["New in 6.0: Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]], "GuideMoreAbout",
 CellID->373399802]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1456509005],

Cell[TextData[{
 ButtonBox["Demonstrations related to Special Functions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22special+functions%22+content%3AAiryAi+OR+AiryAiPrime+OR+AppellF1+OR+BesselI+\
OR+BesselJ+OR+BesselJZero+OR+BesselK+OR+BesselY+OR+Beta+OR+ChebyshevT+OR+\
ChebyshevU+OR+DedekindEta+OR+Derivative+OR+EllipticE+OR+EllipticF+OR+\
EllipticK+OR+EllipticPi+OR+EllipticTheta+OR+Erf+OR+Erfc+OR+ExpIntegralE+OR+\
ExpIntegralEi+OR+FindRoot+OR+FresnelS+OR+FullSimplify+OR+FunctionExpand+OR+\
Gamma+OR+GegenbauerC+OR+HankelH1+OR+HermiteH+OR+Hypergeometric2F1+OR+\
HypergeometricPFQ+OR+HypergeometricU+OR+InverseEllipticNomeQ+OR+InverseErf+OR+\
InverseGammaRegularized+OR+InverseJacobiSN+OR+InverseWeierstrassP+OR+JacobiP+\
OR+JacobiSN+OR+KelvinBer+OR+KleinInvariantJ+OR+LaguerreL+OR+LegendreP+OR+\
LegendreQ+OR+LerchPhi+OR+LogGamma+OR+LogIntegral+OR+MathieuC+OR+\
MathieuCharacteristicA+OR+MathieuS+OR+MathieuSPrime+OR+MeijerG+OR+\
ModularLambda+OR+N+OR+Pochhammer+OR+PolyGamma+OR+PolyLog+OR+ProductLog+OR+\
RiemannSiegelZ+OR+SiegelTheta+OR+SinIntegral+OR+SphericalBesselJ+OR+\
SphericalHarmonicY+OR+SpheroidalEigenvalue+OR+SpheroidalPS+OR+SpheroidalQS+OR+\
SpheroidalS1+OR+StruveH+OR+WeierstrassP+OR+ZernikeR+OR+Zeta+OR+ZetaZero"], 
    None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->210329322]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Special Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 5.2532214}", "context" -> "", 
    "keywords" -> {
     "'", "0F0", "1F0", "1F2", "2F1", "2F2", "2F3", "3F2", "4F3", "5F4", 
      "6F5", "absolute invariant", "ai", "airy", "Airy Ai", "Airy Ai prime", 
      "Airy derivative", "Airy functions", "algebraic simplification", 
      "Appell hypergeometric function", "approximations", "ar", 
      "artificial intelligence", "assertions", "assumptions", 
      "band structure calculations", "band\\[Hyphen]limited functions", 
      "Barnes extended hypergeometric function", "Bessel equation", 
      "Bessel functions", "Bessel function simplification", "Bessel I", 
      "Bessel J", "Bessel zero", "beta function", "Blanch's Newton method", 
      "Brent method", "Catalan beta function", "CE", "Chebychev", 
      "Chebyshev functions", "Chebyshev polynomial", "Chebyshov", 
      "circle polynomials", "Clausen function", "cleaning up expressions", 
      "combinatorial explosion", "combinatorial simplification", 
      "common roots of equations", "complementary error function", 
      "complete elliptic integral", "complete simplification", 
      "compound arguments", "compress expression", "concise form", 
      "confidence intervals", "conical functions", "constraints", 
      "Cornu spiral", "cylindrical functions", "decimal places", 
      "Dedekind elliptic function", "Dedekind eta", "density of primes", 
      "derivative of Mathieu function S", "derivative of Mathieu function SE",
       "derivative symbol", "differential equations", 
      "differentiate function", "digamma function", "dilog", 
      "dilogarithm function", "Dirichlet L series", 
      "double-periodic function", "doubly periodic function", "efficiency", 
      "ei", "eigenvalue", "electron wave functions", "elliptic functions", 
      "elliptic integral", "elliptic integral of first kind", 
      "elliptic integral of second kind", 
      "elliptic integral of the third kind", "elliptic Jacobi function", 
      "elliptic lambda function", "elliptic modulus", "elliptic nome", 
      "elliptic pi", "elliptic theta", "elliptical geometries", "ellipticce", 
      "ellipticck", "ellipticcpi", "en-function", "error", "error function", 
      "Euler beta function", "Euler gamma function", 
      "Euler-Maclaurin summation", "exp integral", "exp integral ei", 
      "expanding", "expanding special constants", 
      "expanding special functions", "expanding special sequences", "expint", 
      "exponential function", "exponential integral", "expressions", 
      "factorial function", "factorial simplification", 
      "Fermi-Dirac integrals", "find root", "Floquet solution", "formulas", 
      "Fresnel diffraction", "Fresnel functions", "Fresnel integral", 
      "Fresnel integral S", "full simplify", "function expand", 
      "gamma function", "gamma function simplification", 
      "Gauss hypergeometric function", "Gauss series", 
      "Gaussian distribution", "Gaussian random numbers", 
      "Gegenbauer functions", "Gegenbauer polynomials", 
      "generalized factorial", "generalized hypergeometric function", 
      "generalized zeta function", "G-function", 
      "half\\[Hyphen]period values", "Hankel function of the first kind", 
      "Hankel functions", "Hankel H1", "Hermite functions", "Hermite H", 
      "heuristics", "Hill's equation", "Hurwitz zeta function", "hypergeom", 
      "hypergeometric 2F1", "hypergeometric functions", "hyperlogarithm", 
      "hyperspherical polynomials", "identities", "incomplete beta function", 
      "incomplete elliptic integral", "incomplete gamma function", 
      "inverse elliptic nome", "inverse erf", "inverse gamma regularized", 
      "inverse Jacobi", "inverse Jacobi elliptic function sn", 
      "inverse Jacobi SN", "inverse regularized gamma", "inverse Weierstrass",
       "inverse Weierstrass elliptic function", "iterative root finding", 
      "Jacobi elliptic functions", "Jacobi elliptic function sn", 
      "Jacobi functions", "Jacobi polynomial", "Jacobi polynomials", 
      "Jacobi theta 1", "Jacobi theta 2", "Jacobi theta 3", "Jacobi theta 4", 
      "Jonquiere's function", "Kelvin ber", "Kelvin functions", 
      "Klein invariant", "Kummer series", "Laguerre functions", 
      "Lambert function", "Lambert's W-function", "LambertW", 
      "LambertW function", "law of big numbers", 
      "Legendre function of second kind", "Legendre functions", 
      "Legendre polynomials", "Lerch function Phi", "Lerch phi", 
      "Lerch transcendent", "li", "ln gamma", "lngamma", "log gamma", 
      "log integral", "logarithm", "logarithmic gamma", 
      "logarithmic integral", "logarithm of gamma function", "log-gamma", 
      "L-series in number theory", "Mathieu characteristic", 
      "Mathieu function C", "Mathieu function S", "Mathieu function S prime", 
      "Mathieu functions", "mathieu prime", "MathieuS", "mathueua", 
      "Meijer G", "Meijer G-function", "Meijer's G-function", "modular angle",
       "modular form", "modular forms", "modular function", "modular lambda", 
      "multivariate hypergeometric function", "Neumann function", 
      "Newton-Raphson method", "Newton's method", "Nielsen functions", 
      "number theory", "numerical root finding", "optical aberrations", 
      "parametric amplifiers", "partial derivative", "Paul traps", 
      "pendulum problem", "penning traps", "periodic potentials", "pfq", 
      "phi", "Pochhammer", "Pochhammer symbol", "poly gamma", "poly log", 
      "poly-gamma", "polylogarithm", "predicates", "prime character", 
      "product log", "psi", "psi function", "radial polynomials", 
      "radical simplification", "rate of change", "reduction formulas", 
      "reflection formula", "reflection formulas", "relations", 
      "Riemann hypothesis", "Riemann P function", "Riemann Siegel", 
      "Riemann theta function", "Riemann zeta function", "Riemann-Siegel", 
      "Riemann-Siegel formula", "Riemann-Siegel theta", "ring functions", 
      "rising factorial", "roots", "Schrodinger equation", 
      "Schro\"dinger equation", "SE", "Secant method", "shortest form", "si", 
      "Siegel theta", "Siegel theta function", "simplest forms", 
      "simplification", "sin integral", "sine integral", "sinus integral", 
      "smallest form", "sn", "snoid", "solid-state physics", 
      "solve algebraic equations", "solving systems of equations", 
      "special function simplification", "special functions", "speed", 
      "Spence's integral", "spherical bessel", "spherical Bessel function", 
      "spherical Bessel J", "spherical harmonic", "spherical harmonic Y", 
      "spherical harmonics", "spheroidal eigenvalue", "spheroidal functions", 
      "spheroidal harmonics", "spheroidal s1", "square roots", 
      "squash expression", "Ssi", "statistics", "Struve function", 
      "Struve function H", "sums of reciprocal powers", "Tchebycheff ", 
      "theorem proving", "theta functions", "theta1", "theta2", "theta3", 
      "theta4", "toroidal functions", "transcendental equations", 
      "transcendental equations numerical solving", 
      "transcendental roots numerical solving", "transformations", 
      "tree generating function", "trigonometric simplification", 
      "trilogarithm", "Tschebyscheff polynomials", 
      "ultraspherical polynomials", "Weber functions", 
      "Weierstrass elliptic function", "Weierstrass elliptic functions", 
      "Weierstrass P", "zeros of Bessel functions", "zeta function", 
      "zeta function root", "zeta zero"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Two decades of intense R&D at Wolfram Research have given Mathematica by \
far the world's broadest and deepest coverage of special functions--and \
greatly expanded the whole domain of practical closed-form solutions. Often \
using original results and methods, all special functions in Mathematica \
support arbitrary-precision evaluation for all complex values of parameters, \
arbitrary series expansion even at branch points, and an immense web of exact \
relations, transformations and simplifications.", "synonyms" -> {}, "title" -> 
    "Special Functions", "type" -> "Guide", "uri" -> 
    "guide/SpecialFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 54, 1, 70, "GuideTitle",
 CellID->9034],
Cell[676, 28, 661, 14, 70, "GuideAbstract",
 CellID->121864640],
Cell[CellGroupData[{
Cell[1362, 46, 385, 11, 70, "GuideFunctionsSubsection",
 CellID->1344],
Cell[1750, 59, 1241, 36, 70, "InlineGuideFunctionListing",
 CellID->32736]
}, Open  ]],
Cell[CellGroupData[{
Cell[3028, 100, 266, 6, 70, "GuideFunctionsSubsection",
 CellID->22037],
Cell[3297, 108, 1679, 48, 70, "InlineGuideFunctionListing",
 CellID->5416]
}, Open  ]],
Cell[CellGroupData[{
Cell[5013, 161, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->5893],
Cell[5089, 164, 2028, 56, 70, "InlineGuideFunctionListing",
 CellID->1949]
}, Open  ]],
Cell[CellGroupData[{
Cell[7154, 225, 235, 6, 70, "GuideFunctionsSubsection",
 CellID->69504582],
Cell[7392, 233, 2720, 74, 70, "InlineGuideFunctionListing",
 CellID->10844]
}, Open  ]],
Cell[CellGroupData[{
Cell[10149, 312, 78, 1, 70, "GuideFunctionsSubsection",
 CellID->22777],
Cell[10230, 315, 1118, 29, 70, "InlineGuideFunctionListing",
 CellID->19285]
}, Open  ]],
Cell[CellGroupData[{
Cell[11385, 349, 233, 6, 70, "GuideFunctionsSubsection",
 CellID->26200],
Cell[11621, 357, 1284, 35, 70, "InlineGuideFunctionListing",
 CellID->14590]
}, Open  ]],
Cell[CellGroupData[{
Cell[12942, 397, 219, 5, 70, "GuideFunctionsSubsection",
 CellID->10285],
Cell[13164, 404, 1032, 29, 70, "InlineGuideFunctionListing",
 CellID->28325]
}, Open  ]],
Cell[CellGroupData[{
Cell[14233, 438, 219, 5, 70, "GuideFunctionsSubsection",
 CellID->17118],
Cell[14455, 445, 1054, 29, 70, "InlineGuideFunctionListing",
 CellID->25668]
}, Open  ]],
Cell[CellGroupData[{
Cell[15546, 479, 65, 1, 70, "GuideFunctionsSubsection",
 CellID->10006],
Cell[15614, 482, 988, 26, 70, "InlineGuideFunctionListing",
 CellID->9729]
}, Open  ]],
Cell[CellGroupData[{
Cell[16639, 513, 247, 6, 70, "GuideFunctionsSubsection",
 CellID->24008],
Cell[16889, 521, 1040, 30, 70, "InlineGuideFunctionListing",
 CellID->14541]
}, Open  ]],
Cell[CellGroupData[{
Cell[17966, 556, 225, 5, 70, "GuideFunctionsSubsection",
 CellID->225],
Cell[18194, 563, 1072, 30, 70, "InlineGuideFunctionListing",
 CellID->15536]
}, Open  ]],
Cell[CellGroupData[{
Cell[19303, 598, 233, 5, 70, "GuideFunctionsSubsection",
 CellID->11980],
Cell[19539, 605, 1302, 33, 70, "InlineGuideFunctionListing",
 CellID->716]
}, Open  ]],
Cell[CellGroupData[{
Cell[20878, 643, 217, 5, 70, "GuideFunctionsSubsection",
 CellID->30470],
Cell[21098, 650, 2025, 53, 70, "InlineGuideFunctionListing",
 CellID->15384],
Cell[23126, 705, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[23177, 708, 243, 8, 70, "GuideText",
 CellID->20328],
Cell[23423, 718, 268, 8, 70, "GuideText",
 CellID->27936],
Cell[23694, 728, 262, 8, 70, "GuideText",
 CellID->6204],
Cell[23959, 738, 48, 1, 70, "GuideDelimiter",
 CellID->300702272],
Cell[24010, 741, 414, 13, 70, "GuideText",
 CellID->7523],
Cell[24427, 756, 253, 8, 70, "GuideText",
 CellID->26364]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24729, 770, 57, 1, 70, "GuideTutorialsSection",
 CellID->1411],
Cell[24789, 773, 148, 3, 70, "GuideTutorial",
 CellID->16541]
}, Open  ]],
Cell[CellGroupData[{
Cell[24974, 781, 59, 1, 70, "GuideMoreAboutSection",
 CellID->11504],
Cell[25036, 784, 196, 4, 70, "GuideMoreAbout",
 CellID->23483],
Cell[25235, 790, 161, 3, 70, "GuideMoreAboutSub",
 CellID->21766],
Cell[25399, 795, 182, 4, 70, "GuideMoreAbout",
 CellID->16141],
Cell[25584, 801, 165, 3, 70, "GuideMoreAbout",
 CellID->2670],
Cell[25752, 806, 179, 3, 70, "GuideMoreAbout",
 CellID->373399802]
}, Open  ]],
Cell[CellGroupData[{
Cell[25968, 814, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1456509005],
Cell[26041, 817, 1560, 30, 70, "GuideRelatedLinks",
 CellID->210329322]
}, Open  ]],
Cell[27616, 850, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

