(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9870,        307]
NotebookOptionsPosition[      7125,        224]
NotebookOutlinePosition[      8457,        258]
CellTagsIndexPosition[      8414,        255]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Spheroidal and Related Functions", "GuideTitle",
 CellID->10845],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell["Azimuthal Functions", "GuideFunctionsSubsection",
 CellID->8266],

Cell[TextData[{
 Cell[TextData[ButtonBox["SpheroidalPS",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalPS"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SpheroidalQS",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalQS"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SpheroidalPSPrime",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalPSPrime"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SpheroidalQSPrime",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalQSPrime"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->5857]
}, Open  ]],

Cell[CellGroupData[{

Cell["Radial Functions", "GuideFunctionsSubsection",
 CellID->22678],

Cell[TextData[{
 Cell[TextData[ButtonBox["SpheroidalS1",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalS1"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SpheroidalS2",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalS2"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SpheroidalS1Prime",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalS1Prime"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SpheroidalS2Prime",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalS2Prime"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->14199]
}, Open  ]],

Cell[CellGroupData[{

Cell["Auxiliary Functions", "GuideFunctionsSubsection",
 CellID->12674],

Cell[TextData[{
 Cell[TextData[ButtonBox["SpheroidalEigenvalue",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalEigenvalue"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SpheroidalJoiningFactor",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalJoiningFactor"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SpheroidalRadialFactor",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalRadialFactor"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->14155]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->25191],

Cell[TextData[ButtonBox["Spheroidal Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpheroidalFunctions"]], "GuideTutorial",
 CellID->8990]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->30858],

Cell[TextData[ButtonBox["Bessel-Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BesselRelatedFunctions"]], "GuideMoreAbout",
 CellID->10996],

Cell[TextData[ButtonBox["Functions for Separable Coordinate Systems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsForSeparableCoordinateSystems"]], "GuideMoreAbout",
 CellID->471342786],

Cell[TextData[ButtonBox["Functions Used in Quantum Mechanics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsUsedInQuantumMechanics"]], "GuideMoreAboutSub",
 CellID->1707],

Cell[TextData[ButtonBox["Functions Used in Optics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInOptics"]], "GuideMoreAboutSub",
 CellID->452199006],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "GuideMoreAboutSub",
 CellID->3967]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->380754882],

Cell[TextData[{
 ButtonBox["Demonstrations related to Spheroidal and Related Functions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
SpheroidalEigenvalue+OR+SpheroidalJoiningFactor+OR+SpheroidalPS+OR+\
SpheroidalPSPrime+OR+SpheroidalQS+OR+SpheroidalQSPrime+OR+\
SpheroidalRadialFactor+OR+SpheroidalS1+OR+SpheroidalS1Prime+OR+SpheroidalS2+\
OR+SpheroidalS2Prime)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->151753517]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Spheroidal and Related Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 7.5657806}", "context" -> "", 
    "keywords" -> {
     "band\\[Hyphen]limited functions", "eigenvalue", 
      "radial spheroidal functions", "spheroidal eigenvalue", 
      "spheroidal functions", "spheroidal harmonics", 
      "spheroidal joining factor", "spheroidal prime", 
      "spheroidal radial factor", "spheroidal s1", "spheroidal s1 prime", 
      "spheroidal s2", "spheroidal s2 prime"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> "", "synonyms" -> {}, "title" -> 
    "Spheroidal and Related Functions", "type" -> "Guide", "uri" -> 
    "guide/SpheroidalAndRelatedFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 70, 1, 70, "GuideTitle",
 CellID->10845],
Cell[692, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[773, 33, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->8266],
Cell[846, 36, 1439, 35, 70, "InlineGuideFunctionListing",
 CellID->5857]
}, Open  ]],
Cell[CellGroupData[{
Cell[2322, 76, 68, 1, 70, "GuideFunctionsSubsection",
 CellID->22678],
Cell[2393, 79, 1440, 35, 70, "InlineGuideFunctionListing",
 CellID->14199]
}, Open  ]],
Cell[CellGroupData[{
Cell[3870, 119, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->12674],
Cell[3944, 122, 1117, 26, 70, "InlineGuideFunctionListing",
 CellID->14155]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5110, 154, 58, 1, 70, "GuideTutorialsSection",
 CellID->25191],
Cell[5171, 157, 153, 3, 70, "GuideTutorial",
 CellID->8990]
}, Open  ]],
Cell[CellGroupData[{
Cell[5361, 165, 59, 1, 70, "GuideMoreAboutSection",
 CellID->30858],
Cell[5423, 168, 159, 3, 70, "GuideMoreAbout",
 CellID->10996],
Cell[5585, 173, 200, 4, 70, "GuideMoreAbout",
 CellID->471342786],
Cell[5788, 179, 184, 4, 70, "GuideMoreAboutSub",
 CellID->1707],
Cell[5975, 185, 165, 3, 70, "GuideMoreAboutSub",
 CellID->452199006],
Cell[6143, 190, 148, 3, 70, "GuideMoreAboutSub",
 CellID->3967]
}, Open  ]],
Cell[CellGroupData[{
Cell[6328, 198, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->380754882],
Cell[6400, 201, 683, 18, 70, "GuideRelatedLinks",
 CellID->151753517]
}, Open  ]],
Cell[7098, 222, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

