(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15429,        441]
NotebookOptionsPosition[     10885,        331]
NotebookOutlinePosition[     13837,        388]
CellTagsIndexPosition[     13794,        385]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Statistical Distributions", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports all standard statistical distributions, giving access to both \
numerical and exact symbolic results",
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic character makes it possible to represent statistical \
distributions in a convenient symbolic form that can immediately be combined \
and manipulated."
}], "GuideAbstract",
 CellID->135112828],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Continuous Distributions \[RightGuillemet]",
 
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ContinuousStatisticalDistributions"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->286444997],

Cell[TextData[{
 Cell[TextData[ButtonBox["NormalDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NormalDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ChiSquareDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ChiSquareDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StudentTDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/StudentTDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LogNormalDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LogNormalDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BetaDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BetaDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ExtremeValueDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ExtremeValueDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ContinuousStatisticalDistributions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->49235723]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Discrete Distributions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DiscreteStatisticalDistributions"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->347614754],

Cell[TextData[{
 Cell[TextData[ButtonBox["PoissonDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PoissonDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BinomialDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinomialDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HypergeometricDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HypergeometricDistribution"]], "InlineFunctionSans",
  
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DiscreteStatisticalDistributions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->279746668]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Properties \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DescriptiveStatistics"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->4803021],

Cell[TextData[{
 Cell[TextData[ButtonBox["PDF",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PDF"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["CDF",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CDF"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "probability density function, cumulative density function"
}], "GuideText",
 CellID->122109823],

Cell[TextData[{
 Cell[TextData[ButtonBox["Mean",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Mean"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Variance",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Variance"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Quantile",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Quantile"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Skewness",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Skewness"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Kurtosis",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Kurtosis"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DescriptiveStatistics"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->92590393],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExpectedValue",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ExpectedValue"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "expected value of any quantity"
}], "GuideText",
 CellID->86496550]
}, Open  ]],

Cell[CellGroupData[{

Cell["Samples from Distributions", "GuideFunctionsSubsection",
 CellID->101813989],

Cell[TextData[{
 Cell[TextData[ButtonBox["RandomReal",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomReal"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RandomInteger",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomInteger"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->356096803]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "GuideTutorial",
 CellID->634501723],

Cell[TextData[ButtonBox["Discrete Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DiscreteDistributions"]], "GuideTutorial",
 CellID->1885805579]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->624792881],

Cell[TextData[{
 ButtonBox["Demonstrations related to Statistical Distributions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
BetaDistribution+OR+BinomialDistribution+OR+CDF+OR+ChiSquareDistribution+OR+\
ExpectedValue+OR+ExtremeValueDistribution+OR+HypergeometricDistribution+OR+\
Kurtosis+OR+LogNormalDistribution+OR+Mean+OR+NormalDistribution+OR+PDF+OR+\
PoissonDistribution+OR+Quantile+OR+RandomInteger+OR+RandomReal+OR+Skewness+OR+\
StudentTDistribution+OR+Variance)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->806010412]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Statistical Distributions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 10.5346066}", "context" -> "", 
    "keywords" -> {
     "asymmetry", "average", "avg", "beta distribution", 
      "binomial distribution", "binomial trials", "CDF", 
      "chi square distribution", "chi squared distribution", "coin tossing", 
      "confidence intervals", "cumulative distribution function", "deciles", 
      "density function", "dispersion", "distribution", 
      "distribution function", "empirical distribution", "expectation", 
      "expected value", "extreme value distribution", 
      "extreme-value distribution", "Fisher kurtosis", "Fisher's kurtosis", 
      "Fisher-Tippett distribution", "Gauss integral", 
      "Gaussian distribution", "Gaussian integral", "heavy tails", 
      "hypergeometric distribution", "infrequent events", 
      "interquartile range", "inverse CDF", "kurtosis", "kurtosis excess", 
      "location", "log normal distribution", "lognormal", 
      "lognormal distribution", "log\\[Hyphen]Weibull distribution", 
      "long tails", "mass function", "mean", "non-frequent events", 
      "normal distribution", "order statistics", "Pearson chi square", 
      "Pearson chi squared", "percentiles", "Poisson distribution", 
      "Poisson process", "prob", "probability density function", 
      "probability distribution", "probability function", 
      "probability mass function", "quantile", "quartiles", "rand", 
      "random integer", "random real", "randomint", "rare events", "rnd", 
      "sample variance", "sampling without replacement", "shape", 
      "shape statistic", "skew", "spread", "standard normal distribution", 
      "statistical expectation", "student distribution", "t distribution", 
      "urn problem", "VAR", "variance", "Weibull quantile method"}, "index" -> 
    True, "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica supports all standard statistical distributions, giving \
access to both numerical and exact symbolic results. Mathematica's symbolic \
character makes it possible to represent statistical distributions in a \
convenient symbolic form that can immediately be combined and manipulated.", 
    "synonyms" -> {}, "title" -> "Statistical Distributions", "type" -> 
    "Guide", "uri" -> "guide/StatisticalDistributions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 67, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[689, 28, 442, 12, 70, "GuideAbstract",
 CellID->135112828],
Cell[CellGroupData[{
Cell[1156, 44, 248, 6, 70, "GuideFunctionsSubsection",
 CellID->286444997],
Cell[1407, 52, 2475, 60, 70, "InlineGuideFunctionListing",
 CellID->49235723]
}, Open  ]],
Cell[CellGroupData[{
Cell[3919, 117, 242, 5, 70, "GuideFunctionsSubsection",
 CellID->347614754],
Cell[4164, 124, 1356, 34, 70, "InlineGuideFunctionListing",
 CellID->279746668]
}, Open  ]],
Cell[CellGroupData[{
Cell[5557, 163, 217, 5, 70, "GuideFunctionsSubsection",
 CellID->4803021],
Cell[5777, 170, 683, 19, 70, "GuideText",
 CellID->122109823],
Cell[6463, 191, 1519, 41, 70, "InlineGuideFunctionListing",
 CellID->92590393],
Cell[7985, 234, 413, 12, 70, "GuideText",
 CellID->86496550]
}, Open  ]],
Cell[CellGroupData[{
Cell[8435, 251, 82, 1, 70, "GuideFunctionsSubsection",
 CellID->101813989],
Cell[8520, 254, 700, 17, 70, "InlineGuideFunctionListing",
 CellID->356096803]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9269, 277, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[9334, 280, 166, 3, 70, "GuideTutorial",
 CellID->634501723],
Cell[9503, 285, 163, 3, 70, "GuideTutorial",
 CellID->1885805579]
}, Open  ]],
Cell[CellGroupData[{
Cell[9703, 293, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[9768, 296, 174, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],
Cell[CellGroupData[{
Cell[9979, 304, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->624792881],
Cell[10051, 307, 792, 19, 70, "GuideRelatedLinks",
 CellID->806010412]
}, Open  ]],
Cell[10858, 329, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

