(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21114,        669]
NotebookOptionsPosition[     14328,        502]
NotebookOutlinePosition[     18185,        572]
CellTagsIndexPosition[     18142,        569]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["String Manipulation", "GuideTitle",
 CellID->24816],

Cell[TextData[{
 "Integrated into the core ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language is industrial-strength string manipulation, not only with \
ordinary regular expressions, but also with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s own powerful general symbolic string-pattern language. "
}], "GuideAbstract",
 CellID->232740425],

Cell[TextData[{
 Cell[BoxData["\"\<string\>\""], "InlineCode"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " a string, allowing Unicode or special characters"
}], "GuideText",
 CellID->18259],

Cell["\t", "GuideDelimiterSubsection",
 CellID->20851],

Cell[CellGroupData[{

Cell["Structural Operations", "GuideFunctionsSubsection",
 CellID->32271],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringJoin",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringJoin"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["<>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringJoin"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " join strings together"
}], "GuideText",
 CellID->23283],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringLength",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringLength"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "length of a string"
}], "GuideText",
 CellID->4364],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringSplit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringSplit"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "split a string into words or other units"
}], "GuideText",
 CellID->27038],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringTake",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringTake"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["StringDrop",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringDrop"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "take or drop parts of a string"
}], "GuideText",
 CellID->3012],

Cell["\t", "GuideDelimiterSubsection",
 CellID->3184]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["String Patterns \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/StringPatterns"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->21759],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringExpression",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringExpression"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a symbolic string expression including symbolic string patterns"
}], "GuideText",
 CellID->23501],

Cell[TextData[{
 Cell[TextData[ButtonBox["Longest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Longest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Shortest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Shortest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Except",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Except"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Whitespace",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Whitespace"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NumberString",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NumberString"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StringPatterns"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->9574],

Cell["\t", "GuideDelimiterSubsection",
 CellID->28733]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Operations on Strings \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/StringOperations"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->385565936],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringReplace",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringReplace"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "make replacements for string patterns"
}], "GuideText",
 CellID->5059],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringCases",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringCases"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find cases of string patterns"
}], "GuideText",
 CellID->27714],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringFreeQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringFreeQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test whether a string is free of a string pattern"
}], "GuideText",
 CellID->27649],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringCount",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringCount"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StringPosition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringPosition"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StringOperations"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->6595],

Cell["\t", "GuideDelimiter",
 CellID->28522],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sort",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sort"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "sort strings alphabetically or otherwise"
}], "GuideText",
 CellID->24541],

Cell[TextData[{
 Cell[TextData[ButtonBox["Riffle",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Riffle"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " riffle lists of objects ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["x", "TI"], ",", 
    StyleBox["a", "TI"], ",", 
    StyleBox["x", "TI"], ",", 
    StyleBox["a", "TI"], ",", 
    StyleBox["x", "TI"], ",", 
    StyleBox["a", "TI"]}], "}"}]], "InlineFormula"]
}], "GuideText",
 CellID->20416],

Cell[TextData[{
 Cell[TextData[ButtonBox["Nearest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Nearest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find strings nearest in edit distance"
}], "GuideText",
 CellID->15377],

Cell[TextData[{
 Cell[TextData[ButtonBox["HammingDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HammingDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EditDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/EditDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FindClusters",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FindClusters"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hash",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hash"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StringFormat",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/StringFormat"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->194145169],

Cell[TextData[{
 Cell[TextData[ButtonBox["DictionaryLookup",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DictionaryLookup"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " look up strings in an English dictionary"
}], "GuideText",
 CellID->391776547],

Cell["\t", "GuideDelimiter",
 CellID->276048146],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToString",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToString"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ToExpression",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToExpression"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert between expressions and strings >>>"
}], "GuideText",
 CellID->1052],

Cell[TextData[{
 Cell[TextData[ButtonBox["ImportString",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ImportString"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ExportString",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ExportString"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "translate many formats of strings"
}], "GuideText",
 CellID->565],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"XML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XML"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"Table\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Table"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ImportingAndExporting"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->19891],

Cell["\t", "GuideDelimiterSubsection",
 CellID->138]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Character Operations \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CharacterOperations"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->13310],

Cell[TextData[{
 Cell[TextData[ButtonBox["Characters",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Characters"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "break a string into a list of characters"
}], "GuideText",
 CellID->20967],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToUpperCase",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToUpperCase"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ToCharacterCode",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToCharacterCode"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LetterQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LetterQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/CharacterOperations"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->15055]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->13787],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "GuideTutorial",
 CellID->4795],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "GuideTutorial",
 CellID->215773380]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->16439],

Cell[TextData[ButtonBox["Text Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProcessingTextualData"]], "GuideMoreAbout",
 CellID->27441],

Cell[TextData[ButtonBox["Converting between Expressions & Strings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConvertingBetweenExpressionsAndStrings"]], "GuideMoreAboutSub",\

 CellID->19368],

Cell[TextData[ButtonBox["Layout & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LayoutAndTables"]], "GuideMoreAbout",
 CellID->6648],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "GuideMoreAbout",
 CellID->26804],

Cell[TextData[ButtonBox["Bitwise Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BitwiseOperations"]], "GuideMoreAboutSub",
 CellID->31441]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"String Manipulation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 12.0346450}", "context" -> "", 
    "keywords" -> {
     "alphabetic", "alphabetic characters", "alphabetizing of lists", 
      "alphabetizing of string", "alphanumeric", "arrange", "ascending order",
       "atoi", "avoiding matches", "breaking strings", "canonical order", 
      "\\catcode (TeX)", "catenating strings", "character class", 
      "collating of strings", "collation", "complementary patterns", 
      "concatenate strings", "construct string from expression", 
      "contain substring", "conversion", "convert expression", 
      "convert to upper case", "counting string matches", "decreasing order", 
      "delete substring", "delimiters", "descending order", 
      "digital fingerprint", "disambiguating pattern matches", 
      "dividing strings", "edit distance", "editing of strings", 
      "excluded patterns", "explode", "export string", 
      "expression conversion", "expression to string", "expressions", 
      "extraction of substrings", "greedy match", "grep", "held expressions", 
      "implode", "import data from string", "import string", 
      "increasing order", "index of substring", "input as string", 
      "interleave", "interpretation of input", "joining strings", 
      "length of string", "Levenshtein distance", "longest pattern match", 
      "longest sequence", "matching strings", "newline", "non-greedy match", 
      "number characters", "number string", "parsing of strings", 
      "parts of strings", "patterns for string", "position of substring", 
      "priorities on pattern matches", "read data from string", 
      "read formatted string", "read string", "regular expression", 
      "replacement of characters", "replacements of substrings", 
      "replace substring", "ReplaceString", "rewriting of strings", 
      "search for substrings", "searching for characters", "sed", 
      "shortest pattern match", "sorting of lists", "sorting of strings", 
      "space", "splitting strings", "string cases", "string count", 
      "string distance", "string drop", "string expression", "string format", 
      "string free", "string from expression", "string join", "string length",
       "string metric", "string order", "string part", "string pattern", 
      "string position", "string replace", "string split", "string take", 
      "StringImport", "substitution in strings", "tab", "TakeString", 
      "test for alphabetic characters", "test for character", 
      "textual form of expression", "to character code", "to expression", 
      "to string", "to upper case", "ToASCII", "toupper", 
      "transform expression to string", "translation of strings", "uc", 
      "uppercase", "using strings as input", "wc", "whitespace", 
      "whitespace character"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Integrated into the core Mathematica language is industrial-strength \
string manipulation, not only with ordinary regular expressions, but also \
with Mathematica's own powerful general symbolic string-pattern language. ", 
    "synonyms" -> {}, "title" -> "String Manipulation", "type" -> "Guide", 
    "uri" -> "guide/StringManipulation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 57, 1, 70, "GuideTitle",
 CellID->24816],
Cell[679, 28, 365, 10, 70, "GuideAbstract",
 CellID->232740425],
Cell[1047, 40, 196, 6, 70, "GuideText",
 CellID->18259],
Cell[1246, 48, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->20851],
Cell[CellGroupData[{
Cell[1325, 53, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->32271],
Cell[1401, 56, 374, 13, 70, "GuideText",
 CellID->23283],
Cell[1778, 71, 250, 9, 70, "GuideText",
 CellID->4364],
Cell[2031, 82, 271, 9, 70, "GuideText",
 CellID->27038],
Cell[2305, 93, 389, 13, 70, "GuideText",
 CellID->3012],
Cell[2697, 108, 53, 1, 70, "GuideDelimiterSubsection",
 CellID->3184]
}, Open  ]],
Cell[CellGroupData[{
Cell[2787, 114, 213, 5, 70, "GuideFunctionsSubsection",
 CellID->21759],
Cell[3003, 121, 304, 9, 70, "GuideText",
 CellID->23501],
Cell[3310, 132, 1522, 41, 70, "InlineGuideFunctionListing",
 CellID->9574],
Cell[4835, 175, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->28733]
}, Open  ]],
Cell[CellGroupData[{
Cell[4926, 181, 225, 5, 70, "GuideFunctionsSubsection",
 CellID->385565936],
Cell[5154, 188, 271, 9, 70, "GuideText",
 CellID->5059],
Cell[5428, 199, 260, 9, 70, "GuideText",
 CellID->27714],
Cell[5691, 210, 280, 9, 70, "GuideText",
 CellID->27649],
Cell[5974, 221, 622, 17, 70, "InlineGuideFunctionListing",
 CellID->6595],
Cell[6599, 240, 44, 1, 70, "GuideDelimiter",
 CellID->28522],
Cell[6646, 243, 257, 9, 70, "GuideText",
 CellID->24541],
Cell[6906, 254, 667, 21, 70, "GuideText",
 CellID->20416],
Cell[7576, 277, 405, 12, 70, "GuideText",
 CellID->15377],
Cell[7984, 291, 1630, 41, 70, "InlineGuideFunctionListing",
 CellID->194145169],
Cell[9617, 334, 425, 11, 70, "GuideText",
 CellID->391776547],
Cell[10045, 347, 48, 1, 70, "GuideDelimiter",
 CellID->276048146],
Cell[10096, 350, 402, 13, 70, "GuideText",
 CellID->1052],
Cell[10501, 365, 399, 13, 70, "GuideText",
 CellID->565],
Cell[10903, 380, 616, 17, 70, "InlineGuideFunctionListing",
 CellID->19891],
Cell[11522, 399, 52, 1, 70, "GuideDelimiterSubsection",
 CellID->138]
}, Open  ]],
Cell[CellGroupData[{
Cell[11611, 405, 223, 5, 70, "GuideFunctionsSubsection",
 CellID->13310],
Cell[11837, 412, 269, 9, 70, "GuideText",
 CellID->20967],
Cell[12109, 423, 834, 23, 70, "InlineGuideFunctionListing",
 CellID->15055]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12992, 452, 58, 1, 70, "GuideTutorialsSection",
 CellID->13787],
Cell[13053, 455, 143, 3, 70, "GuideTutorial",
 CellID->4795],
Cell[13199, 460, 183, 4, 70, "GuideTutorial",
 CellID->215773380]
}, Open  ]],
Cell[CellGroupData[{
Cell[13419, 469, 59, 1, 70, "GuideMoreAboutSection",
 CellID->16439],
Cell[13481, 472, 149, 3, 70, "GuideMoreAbout",
 CellID->27441],
Cell[13633, 477, 199, 5, 70, "GuideMoreAboutSub",
 CellID->19368],
Cell[13835, 484, 142, 3, 70, "GuideMoreAbout",
 CellID->6648],
Cell[13980, 489, 152, 3, 70, "GuideMoreAbout",
 CellID->26804],
Cell[14135, 494, 151, 3, 70, "GuideMoreAboutSub",
 CellID->31441]
}, Open  ]],
Cell[14301, 500, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

