(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15803,        501]
NotebookOptionsPosition[     10496,        367]
NotebookOutlinePosition[     13529,        426]
CellTagsIndexPosition[     13486,        423]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["String Operations", "GuideTitle",
 CellID->8872],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " incorporates the latest highly efficient algorithms to allow operations on \
strings with millions of elements, all making use of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s unique symbolic string patterns. "
}], "GuideAbstract",
 CellID->32668],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringJoin",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringJoin"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " join strings together"
}], "GuideText",
 CellID->20633],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringSplit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringSplit"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " split strings at whitespace, or any specified pattern"
}], "GuideText",
 CellID->3241],

Cell["\t", "GuideDelimiter",
 CellID->5745],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringLength",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringLength"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "length of a string (in Unicode characters)"
}], "GuideText",
 CellID->116256116],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringTake",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringTake"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StringDrop",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringDrop"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StringInsert",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringInsert"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->291318770],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringPosition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringPosition"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " find positions of substrings or string patterns"
}], "GuideText",
 CellID->8956],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringReplacePart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringReplacePart"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " replace substrings at specified positions"
}], "GuideText",
 CellID->846],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringReverse",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringReverse"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " reverse the characters in a string"
}], "GuideText",
 CellID->25524],

Cell["\t", "GuideDelimiter",
 CellID->6966],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringReplace",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringReplace"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " make replacements for substrings or string patterns"
}], "GuideText",
 CellID->15581],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringCases",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringCases"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " give all cases of string patterns in a string"
}], "GuideText",
 CellID->8144],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringCount",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringCount"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " count occurrences of a string pattern"
}], "GuideText",
 CellID->32240],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringFreeQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringFreeQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StringMatchQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringMatchQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StringReplaceList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringReplaceList"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->633636720],

Cell["\t", "GuideDelimiter",
 CellID->11876],

Cell[TextData[{
 Cell[TextData[ButtonBox["Characters",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Characters"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " break a string into a list of characters"
}], "GuideText",
 CellID->25027],

Cell[TextData[{
 Cell[TextData[ButtonBox["Hash",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hash"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "compute hash codes for a string"
}], "GuideText",
 CellID->212819201],

Cell[TextData[{
 Cell[TextData[ButtonBox["ImportString",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ImportString"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ExportString",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ExportString"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "translate between many string formats"
}], "GuideText",
 CellID->122944384],

Cell["\t", "GuideDelimiter",
 CellID->521884361],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringToStream",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringToStream"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "set up a string to be read sequentially"
}], "GuideText",
 CellID->467433],

Cell[TextData[{
 Cell[TextData[ButtonBox["Read",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Read"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Find",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Find"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Skip",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Skip"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SetStreamPosition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SetStreamPosition"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelFileOperations"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->161060632],

Cell["\t", "GuideDelimiterSubsection",
 CellID->7508112],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["String Data Operations \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/StringManipulation"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->183710810],

Cell[TextData[{
 Cell[TextData[ButtonBox["EditDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/EditDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Nearest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Nearest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FindClusters",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FindClusters"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DictionaryLookup",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DictionaryLookup"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StringManipulation"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->479495205]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->1205],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "GuideTutorial",
 CellID->4795],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "GuideTutorial",
 CellID->215773380]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->31641],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "GuideMoreAbout",
 CellID->13465],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "GuideMoreAbout",
 CellID->16191],

Cell[TextData[ButtonBox["Character Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CharacterOperations"]], "GuideMoreAbout",
 CellID->511064812],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "GuideMoreAboutSub",
 CellID->6259],

Cell[TextData[ButtonBox["Converting between Expressions & Strings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConvertingBetweenExpressionsAndStrings"]], "GuideMoreAboutSub",\

 CellID->23700]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"String Operations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 12.9252928}", "context" -> "", 
    "keywords" -> {
     "appending to strings", "breaking strings", "catenating strings", 
      "compare strings", "concatenate strings", "contain substring", 
      "conversion", "counting string matches", "delete substring", 
      "delimiters", "dictionary lookup", "dividing strings", "edit distance", 
      "editing of strings", "explode", "export strings", 
      "extraction of substrings", "grep", "implode", 
      "import data from string", "import string", "index of substring", 
      "insertion of strings", "joining strings", "length of string", 
      "Levenshtein distance", "matching of strings", "matching strings", 
      "multiple string replacements", "palindrome", "partitioning of data", 
      "parts of strings", "position of substring", "prepending to strings", 
      "read data from string", "read formatted string", "read string", 
      "reading from strings", "replace part of string", "replace string", 
      "replace substring", "replacement of characters", 
      "replacements of substrings", "ReplaceString", "reverse characters", 
      "reverse strings", "rewriting of strings", "search for substrings", 
      "searching for characters", "sed", "seek", 
      "sequential reading from files", "sequential searching", 
      "set stream position", "splicing into strings", "splitting strings", 
      "sscanf", "string cases", "string comparison", "string count", 
      "string distance", "string drop", "string free", "string insert", 
      "string join", "string length", "string match", "string metric", 
      "string part", "string position", "string replace", 
      "string replace list", "string replace part", "string reverse", 
      "string split", "string substitution", "string take", 
      "string to stream", "StringImport", "substitution in strings", 
      "TakeString", "translation of strings", "treating strings like files", 
      "wc", "whitespace"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica incorporates the latest highly efficient algorithms to allow \
operations on strings with millions of elements, all making use of \
Mathematica's unique symbolic string patterns. ", "synonyms" -> {}, "title" -> 
    "String Operations", "type" -> "Guide", "uri" -> 
    "guide/StringOperations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 54, 1, 70, "GuideTitle",
 CellID->8872],
Cell[676, 28, 326, 9, 70, "GuideAbstract",
 CellID->32668],
Cell[1005, 39, 245, 8, 70, "GuideText",
 CellID->20633],
Cell[1253, 49, 278, 8, 70, "GuideText",
 CellID->3241],
Cell[1534, 59, 43, 1, 70, "GuideDelimiter",
 CellID->5745],
Cell[1580, 62, 279, 9, 70, "GuideText",
 CellID->116256116],
Cell[1862, 73, 620, 17, 70, "InlineGuideFunctionListing",
 CellID->291318770],
Cell[2485, 92, 278, 8, 70, "GuideText",
 CellID->8956],
Cell[2766, 102, 277, 8, 70, "GuideText",
 CellID->846],
Cell[3046, 112, 264, 8, 70, "GuideText",
 CellID->25524],
Cell[3313, 122, 43, 1, 70, "GuideDelimiter",
 CellID->6966],
Cell[3359, 125, 281, 8, 70, "GuideText",
 CellID->15581],
Cell[3643, 135, 270, 8, 70, "GuideText",
 CellID->8144],
Cell[3916, 145, 263, 8, 70, "GuideText",
 CellID->32240],
Cell[4182, 155, 636, 17, 70, "InlineGuideFunctionListing",
 CellID->633636720],
Cell[4821, 174, 44, 1, 70, "GuideDelimiter",
 CellID->11876],
Cell[4868, 177, 264, 8, 70, "GuideText",
 CellID->25027],
Cell[5135, 187, 252, 9, 70, "GuideText",
 CellID->212819201],
Cell[5390, 198, 409, 13, 70, "GuideText",
 CellID->122944384],
Cell[5802, 213, 48, 1, 70, "GuideDelimiter",
 CellID->521884361],
Cell[5853, 216, 277, 9, 70, "GuideText",
 CellID->467433],
Cell[6133, 227, 1025, 29, 70, "InlineGuideFunctionListing",
 CellID->161060632],
Cell[7161, 258, 56, 1, 70, "GuideDelimiterSubsection",
 CellID->7508112],
Cell[CellGroupData[{
Cell[7242, 263, 228, 5, 70, "GuideFunctionsSubsection",
 CellID->183710810],
Cell[7473, 270, 1637, 41, 70, "InlineGuideFunctionListing",
 CellID->479495205]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9159, 317, 57, 1, 70, "GuideTutorialsSection",
 CellID->1205],
Cell[9219, 320, 143, 3, 70, "GuideTutorial",
 CellID->4795],
Cell[9365, 325, 183, 4, 70, "GuideTutorial",
 CellID->215773380]
}, Open  ]],
Cell[CellGroupData[{
Cell[9585, 334, 59, 1, 70, "GuideMoreAboutSection",
 CellID->31641],
Cell[9647, 337, 142, 3, 70, "GuideMoreAbout",
 CellID->13465],
Cell[9792, 342, 150, 3, 70, "GuideMoreAbout",
 CellID->16191],
Cell[9945, 347, 156, 3, 70, "GuideMoreAbout",
 CellID->511064812],
Cell[10104, 352, 148, 3, 70, "GuideMoreAboutSub",
 CellID->6259],
Cell[10255, 357, 199, 5, 70, "GuideMoreAboutSub",
 CellID->23700]
}, Open  ]],
Cell[10469, 365, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

