(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9985,        342]
NotebookOptionsPosition[      6314,        245]
NotebookOutlinePosition[      8449,        291]
CellTagsIndexPosition[      8406,        288]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Symbol Handling", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbols are the ultimate atoms of symbolic data",
 ". ",
 "Every symbol has a unique name, exists in a certain ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " context or namespace, and can have a variety of types of values and \
attributes."
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["Symbol",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Symbol"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the head of a symbol; create a symbol from a name"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["SymbolName",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SymbolName"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "give the name of a symbol as a string"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["Context",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Context"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "give the name of the context of a symbol"
}], "GuideText",
 CellID->488788944],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["Names",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Names"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find a list of symbols with names matching a pattern"
}], "GuideText",
 CellID->467438017],

Cell[TextData[{
 Cell[TextData[ButtonBox["NameQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NameQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test whether a string corresponds to the name of any symbol"
}], "GuideText",
 CellID->860976307],

Cell[TextData[{
 Cell[TextData[ButtonBox["Remove",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Remove"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "completely remove a symbol so its name is no longer recognized"
}], "GuideText",
 CellID->35890589],

Cell[TextData[{
 Cell[TextData[ButtonBox["$NewSymbol",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$NewSymbol"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a function to be applied to the name of any new symbol"
}], "GuideText",
 CellID->141030709],

Cell["\t", "GuideDelimiter",
 CellID->535736923],

Cell[TextData[{
 Cell[TextData[ButtonBox["ValueQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ValueQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test whether a symbol has any type of value"
}], "GuideText",
 CellID->873813218],

Cell[TextData[{
 Cell[TextData[ButtonBox["OwnValues",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/OwnValues"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DownValues",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DownValues"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["UpValues",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/UpValues"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Options",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Options"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Attributes",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Attributes"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->33913249],

Cell[TextData[{
 Cell[TextData[ButtonBox["Information",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Information"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "give information on the values of a symbol"
}], "GuideText",
 CellID->8576610],

Cell[TextData[{
 Cell[TextData[ButtonBox["Clear",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Clear"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "clear all values associated with a symbol"
}], "GuideText",
 CellID->112274379],

Cell[TextData[{
 Cell[TextData[ButtonBox["Save",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Save"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "save values associated with a symbol"
}], "GuideText",
 CellID->269409201],

Cell["\t", "GuideDelimiter",
 CellID->244504144],

Cell[TextData[{
 Cell[TextData[ButtonBox["Unique",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Unique"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "generate a symbol with a unique name"
}], "GuideText",
 CellID->68896708]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Manipulating Symbols and Contexts by Name",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingSymbolsAndContextsByName"]], "GuideTutorial",
 CellID->270540946],

Cell[TextData[ButtonBox["Intercepting the Creation of New Symbols",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/InterceptingTheCreationOfNewSymbols"]], "GuideTutorial",
 CellID->3529395]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Attributes of Symbols",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Symbol Handling - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 18.1598018}", "context" -> "", 
    "keywords" -> {
     "assignments", "automatic unique names", "catalog", "cleaning up", 
      "clearing symbols", "default options", "definitions", 
      "deleting functions", "deleting symbols", "down values", 
      "finding options for output", "finding options for streams", 
      "function options", "functions", "generate unique names", 
      "generating unique-named symbols", "gensym", "inert functions", 
      "kill definition", "known symbols", "make list of symbols", "names", 
      "names for dummy variables", "names listing", "new symbol", 
      "option values", "options for symbol", "own values", 
      "removing functions", "removing symbols", 
      "saving definitions of functions", "saving function definitions", 
      "saving of definitions", "search for symbols", "symbol name", "symbols",
       "testing for assignments", "testing for existence of definitions", 
      "testing for values", "testing if defined", "undefining functions", 
      "up values", "workspace"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica symbols are the ultimate atoms of symbolic data. Every \
symbol has a unique name, exists in a certain Mathematica context or \
namespace, and can have a variety of types of values and attributes.", 
    "synonyms" -> {}, "title" -> "Symbol Handling", "type" -> "Guide", "uri" -> 
    "guide/SymbolHandling"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 57, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[679, 28, 358, 11, 70, "GuideAbstract",
 CellID->2001916300],
Cell[1040, 41, 274, 9, 70, "GuideText",
 CellID->203374175],
Cell[1317, 52, 271, 9, 70, "GuideText",
 CellID->1463276848],
Cell[1591, 63, 267, 9, 70, "GuideText",
 CellID->488788944],
Cell[1861, 74, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[1912, 77, 275, 9, 70, "GuideText",
 CellID->467438017],
Cell[2190, 88, 282, 9, 70, "GuideText",
 CellID->860976307],
Cell[2475, 99, 286, 9, 70, "GuideText",
 CellID->35890589],
Cell[2764, 110, 287, 9, 70, "GuideText",
 CellID->141030709],
Cell[3054, 121, 48, 1, 70, "GuideDelimiter",
 CellID->535736923],
Cell[3105, 124, 268, 9, 70, "GuideText",
 CellID->873813218],
Cell[3376, 135, 1027, 29, 70, "InlineGuideFunctionListing",
 CellID->33913249],
Cell[4406, 166, 275, 9, 70, "GuideText",
 CellID->8576610],
Cell[4684, 177, 264, 9, 70, "GuideText",
 CellID->112274379],
Cell[4951, 188, 257, 9, 70, "GuideText",
 CellID->269409201],
Cell[5211, 199, 48, 1, 70, "GuideDelimiter",
 CellID->244504144],
Cell[5262, 202, 260, 9, 70, "GuideText",
 CellID->68896708]
}, Open  ]],
Cell[CellGroupData[{
Cell[5559, 216, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[5624, 219, 199, 4, 70, "GuideTutorial",
 CellID->270540946],
Cell[5826, 225, 195, 4, 70, "GuideTutorial",
 CellID->3529395]
}, Open  ]],
Cell[CellGroupData[{
Cell[6058, 234, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[6123, 237, 149, 3, 70, "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],
Cell[6287, 243, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

