(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23815,        697]
NotebookOptionsPosition[     16950,        533]
NotebookOutlinePosition[     20892,        602]
CellTagsIndexPosition[     20849,        599]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Symbolic Graphics Language", "GuideTitle",
 CellID->8805],

Cell[TextData[{
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "uses the powerful idea of building up all 2D and 3D graphics from symbolic \
primitives\[LongDash]which can be manipulated using all standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions, and  seamlessly integrated with text, math or tables",
 ". ",
 "Symbolic graphics can also be used as input\[LongDash]and can be made \
dynamic and interactive."
}], "GuideAbstract",
 CellID->32372],

Cell[TextData[{
 Cell[TextData[ButtonBox["Graphics",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Graphics"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Graphics3D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Graphics3D"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "overall wrappers for 2D and 3D graphics"
}], "GuideText",
 CellID->23165],

Cell["\t", "GuideDelimiterSubsection",
 CellID->15431],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Basic 2D & 3D Objects \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GraphicsObjects"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->9658],

Cell[TextData[{
 Cell[TextData[ButtonBox["Point",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Point"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Line",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Line"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Polygon",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Polygon"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Text",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Text"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->11293]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Special 2D Objects \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GraphicsObjects"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->17206],

Cell[TextData[{
 Cell[TextData[ButtonBox["Arrow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Arrow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Disk",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Disk"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Circle",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Circle"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Rectangle",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rectangle"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Raster",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Raster"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->26578]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Special 3D Objects \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GraphicsObjects"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->16948],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sphere",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Sphere"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cuboid",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cuboid"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cylinder",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Cylinder"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->2206],

Cell["\t", "GuideDelimiterSubsection",
 CellID->27171]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Directives \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GraphicsDirectives"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->18166],

Cell[TextData[{
 Cell[TextData[ButtonBox["Red",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Red"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RGBColor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RGBColor"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Blend",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Blend"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Opacity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Opacity"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Thickness",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Thickness"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Dashing",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dashing"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EdgeForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EdgeForm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GraphicsDirectives"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->3396],

Cell["\t", "GuideDelimiterSubsection",
 CellID->16697]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Coordinates \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GraphicsCoordinates"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->31020],

Cell[TextData[{
 Cell[TextData[ButtonBox["Scaled",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Scaled"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Offset",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Offset"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ImageScaled",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ImageScaled"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->23694]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Transformations \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GraphicsTransformations"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->15529],

Cell[TextData[{
 Cell[TextData[ButtonBox["Rotate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Rotate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Translate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Translate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Scale",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Scale"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AffineTransform",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AffineTransform"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GraphicsTransformations"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->14788],

Cell["\t", "GuideDelimiterSubsection",
 CellID->30109]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Compound Constructors \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CombiningGraphics"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->17984],

Cell[TextData[{
 Cell[TextData[ButtonBox["Inset",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Inset"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GraphicsGroup",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsGroup"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GraphicsComplex",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GraphicsGrid",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/CombiningGraphics"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->11969],

Cell["\t", "GuideDelimiterSubsection",
 CellID->28978]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Dynamic Elements \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DynamicGraphicsElements"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->21617],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dynamic",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Dynamic"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Locator",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Locator"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Tooltip",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tooltip"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Annotation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Annotation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Deploy",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Deploy"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DynamicGraphicsElements"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->4015]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->16626],

Cell[TextData[ButtonBox["Insetting Objects in Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/InsettingObjectsInGraphics"]], "GuideTutorial",
 CellID->96742094],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Primitives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsPrimitives"]], "GuideTutorial",
 CellID->69550799],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]], "GuideTutorial",
 CellID->563936823],

Cell[TextData[{
 ButtonBox["Editing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InteractiveGraphicsOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InteractiveGraphicsOverview"],
  FontSlant->"Italic"],
 ButtonBox[" Graphics",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InteractiveGraphicsOverview"]
}], "GuideTutorial",
 CellID->60508230],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "GuideTutorial",
 CellID->28810171]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->17906],

Cell[TextData[ButtonBox["Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "GuideMoreAbout",
 CellID->25928],

Cell[TextData[ButtonBox["Layout & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LayoutAndTables"]], "GuideMoreAboutSub",
 CellID->28118],

Cell[TextData[ButtonBox["Splines Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Splines/guide/SplinesPackage"]], "GuideMoreAboutSub",
 CellID->57729256],

Cell[TextData[ButtonBox["Sound and Sonification",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SoundAndSonification"]], "GuideMoreAboutSub",
 CellID->24390],

Cell[TextData[ButtonBox["Math Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "GuideMoreAboutSub",
 CellID->15199],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "GuideMoreAbout",
 CellID->99443232]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Symbolic Graphics Language - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 18.9566972}", "context" -> "", 
    "keywords" -> {
     "2D polygon", "3D graphics", "3D polygon", "3D sphere", "additive color",
       "affine transform", "affine transformation", "alpha channel", 
      "arc of circle", "arrowhead", "ball", "balloon help", "bitmap", "block",
       "borders of polygons", "canvas", "circle", "circular arc", 
      "color blends", "color gradients", "color interpolation", "color model",
       "color space", "cube", "cuboid", "curves", "cylinder", "darker", 
      "dashed lines", "device color", "diffuse color", "disk", "dotted lines",
       "double arrow", "draw", "drawing", "drawing symbols", "edge form", 
      "edge styles", "edges", "ellipse", "elliptical arc", "elliptical disk", 
      "face", "facet", "filled circle", "filled ellipse", "filled region", 
      "formulae in 3D graphics", "formulae in graphics", 
      "geometric transforms", "graphics array", "graphics arrow", 
      "graphics complex", "graphics grid", "graphics group", 
      "graphics primitives", "graphics rectangle", "graphics transformations",
       "grip", "handle", "icons in graphics", "image array", "image scaled", 
      "inset 3D graphics into graphics", "inset graphic into graphics", 
      "inset text into graphics", "knob", "lighter", "line segments", "lines",
       "matching size of text", "mixing colors", "moving graphics object", 
      "opaque", "oval", "picture array", "pie slices", "pigment", "pipe", 
      "pixel array", "plotting symbols", "point", "polygon edges style", 
      "polygon mesh", "polygonal line", "polyhedra", "polyline", "polytope", 
      "popup box", "raster graphics", "rectangle", 
      "rectangular parallelepiped", "region", "relative coordinates", 
      "relative positions of graphics objects", "RGB", "RGB color model", 
      "RGBA", "rotate graphics", "rotation matrix", "rotation transform", 
      "scale graphics", "scaled coordinates", "scaling matrix", 
      "scaling transform", "screen tip", "ScreenTip", 
      "seams between polygons", "segments", "shifting graphics objects", 
      "single arrow", "sphere", "square", "styling of edges", 
      "styling of lines", "surface data", "surface graphics", "surface mesh", 
      "surface polygons", "surface triangulation", "tables of graphics", 
      "text in 3D graphics", "text in graphics", "text in notebooks", 
      "textual form in 3D graphics", "textual form in graphics", 
      "textual form in notebooks", "thickness of lines", "three-dimensional", 
      "transforming graphics", "translate graphics", "translation matrix", 
      "translation transform", "translucent", "transparent", "tube", 
      "tweaking graphics", "vector", "volume element", "voxel"}, "index" -> 
    True, "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica uses the powerful idea of building up all 2D and 3D graphics \
from symbolic primitives--which can be manipulated using all standard \
Mathematica functions, and seamlessly integrated with text, math or tables. \
Symbolic graphics can also be used as input--and can be made dynamic and \
interactive.", "synonyms" -> {}, "title" -> "Symbolic Graphics Language", 
    "type" -> "Guide", "uri" -> "guide/SymbolicGraphicsLanguage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 63, 1, 70, "GuideTitle",
 CellID->8805],
Cell[685, 28, 474, 12, 70, "GuideAbstract",
 CellID->32372],
Cell[1162, 42, 395, 13, 70, "GuideText",
 CellID->23165],
Cell[1560, 57, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->15431],
Cell[CellGroupData[{
Cell[1639, 62, 219, 5, 70, "GuideFunctionsSubsection",
 CellID->9658],
Cell[1861, 69, 784, 23, 70, "InlineGuideFunctionListing",
 CellID->11293]
}, Open  ]],
Cell[CellGroupData[{
Cell[2682, 97, 217, 5, 70, "GuideFunctionsSubsection",
 CellID->17206],
Cell[2902, 104, 1141, 32, 70, "InlineGuideFunctionListing",
 CellID->26578]
}, Open  ]],
Cell[CellGroupData[{
Cell[4080, 141, 217, 5, 70, "GuideFunctionsSubsection",
 CellID->16948],
Cell[4300, 148, 881, 23, 70, "InlineGuideFunctionListing",
 CellID->2206],
Cell[5184, 173, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->27171]
}, Open  ]],
Cell[CellGroupData[{
Cell[5275, 179, 212, 5, 70, "GuideFunctionsSubsection",
 CellID->18166],
Cell[5490, 186, 1918, 53, 70, "InlineGuideFunctionListing",
 CellID->3396],
Cell[7411, 241, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->16697]
}, Open  ]],
Cell[CellGroupData[{
Cell[7502, 247, 214, 5, 70, "GuideFunctionsSubsection",
 CellID->31020],
Cell[7719, 254, 743, 20, 70, "InlineGuideFunctionListing",
 CellID->23694]
}, Open  ]],
Cell[CellGroupData[{
Cell[8499, 279, 222, 5, 70, "GuideFunctionsSubsection",
 CellID->15529],
Cell[8724, 286, 1614, 41, 70, "InlineGuideFunctionListing",
 CellID->14788],
Cell[10341, 329, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->30109]
}, Open  ]],
Cell[CellGroupData[{
Cell[10432, 335, 222, 5, 70, "GuideFunctionsSubsection",
 CellID->17984],
Cell[10657, 342, 1628, 41, 70, "InlineGuideFunctionListing",
 CellID->11969],
Cell[12288, 385, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->28978]
}, Open  ]],
Cell[CellGroupData[{
Cell[12379, 391, 223, 5, 70, "GuideFunctionsSubsection",
 CellID->21617],
Cell[12605, 398, 1954, 50, 70, "InlineGuideFunctionListing",
 CellID->4015]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14608, 454, 58, 1, 70, "GuideTutorialsSection",
 CellID->16626],
Cell[14669, 457, 173, 3, 70, "GuideTutorial",
 CellID->96742094],
Cell[14845, 462, 200, 4, 70, "GuideTutorial",
 CellID->69550799],
Cell[15048, 468, 201, 4, 70, "GuideTutorial",
 CellID->563936823],
Cell[15252, 474, 409, 12, 70, "GuideTutorial",
 CellID->60508230],
Cell[15664, 488, 160, 3, 70, "GuideTutorial",
 CellID->28810171]
}, Open  ]],
Cell[CellGroupData[{
Cell[15861, 496, 59, 1, 70, "GuideMoreAboutSection",
 CellID->17906],
Cell[15923, 499, 154, 3, 70, "GuideMoreAbout",
 CellID->25928],
Cell[16080, 504, 146, 3, 70, "GuideMoreAboutSub",
 CellID->28118],
Cell[16229, 509, 156, 3, 70, "GuideMoreAboutSub",
 CellID->57729256],
Cell[16388, 514, 158, 3, 70, "GuideMoreAboutSub",
 CellID->24390],
Cell[16549, 519, 155, 3, 70, "GuideMoreAboutSub",
 CellID->15199],
Cell[16707, 524, 201, 4, 70, "GuideMoreAbout",
 CellID->99443232]
}, Open  ]],
Cell[16923, 531, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

