(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27757,       1022]
NotebookOptionsPosition[     21795,        859]
NotebookOutlinePosition[     24331,        909]
CellTagsIndexPosition[     24288,        906]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Syntax"
}], "GuideTitle",
 CellID->29554],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has a rich syntax carefully designed for consistency and efficient, \
readable entry of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s many language, mathematical and other constructs. In addition to \
ordinary linear ASCII input, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also supports full 2D mathematical input."
}], "GuideAbstract",
 CellID->31476],

Cell[CellGroupData[{

Cell["Basic Syntax", "GuideFunctionsSubsection",
 CellID->164791102],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " function arguments go in square brackets"
}], "GuideText",
 CellID->295527338],

Cell[TextData[{
 Cell[TextData[ButtonBox["Exp",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Exp"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Do",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Do"]], "InlineFunctionSans"],
 ", ",
 Cell[BoxData["..."], "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " built-in symbols have names beginning with capital letters"
}], "GuideText",
 CellID->405703307],

Cell[TextData[{
 Cell[TextData[{
  ButtonBox["{",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"],
  StyleBox[ButtonBox["\[Ellipsis]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"], "TR"],
  ButtonBox["}",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]
 }], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["List",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/List"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["\"\[Ellipsis]\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/String"], "TR"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["String",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/String"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  RowBox[{
   StyleBox["e", "TI"], 
   ButtonBox[
    RowBox[{"[", "["}],
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Part"], 
   StyleBox["i", "TI"], 
   ButtonBox[
    RowBox[{"]", "]"}],
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Part"]}]], "InlineFormula"],
 " (",
 Cell[TextData[ButtonBox["Part",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Part"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  RowBox[{
   StyleBox["e", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{
     StyleBox["i", "TI"], 
     ButtonBox[";;",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Span"], "j"}], "]"}], "]"}]], "InlineFormula"],
 " (",
 Cell[TextData[ButtonBox["Span",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Span"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ")"
}], "InlineGuideFunctionListing",
 CellID->572726656]
}, Open  ]],

Cell[CellGroupData[{

Cell["Basic Operations", "GuideFunctionsSubsection",
 CellID->121069098],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TI"],
  ButtonBox["=",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  StyleBox[ButtonBox["val",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " set a value (",
 Cell[TextData[ButtonBox["=.",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Unset"]], "InlineFunctionSans"],
 " to clear a value)"
}], "GuideText",
 CellID->1023774056],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"], "TI"],
  ButtonBox["==",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"],
  StyleBox[ButtonBox["val",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " test equality, or represent a symbolic equation (",
 Cell[TextData[ButtonBox["!=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Unequal"]], "InlineFunctionSans"],
 " for unequal)"
}], "GuideText",
 CellID->884292741],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["lhs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"], "TI"],
  ButtonBox[":=",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"],
  StyleBox[ButtonBox["rhs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " function etc. definition"
}], "GuideText",
 CellID->181886748],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["a",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rule"], "TI"],
  ButtonBox["->",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rule"],
  StyleBox[ButtonBox["b",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rule"], "TI"]
 }], "InlineFunctionSans"],
 ", ",
 Cell[TextData[{
  StyleBox[ButtonBox["a",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rule"], "TI"],
  ButtonBox["\[Rule]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rule"],
  StyleBox[ButtonBox["b",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rule"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " rule for transformations, options, etc. (",
 Cell[TextData[ButtonBox[":>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RuleDelayed"]], "InlineFunctionSans"],
 " for delayed rule)"
}], "GuideText",
 CellID->14046309],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["expr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"], "TI"],
  ButtonBox["/.",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"],
  StyleBox[ButtonBox["rule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " replace using a rule (\"slash dot\")"
}], "GuideText",
 CellID->242165294]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mathematics & Operators", "GuideFunctionsSubsection",
 CellID->981392457],

Cell[TextData[{
 Cell[TextData[ButtonBox["+",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Plus"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["-",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Minus"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["*",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Times"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["/",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Divide"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["^",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Power"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["Power",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Power"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["&&",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/And"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["And",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/And"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["||",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Or"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["Or",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Or"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["!",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Not"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["Not",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Not"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["<>",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringJoin"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["StringJoin",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringJoin"]], "InlineFunctionSans"],
 ")"
}], "InlineGuideFunctionListing",
 CellID->708780417],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["a", "TI"], " ", 
   StyleBox["b", "TI"], " ", 
   StyleBox["c", "TI"]}]], "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " spaces stand for multiplication"
}], "GuideText",
 CellID->245520191],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["nn", "TI"], "*", 
   RowBox[{"^", 
    StyleBox["ee", "TI"]}]}]], "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "scientific notation"
}], "GuideText",
 CellID->199855224],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["b", "TI"], "^", 
   RowBox[{"^", 
    StyleBox["nnnn", "TI"]}]}]], "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "number in a base"
}], "GuideText",
 CellID->657366486]
}, Open  ]],

Cell[CellGroupData[{

Cell["Patterns", "GuideFunctionsSubsection",
 CellID->22486962],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blank"], "TI"],
  ButtonBox["_",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blank"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " any expression (\"x blank\")"
}], "GuideText",
 CellID->200493943],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BlankSequence"], "TI"],
  ButtonBox["__",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BlankSequence"]
 }], "InlineFunctionSans"],
 ", ",
 Cell[TextData[{
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BlankNullSequence"], "TI"],
  ButtonBox["___",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BlankNullSequence"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sequences of arbitrary expressions (\"x double blank\", ...)"
}], "GuideText",
 CellID->83895919],

Cell[TextData[{
 Cell[TextData[ButtonBox["_",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Blank"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["__",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BlankSequence"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["___",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BlankNullSequence"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "unnamed patterns"
}], "GuideText",
 CellID->92228448],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pattern"], "TI"],
  ButtonBox[":",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pattern"],
  StyleBox[ButtonBox["p",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pattern"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "pattern name"
}], "GuideText",
 CellID->17966431],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["p",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pattern"], "TI"],
  ButtonBox[":",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pattern"],
  StyleBox[ButtonBox["d",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pattern"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "pattern default"
}], "GuideText",
 CellID->478641602],

Cell[TextData[{
 Cell[TextData[ButtonBox["..",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Repeated"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["Repeated",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Repeated"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["|",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Alternatives"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["Alternatives",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Alternatives"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["/;",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Condition"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["Condition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Condition"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["?",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PatternTest"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["PatternTest",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PatternTest"]], "InlineFunctionSans"],
 ")"
}], "InlineGuideFunctionListing",
 CellID->399133411]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pure Functions", "GuideFunctionsSubsection",
 CellID->631225180],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["expr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"], "TI"],
  ButtonBox["&",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " a pure function"
}], "GuideText",
 CellID->534237844],

Cell[TextData[{
 Cell[TextData[ButtonBox["#",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Slot"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["#2",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Slot"]], "InlineFunctionSans"],
 ", etc. \[LongDash] arguments in a pure function"
}], "GuideText",
 CellID->39259441]
}, Open  ]],

Cell[CellGroupData[{

Cell["Short Forms", "GuideFunctionsSubsection",
 CellID->19113224],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["f",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Prefix"], "TI"],
  ButtonBox["@",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Prefix"],
  StyleBox[ButtonBox["expr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Prefix"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " prefix function application"
}], "GuideText",
 CellID->1049570392],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["expr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Postfix"], "TI"],
  ButtonBox["//",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Postfix"],
  StyleBox[ButtonBox["f",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Postfix"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " postfix function application (\"slash slash\")"
}], "GuideText",
 CellID->633435095],

Cell[TextData[{
 Cell[TextData[ButtonBox["/@",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Map"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["Map",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Map"]], "InlineFunctionSans"],
 " \[LongDash] \"slash at\")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["@@",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apply"], ",", 
   ButtonBox["@@@",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apply"]}]], "InlineFormula"],
 " (",
 Cell[TextData[ButtonBox["Apply",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Apply"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["~~",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringExpression"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["StringExpression",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringExpression"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["===",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SameQ"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["SameQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SameQ"]], "InlineFunctionSans"],
 ")"
}], "InlineGuideFunctionListing",
 CellID->44892746]
}, Open  ]],

Cell[CellGroupData[{

Cell["Program Syntax", "GuideFunctionsSubsection",
 CellID->72981696],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["expr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompoundExpression"], "TI"],
  ButtonBox[";",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompoundExpression"],
  StyleBox[ButtonBox["expr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompoundExpression"], "TI"],
  ButtonBox[";",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompoundExpression"],
  StyleBox[ButtonBox["expr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompoundExpression"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " sequence of commands (",
 Cell[TextData[ButtonBox["CompoundExpression",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CompoundExpression"]], "InlineFunctionSans"],
 ")"
}], "GuideText",
 CellID->661900939],

Cell[TextData[{
 Cell[TextData[{
  ButtonBox["<<",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"],
  StyleBox[ButtonBox["file",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " input a file (",
 Cell[BoxData[
  RowBox[{
   ButtonBox[">>",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Put"], 
   StyleBox["file", "TI"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox[">>>",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PutAppend"], 
   StyleBox["file", "TI"]}]], "InlineFormula"],
 " for outputting to a file) "
}], "GuideText",
 CellID->19388509],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"(*", " ", 
   StyleBox["\[Ellipsis]", "TR"], " ", "*)"}]], "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " comment"
}], "GuideText",
 CellID->56397412],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["ccc", "TI"], "`", 
    StyleBox["nnn", "TI"]}]]], "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " symbol in context ",
 Cell[BoxData[
  StyleBox["ccc", "TI"]], "InlineFormula"]
}], "GuideText",
 CellID->13062652]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Session Syntax"
}], "GuideFunctionsSubsection",
 CellID->282477788],

Cell[TextData[{
 Cell[TextData[ButtonBox["%",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Out"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " most recent output (",
 Cell[BoxData[
  RowBox[{
   ButtonBox["%",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " for output on line ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ")"
}], "GuideText",
 CellID->84783585],

Cell[TextData[{
 Cell[TextData[{
  ButtonBox["?",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"],
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " information on symbol ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"]
}], "GuideText",
 CellID->48374281]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->23158],

Cell[TextData[{
 ButtonBox["The Syntax of the ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheSyntaxOfTheMathematicaLanguage"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheSyntaxOfTheMathematicaLanguage"],
  FontSlant->"Italic"],
 ButtonBox[" Language",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheSyntaxOfTheMathematicaLanguage"]
}], "GuideTutorial",
 CellID->163453060],

Cell[TextData[ButtonBox["Input Syntax",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/InputSyntax"]], "GuideTutorial",
 CellID->30139291],

Cell[TextData[ButtonBox["Special Ways to Input Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialWaysToInputExpressions"]], "GuideTutorial",
 CellID->437146400]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->8510],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "GuideMoreAbout",
 CellID->30946],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"],
  FontSlant->"Italic"],
 ButtonBox[" Syntax Characters",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"]
}], "GuideMoreAboutSub",
 CellID->431448687]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mathematica Syntax - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 20.3473578}", "context" -> "", 
    "keywords" -> {
     "`", "~~", ";;", "::", ">>>", "<>", ">>", "<<", "<=", "<", ">=", ">", 
      ";", "}", "{", "]]", "[[", "|", "||", "&&", "&", "___", "__", "_", ":", 
      "/=", "*=", "-=", "+=", "--", "++", "**", "##", "#", "/;", "//.", "/.", 
      "@@@", "@@", "//@", "/@", "...", "..", "%%", "%", "=!=", "!=", "===", 
      "==", "/:", "^:=", "^=", "=.", ":=", "=", ":>", "->", "^^", "/", "!!", 
      "!", "??", "?", "(*", "*)", "//", 
      "applicability of transformation rules", "applying functions", 
      "applying functions to lists of expressions", 
      "applying functions to parts of expression", "array subscript", 
      "array subscripting", "combine conditions", "compound expression", 
      "concatenate strings", "conditions", "double quotes", 
      "equality testing", "equivalent expressions", "evaluate in sequence", 
      "identical expressions", "joining strings", "linear order of execution",
       "lists", "multiple parts", "negation", "not", "one-or-more", 
      "one or more", "parts", "pattern condition", "patterns", 
      "patterns for string", "pattern test", "question mark", 
      "raise to a power", "repeated expression", "repeated pattern", 
      "restricted pattern", "rules", "semicolon", "sequence of commands", 
      "set", "slash-semi", "string pattern", "structural equivalence", 
      "syntax"}, "index" -> True, "label" -> "Mathematica Guide", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica has a rich syntax carefully designed for consistency and \
efficient, readable entry of Mathematica's many language, mathematical and \
other constructs. In addition to ordinary linear ASCII input, Mathematica \
also supports full 2D mathematical input.", "synonyms" -> {}, "title" -> 
    "Mathematica Syntax", "type" -> "Guide", "uri" -> "guide/Syntax"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 109, 5, 70, "GuideTitle",
 CellID->29554],
Cell[731, 32, 443, 13, 70, "GuideAbstract",
 CellID->31476],
Cell[CellGroupData[{
Cell[1199, 49, 68, 1, 70, "GuideFunctionsSubsection",
 CellID->164791102],
Cell[1270, 52, 302, 11, 70, "GuideText",
 CellID->295527338],
Cell[1575, 65, 440, 14, 70, "GuideText",
 CellID->405703307],
Cell[2018, 81, 1889, 69, 70, "InlineGuideFunctionListing",
 CellID->572726656]
}, Open  ]],
Cell[CellGroupData[{
Cell[3944, 155, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->121069098],
Cell[4019, 158, 549, 20, 70, "GuideText",
 CellID->1023774056],
Cell[4571, 180, 588, 20, 70, "GuideText",
 CellID->884292741],
Cell[5162, 202, 449, 16, 70, "GuideText",
 CellID->181886748],
Cell[5614, 220, 894, 32, 70, "GuideText",
 CellID->14046309],
Cell[6511, 254, 463, 16, 70, "GuideText",
 CellID->242165294]
}, Open  ]],
Cell[CellGroupData[{
Cell[7011, 275, 79, 1, 70, "GuideFunctionsSubsection",
 CellID->981392457],
Cell[7093, 278, 2322, 78, 70, "InlineGuideFunctionListing",
 CellID->708780417],
Cell[9418, 358, 272, 10, 70, "GuideText",
 CellID->245520191],
Cell[9693, 370, 257, 11, 70, "GuideText",
 CellID->199855224],
Cell[9953, 383, 255, 11, 70, "GuideText",
 CellID->657366486]
}, Open  ]],
Cell[CellGroupData[{
Cell[10245, 399, 63, 1, 70, "GuideFunctionsSubsection",
 CellID->22486962],
Cell[10311, 402, 342, 13, 70, "GuideText",
 CellID->200493943],
Cell[10656, 417, 633, 22, 70, "GuideText",
 CellID->83895919],
Cell[11292, 441, 491, 17, 70, "GuideText",
 CellID->92228448],
Cell[11786, 460, 427, 17, 70, "GuideText",
 CellID->17966431],
Cell[12216, 479, 431, 17, 70, "GuideText",
 CellID->478641602],
Cell[12650, 498, 1288, 43, 70, "InlineGuideFunctionListing",
 CellID->399133411]
}, Open  ]],
Cell[CellGroupData[{
Cell[13975, 546, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->631225180],
Cell[14048, 549, 338, 13, 70, "GuideText",
 CellID->534237844],
Cell[14389, 564, 328, 10, 70, "GuideText",
 CellID->39259441]
}, Open  ]],
Cell[CellGroupData[{
Cell[14754, 579, 66, 1, 70, "GuideFunctionsSubsection",
 CellID->19113224],
Cell[14823, 582, 439, 16, 70, "GuideText",
 CellID->1049570392],
Cell[15265, 600, 461, 16, 70, "GuideText",
 CellID->633435095],
Cell[15729, 618, 1383, 48, 70, "InlineGuideFunctionListing",
 CellID->44892746]
}, Open  ]],
Cell[CellGroupData[{
Cell[17149, 671, 69, 1, 70, "GuideFunctionsSubsection",
 CellID->72981696],
Cell[17221, 674, 813, 26, 70, "GuideText",
 CellID->661900939],
Cell[18037, 702, 677, 27, 70, "GuideText",
 CellID->19388509],
Cell[18717, 731, 219, 8, 70, "GuideText",
 CellID->56397412],
Cell[18939, 741, 307, 12, 70, "GuideText",
 CellID->13062652]
}, Open  ]],
Cell[CellGroupData[{
Cell[19283, 758, 135, 5, 70, "GuideFunctionsSubsection",
 CellID->282477788],
Cell[19421, 765, 467, 18, 70, "GuideText",
 CellID->84783585],
Cell[19891, 785, 411, 15, 70, "GuideText",
 CellID->48374281]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20351, 806, 58, 1, 70, "GuideTutorialsSection",
 CellID->23158],
Cell[20412, 809, 438, 12, 70, "GuideTutorial",
 CellID->163453060],
Cell[20853, 823, 141, 3, 70, "GuideTutorial",
 CellID->30139291],
Cell[20997, 828, 184, 4, 70, "GuideTutorial",
 CellID->437146400]
}, Open  ]],
Cell[CellGroupData[{
Cell[21218, 837, 58, 1, 70, "GuideMoreAboutSection",
 CellID->8510],
Cell[21279, 840, 160, 3, 70, "GuideMoreAbout",
 CellID->30946],
Cell[21442, 845, 311, 9, 70, "GuideMoreAboutSub",
 CellID->431448687]
}, Open  ]],
Cell[21768, 857, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

