(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22107,        690]
NotebookOptionsPosition[     15285,        530]
NotebookOutlinePosition[     19353,        603]
CellTagsIndexPosition[     19310,        600]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Testing Expressions", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbolic expressions can represent an immense range of types of objects. \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a rich collection of functions to test expressions. Functions \
that \"ask a question\" have names that end in Q",
 ". ",
 "They return ",
 Cell[TextData[ButtonBox["True",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/True"]], "InlineFunctionSans"],
 " for an explicit true answer, and ",
 Cell[TextData[ButtonBox["False",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/False"]], "InlineFunctionSans"],
 " otherwise."
}], "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell["Equality & Inequality", "GuideFunctionsSubsection",
 CellID->311711778],

Cell[TextData[{
 Cell[TextData[ButtonBox["Equal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Equal"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["==",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Equal"]], "InlineFunctionSans"],
 "), ",
 Cell[TextData[ButtonBox["Unequal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Unequal"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["!=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Unequal"]], "InlineFunctionSans"],
 ") \[LongDash] numerical equality"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["SameQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SameQ"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["===",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SameQ"]], "InlineFunctionSans"],
 "), ",
 Cell[TextData[ButtonBox["UnsameQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/UnsameQ"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["=!=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/UnsameQ"]], "InlineFunctionSans"],
 ") \[LongDash] literal symbolic identity"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["Less",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Less"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["<",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Less"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Greater",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Greater"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox[">",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Greater"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LessEqual",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LessEqual"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["<=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LessEqual"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GreaterEqual",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GreaterEqual"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox[">=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GreaterEqual"]], "InlineFunctionSans"],
 ")"
}], "InlineGuideFunctionListing",
 CellID->135791577]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Logical Combinations \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/LogicAndBooleanAlgebra"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->197192383],

Cell[TextData[{
 Cell[TextData[ButtonBox["And",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/And"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["&&",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/And"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Or",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Or"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["||",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Or"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Not",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Not"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["!",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Not"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["True",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/True"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["False",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/False"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->79426561],

Cell["\t", "GuideDelimiterSubsection",
 CellID->320575578]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Numerical Properties \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NumberTheory"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->8036023],

Cell[TextData[{
 Cell[TextData[ButtonBox["NumberQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NumberQ"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MachineNumberQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MachineNumberQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "literal number, literal machine-precision number"
}], "GuideText",
 CellID->636272797],

Cell[TextData[{
 Cell[TextData[ButtonBox["NumericQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NumericQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " numeric quantity (consisting of numbers, numeric constants and functions)"
}], "GuideText",
 CellID->335077951],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EvenQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EvenQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["OddQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/OddQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PrimeQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PrimeQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CoprimeQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CoprimeQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AlgebraicIntegerQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AlgebraicIntegerQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NumberTheory"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58033752],

Cell[TextData[{
 Cell[TextData[ButtonBox["Positive",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Positive"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Negative",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Negative"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NonPositive",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NonPositive"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NonNegative",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NonNegative"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PossibleZeroQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PossibleZeroQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->381010304],

Cell["\t", "GuideDelimiterSubsection",
 CellID->974191666]
}, Open  ]],

Cell[CellGroupData[{

Cell["List-Oriented Tests", "GuideFunctionsSubsection",
 CellID->198126201],

Cell[TextData[{
 Cell[TextData[ButtonBox["VectorQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/VectorQ"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MatrixQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatrixQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "vector, matrix, perhaps with elements of specified types"
}], "GuideText",
 CellID->27955128],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArrayQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArrayQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "full array of any depth"
}], "GuideText",
 CellID->204503148],

Cell[TextData[{
 Cell[TextData[ButtonBox["MemberQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MemberQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test whether a pattern occurs in a list"
}], "GuideText",
 CellID->264989857],

Cell["\t", "GuideDelimiterSubsection",
 CellID->116672050]
}, Open  ]],

Cell[CellGroupData[{

Cell["Expression Tests", "GuideFunctionsSubsection",
 CellID->714507558],

Cell[TextData[{
 Cell[TextData[ButtonBox["MatchQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MatchQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test whether an expression matches a pattern"
}], "GuideText",
 CellID->164715688],

Cell[TextData[{
 Cell[TextData[ButtonBox["AtomQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AtomQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TrueQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TrueQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["OrderedQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/OrderedQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PolynomialQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PolynomialQ"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->61589497],

Cell["\t", "GuideDelimiterSubsection",
 CellID->257795625]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["String Tests \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/StringManipulation"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->835610847],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StringMatchQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringMatchQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StringFreeQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringFreeQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LetterQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LetterQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DigitQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DigitQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SyntaxQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SyntaxQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StringManipulation"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->33351623]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Relational and Logical Operators",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/RelationalAndLogicalOperators"]], "GuideTutorial",
 CellID->123403736],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "GuideTutorial",\

 CellID->533544426],

Cell[TextData[ButtonBox["Specifying Types of Expression in Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecifyingTypesOfExpressionInPatterns"]], "GuideTutorial",
 CellID->136001131]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Conditionals"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Atomic Elements of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AtomicElementsOfExpressions"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Patterns"],
  FontSlant->"Italic"],
 ButtonBox[" Patterns",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Patterns"]
}], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "GuideMoreAboutSub",
 CellID->57647321]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Testing Expressions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 27.0194036}", "context" -> "", 
    "keywords" -> {
     "alphabetic characters", "alphanumeric", "alternation", "ampersand", 
      "and", "arrays", "atom", "bang", "biconditional", "Boolean", 
      "Boolean algebra", "Boolean tests", "character class", 
      "checking grammar in strings", "combine conditions", "compare strings", 
      "comparison", "complement", "conjugation", "contain substring", 
      "contains", "contradiction", "depends on", "disjunction", 
      "element of a list", "elementary expression", "equal", 
      "equality testing", "equations", "equivalence", "equivalence testing", 
      "equivalent expressions", "even numbers", "false", "greater", 
      "greater equal", "identical", "identical expressions", "inclusive or", 
      "inequality", "inequation", "intersection", "inversion", "isOdd", 
      "isprime", "less", "less equal", "less or equal", "less than", 
      "list member", "logical +", "logical bar", "logical connective", 
      "logical plus", "logical prime", "logical product", "logical sum", 
      "logical value", "machine number", "matching of strings", 
      "matching strings", "mathematical equivalence", "membership test", 
      "Miller-Rabin test", "negation", "negative number", "non negative", 
      "non positive", "non-identical expressions", "non-negative", 
      "non-negative number", "non-positive", "non-positive number", "not", 
      "not equal", "not-equal", "numbers", "numeric quantities", 
      "odd numbers", "or ", "order", "order relation", "positive number", 
      "possible zero", "predicate to test oddness", "present in list", 
      "primality testing", "propositional logic", "pseudoprime test", 
      "same expressions", "strict inequality", "strictly less than", 
      "string comparison", "string free", "string match", 
      "strings consisting of numbers", "strong inequality", 
      "structural equivalence", "syntax checking", 
      "syntax checking in strings", "test for alphabetic characters", 
      "test for character", "test for elements in lists", "test for negative",
       "test for pattern match", "test for truth", "test if a digit", 
      "test if string", "test if vector", "testing", "testing equality", 
      "testing for equivalence", "testing for integers", 
      "testing for literal equality", "testing for matching of patterns", 
      "testing for matrices", "testing for numbers", 
      "testing for numerical expressions", "testing for numerical vectors", 
      "testing for odd integers", "testing for ordering", 
      "testing for polynomials", "testing for presence", 
      "testing for primality of integers", "testing for prime", 
      "testing for vectors", "testing if non-negative", 
      "testing if non-positive", "truth predicate", "truth value", "unequal", 
      "union", "weak inequality", "zero recognition", "zero testing"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica symbolic expressions can represent an immense range of types \
of objects. Mathematica provides a rich collection of functions to test \
expressions. Functions that \"ask a question\" have names that end in Q. They \
return True for an explicit true answer, and False otherwise.", 
    "synonyms" -> {}, "title" -> "Testing Expressions", "type" -> "Guide", 
    "uri" -> "guide/TestingExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 61, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[683, 28, 667, 20, 70, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[1375, 52, 77, 1, 70, "GuideFunctionsSubsection",
 CellID->311711778],
Cell[1455, 55, 566, 18, 70, "GuideText",
 CellID->203374175],
Cell[2024, 75, 576, 18, 70, "GuideText",
 CellID->1463276848],
Cell[2603, 95, 1261, 43, 70, "InlineGuideFunctionListing",
 CellID->135791577]
}, Open  ]],
Cell[CellGroupData[{
Cell[3901, 143, 230, 5, 70, "GuideFunctionsSubsection",
 CellID->197192383],
Cell[4134, 150, 1499, 50, 70, "InlineGuideFunctionListing",
 CellID->79426561],
Cell[5636, 202, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->320575578]
}, Open  ]],
Cell[CellGroupData[{
Cell[5731, 208, 218, 5, 70, "GuideFunctionsSubsection",
 CellID->8036023],
Cell[5952, 215, 414, 13, 70, "GuideText",
 CellID->636272797],
Cell[6369, 230, 297, 8, 70, "GuideText",
 CellID->335077951],
Cell[6669, 240, 1726, 47, 70, "InlineGuideFunctionListing",
 CellID->58033752],
Cell[8398, 289, 1187, 32, 70, "InlineGuideFunctionListing",
 CellID->381010304],
Cell[9588, 323, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->974191666]
}, Open  ]],
Cell[CellGroupData[{
Cell[9683, 329, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->198126201],
Cell[9761, 332, 407, 13, 70, "GuideText",
 CellID->27955128],
Cell[10171, 347, 248, 9, 70, "GuideText",
 CellID->204503148],
Cell[10422, 358, 266, 9, 70, "GuideText",
 CellID->264989857],
Cell[10691, 369, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->116672050]
}, Open  ]],
Cell[CellGroupData[{
Cell[10786, 375, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->714507558],
Cell[10861, 378, 269, 9, 70, "GuideText",
 CellID->164715688],
Cell[11133, 389, 805, 23, 70, "InlineGuideFunctionListing",
 CellID->61589497],
Cell[11941, 414, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->257795625]
}, Open  ]],
Cell[CellGroupData[{
Cell[12036, 420, 218, 5, 70, "GuideFunctionsSubsection",
 CellID->835610847],
Cell[12257, 427, 1446, 41, 70, "InlineGuideFunctionListing",
 CellID->33351623]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13752, 474, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[13817, 477, 183, 4, 70, "GuideTutorial",
 CellID->123403736],
Cell[14003, 483, 180, 4, 70, "GuideTutorial",
 CellID->533544426],
Cell[14186, 489, 201, 4, 70, "GuideTutorial",
 CellID->136001131]
}, Open  ]],
Cell[CellGroupData[{
Cell[14424, 498, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[14489, 501, 142, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[14634, 506, 174, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[14811, 511, 265, 9, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[15079, 522, 164, 3, 70, "GuideMoreAboutSub",
 CellID->57647321]
}, Open  ]],
Cell[15258, 528, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

