(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17634,        562]
NotebookOptionsPosition[     13017,        437]
NotebookOutlinePosition[     15083,        481]
CellTagsIndexPosition[     15040,        478]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Text Styling", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows arbitrary styling of any form of text to be specified either \
interactively from menus and commands\[LongDash]or programmatically using its \
powerful symbolic representation of styling."
}], "GuideAbstract",
 CellID->313074423],

Cell[CellGroupData[{

Cell["Keyboard & Menu Controls", "GuideFunctionsSubsection",
 CellID->58797888],

Cell[TextData[{
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["n", "TI"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " pick a style for a selection (4: Section, 9: Input, 0: any style name)"
}], "GuideText",
 CellID->492532845],

Cell[TextData[{
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["B", "KeyEvent"],
 " (",
 Cell[TextData[ButtonBox["Bold",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Bold"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["I", "KeyEvent"],
 " (",
 Cell[TextData[ButtonBox["Italic",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Italic"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["=", "KeyEvent"],
 " (",
 Cell[TextData[ButtonBox["Larger",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Larger"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["-", "KeyEvent"],
 "  (",
 Cell[TextData[ButtonBox["Smaller",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Smaller"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 "..."
}], "InlineGuideFunctionListing",
 CellID->250728546],

Cell[TextData[{
 StyleBox[ButtonBox["Font",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Font"], "MenuName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Face",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Face"], "MenuName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Size",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Size"], "MenuName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Text Justification",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/TextJustification"], "MenuName"],
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 "..."
}], "InlineGuideFunctionListing",
 CellID->539636202],

Cell[TextData[{
 StyleBox[ButtonBox["Clear Formatting",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/ClearFormatting"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " remove styles from text"
}], "GuideText",
 CellID->548462455],

Cell[TextData[{
 StyleBox[ButtonBox["Show Toolbar",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/ShowToolbar"], "MenuName"],
 "  ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " switch on notebook formatting toolbar"
}], "GuideText",
 CellID->714111783],

Cell["\t", "GuideDelimiter",
 CellID->66892254],

Cell[TextData[{
 Cell[TextData[ButtonBox["Style",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Style"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "specify arbitrary style options for output"
}], "GuideText",
 CellID->590211963],

Cell[TextData[{
 StyleBox[ButtonBox["Option Inspector",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/OptionInspector"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " access to formatting and styling options"
}], "GuideText",
 CellID->586108905]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Font Options \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FontOptions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->22063172],

Cell[TextData[{
 Cell[TextData[ButtonBox["Bold",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Bold"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Italic",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Italic"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Red",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Red"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Large",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Large"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FontFamily",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FontFamily"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FontOptions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->651597283]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Text Layout \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/TextLayoutOptions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->293562529],

Cell[TextData[{
 Cell[TextData[ButtonBox["TextAlignment",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TextAlignment"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TextJustification",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TextJustification"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LineSpacing",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LineSpacing"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LineIndent",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LineIndent"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/TextLayoutOptions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->478823012]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Automatic Text Styling \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/AutomaticTextStylingFeatures"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->591553152],

Cell[TextData[{
 Cell[TextData[ButtonBox["ShowStringCharacters",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ShowStringCharacters"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ShowAutoStyles",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ShowAutoStyles"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AutoItalicWords",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AutoItalicWords"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AutomaticTextStylingFeatures"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->303252710],

Cell[TextData[{
 StyleBox[ButtonBox["Preferences",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Preferences"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["Syntax Coloring", "MenuName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Preferences",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Preferences"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["Numbers", "MenuName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AutomaticTextStylingFeatures"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->654778133]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Basic Editing Techniques",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/BasicEditingTechniquesOverview"]], "GuideTutorial",
 CellID->507152383],

Cell[TextData[ButtonBox["Text and Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TextAndFontOptions"]], "GuideTutorial",
 CellID->370489788],

Cell[TextData[ButtonBox["Styles and Fonts in Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StylesAndFontsInOutput"]], "GuideTutorial",
 CellID->66768730],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "GuideTutorial",
 CellID->33580261]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Notebook Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookFormattingAndStyling"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Automatic Text Styling Features",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AutomaticTextStylingFeatures"]], "GuideMoreAbout",
 CellID->528755557],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "GuideMoreAboutSub",
 CellID->323869103],

Cell[TextData[ButtonBox["Text Layout Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextLayoutOptions"]], "GuideMoreAboutSub",
 CellID->48760595],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "GuideMoreAbout",
 CellID->184873245],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "GuideMoreAbout",
 CellID->857364543]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1176603342],

Cell[TextData[{
 ButtonBox["Demonstrations related to Text Styling",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
AutoItalicWords+OR+Bold+OR+FontFamily+OR+Italic+OR+LineIndent+OR+LineSpacing+\
OR+ShowStringCharacters+OR+ShowSyntaxColoring+OR+TextAlignment+OR+\
TextJustification)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->174791135]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Text Styling - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 28.4413150}", "context" -> "", 
    "keywords" -> {
     "auto italic words", "auto-italic words", "automatic italic", 
      "\\baselineskip (TeX)", "centering", "Courier fonts", "cursive", 
      "display string characters", "display style", "double spacing", 
      "double-spaced text", "fixed spacing", "flush left", "flush right", 
      "font family", "font-family", "font size", "full justification", 
      "Helvetica fonts", "interline spacing", "italicization", 
      "justification", "leading", "left aligned", "left justification", 
      "line indent", "line spacing", "\\linespread (TeX)", "looseness", 
      "monospace", "quotes", "ragged right", "right aligned", 
      "right justification", "sans-serif", "serif", "show double-quotes", 
      "show quotes", "show string characters", "skip", "spacing", 
      "special words", "strings", "styles", "text alignment", "text color", 
      "text justification", "tightness", "Times fonts", "Times New Roman", 
      "typeface"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica allows arbitrary styling of any form of text to be specified \
either interactively from menus and commands--or programmatically using its \
powerful symbolic representation of styling.", "synonyms" -> {}, "title" -> 
    "Text Styling", "type" -> "Guide", "uri" -> "guide/TextStyling"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 54, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[676, 28, 304, 7, 70, "GuideAbstract",
 CellID->313074423],
Cell[CellGroupData[{
Cell[1005, 39, 79, 1, 70, "GuideFunctionsSubsection",
 CellID->58797888],
Cell[1087, 42, 263, 8, 70, "GuideText",
 CellID->492532845],
Cell[1353, 52, 1543, 53, 70, "InlineGuideFunctionListing",
 CellID->250728546],
Cell[2899, 107, 857, 27, 70, "InlineGuideFunctionListing",
 CellID->539636202],
Cell[3759, 136, 255, 8, 70, "GuideText",
 CellID->548462455],
Cell[4017, 146, 262, 8, 70, "GuideText",
 CellID->714111783],
Cell[4282, 156, 47, 1, 70, "GuideDelimiter",
 CellID->66892254],
Cell[4332, 159, 410, 12, 70, "GuideText",
 CellID->590211963],
Cell[4745, 173, 272, 8, 70, "GuideText",
 CellID->586108905]
}, Open  ]],
Cell[CellGroupData[{
Cell[5054, 186, 210, 5, 70, "GuideFunctionsSubsection",
 CellID->22063172],
Cell[5267, 193, 1639, 44, 70, "InlineGuideFunctionListing",
 CellID->651597283]
}, Open  ]],
Cell[CellGroupData[{
Cell[6943, 242, 216, 5, 70, "GuideFunctionsSubsection",
 CellID->293562529],
Cell[7162, 249, 1064, 29, 70, "InlineGuideFunctionListing",
 CellID->478823012]
}, Open  ]],
Cell[CellGroupData[{
Cell[8263, 283, 238, 5, 70, "GuideFunctionsSubsection",
 CellID->591553152],
Cell[8504, 290, 882, 24, 70, "InlineGuideFunctionListing",
 CellID->303252710],
Cell[9389, 316, 818, 22, 70, "InlineGuideFunctionListing",
 CellID->654778133]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10256, 344, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[10321, 347, 176, 4, 70, "GuideTutorial",
 CellID->507152383],
Cell[10500, 353, 158, 3, 70, "GuideTutorial",
 CellID->370489788],
Cell[10661, 358, 166, 3, 70, "GuideTutorial",
 CellID->66768730],
Cell[10830, 363, 149, 3, 70, "GuideTutorial",
 CellID->33580261]
}, Open  ]],
Cell[CellGroupData[{
Cell[11016, 371, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[11081, 374, 140, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[11224, 379, 174, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[11401, 384, 176, 3, 70, "GuideMoreAbout",
 CellID->528755557],
Cell[11580, 389, 167, 3, 70, "GuideMoreAboutSub",
 CellID->323869103],
Cell[11750, 394, 155, 3, 70, "GuideMoreAboutSub",
 CellID->48760595],
Cell[11908, 399, 176, 3, 70, "GuideMoreAbout",
 CellID->184873245],
Cell[12087, 404, 178, 3, 70, "GuideMoreAbout",
 CellID->857364543]
}, Open  ]],
Cell[CellGroupData[{
Cell[12302, 412, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1176603342],
Cell[12375, 415, 600, 17, 70, "GuideRelatedLinks",
 CellID->174791135]
}, Open  ]],
Cell[12990, 435, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

