(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14509,        471]
NotebookOptionsPosition[      9929,        357]
NotebookOutlinePosition[     12775,        412]
CellTagsIndexPosition[     12732,        409]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Trigonometric Functions", "GuideTitle",
 CellID->24618],

Cell[TextData[{
 "With careful attention to branch cuts, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports trigonometric functions everywhere in the complex plane, with \
extensive exact and algebraic transformations, together with efficient \
arbitrary-precision numerical evaluation. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " follows the standard mathematical convention of using radians for \
trigonometric function arguments."
}], "GuideAbstract",
 CellID->417688928],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sin",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sin"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cos",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cos"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Tan",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Tan"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Csc",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Csc"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sec",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sec"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cot"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->8672],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArcSin",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcSin"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArcCos",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcCos"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArcTan",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcTan"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArcCsc",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcCsc"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArcSec",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcSec"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArcCot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArcCot"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1563],

Cell["\t", "GuideDelimiter",
 CellID->78383194],

Cell[TextData[{
 Cell[TextData[ButtonBox["Degree",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Degree"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["\[Degree]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Degree"]], "InlineFunctionSans"],
 ") \[LongDash] constant to convert from radians to degrees"
}], "GuideText",
 CellID->28781],

Cell[TextData[{
 Cell[TextData[ButtonBox["I",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/I"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["\[ImaginaryI]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/I"]], "InlineFunctionSans"],
 ") \[LongDash] ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"-", "1"}]], TraditionalForm]], "InlineMath"],
 ", entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]ii\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " (\"imaginary i\")"
}], "GuideText",
 CellID->20990],

Cell["\t", "GuideDelimiter",
 CellID->21302],

Cell[TextData[{
 Cell[TextData[ButtonBox["FullSimplify",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FullSimplify"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " simplify trigonometric expressions"
}], "GuideText",
 CellID->502],

Cell[TextData[{
 Cell[TextData[ButtonBox["FunctionExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FunctionExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " reduce to algebraic forms or simpler arguments"
}], "GuideText",
 CellID->26928],

Cell["\t", "GuideDelimiter",
 CellID->30721],

Cell[TextData[{
 Cell[TextData[ButtonBox["TrigExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TrigExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     ButtonBox["Sin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sin"], "[", 
     RowBox[{"2", 
      StyleBox["x", "TI"]}], "]"}], "\[LongRightArrow]", "2"}], " ", 
   RowBox[{
    ButtonBox["Sin",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Sin"], "[", 
    StyleBox["x", "TI"], "]"}], 
   RowBox[{
    ButtonBox["Cos",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Cos"], "[", 
    StyleBox["x", "TI"], "]"}]}]], "InlineFormula"],
 " etc."
}], "GuideText",
 CellID->24898],

Cell[TextData[{
 Cell[TextData[ButtonBox["TrigFactor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TrigFactor"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     ButtonBox["Sin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sin"], "[", "..", "]"}], "+", 
    RowBox[{
     ButtonBox["Sin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sin"], "[", "..", "]"}]}], "\[Rule]"}]], 
  "InlineFormula"],
 "product of terms, etc."
}], "GuideText",
 CellID->31447],

Cell[TextData[{
 Cell[TextData[ButtonBox["TrigReduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TrigReduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 Cell[BoxData[
  RowBox[{"2", " ", 
   RowBox[{
    ButtonBox["Sin",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Sin"], "[", 
    StyleBox["x", "TI"], "]"}], 
   RowBox[{
    RowBox[{
     ButtonBox["Cos",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cos"], "[", 
     StyleBox["x", "TI"], "]"}], "\[LongRightArrow]", 
    RowBox[{
     ButtonBox["Sin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sin"], "[", 
     RowBox[{"2", 
      StyleBox["x", "TI"]}], "]"}]}]}]], "InlineFormula"],
 " etc."
}], "GuideText",
 CellID->10945],

Cell[TextData[{
 Cell[TextData[ButtonBox["TrigToExp",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TrigToExp"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ExpToTrig",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ExpToTrig"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert between trigonometric functions and exponentials"
}], "GuideText",
 CellID->2222],

Cell[TextData[{
 Cell[TextData[ButtonBox["ComplexExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ComplexExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " expand into real and imaginary parts"
}], "GuideText",
 CellID->8686]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->5794],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "GuideTutorial",
 CellID->23577],

Cell[TextData[ButtonBox["Trigonometric Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TrigonometricExpressions"]], "GuideTutorial",
 CellID->12844],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "GuideTutorial",
 CellID->116573284]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->18683],

Cell[TextData[ButtonBox["Hyperbolic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HyperbolicFunctions"]], "GuideMoreAbout",
 CellID->21547],

Cell[TextData[ButtonBox["Sound and Sonification",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SoundAndSonification"]], "GuideMoreAbout",
 CellID->13240],

Cell[TextData[ButtonBox["Elementary Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementaryFunctions"]], "GuideMoreAbout",
 CellID->12933]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->64148170],

Cell[TextData[{
 ButtonBox["Demonstrations related to Trigonometric Functions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
ArcCos+OR+ArcCot+OR+ArcCsc+OR+ArcSec+OR+ArcSin+OR+ArcTan+OR+ComplexExpand+OR+\
Cos+OR+Cot+OR+Csc+OR+Degree+OR+ExpToTrig+OR+FullSimplify+OR+FunctionExpand+OR+\
I+OR+Sec+OR+Sin+OR+Tan+OR+TrigExpand+OR+TrigFactor+OR+TrigReduce+OR+TrigToExp)\
"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->119800695]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Trigonometric Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 30.2538614}", "context" -> "", 
    "keywords" -> {
     "acos", "acot", "acsc", "angle", "angle measure", "angle measurement", 
      "angular measure", "arc", "arc cos", "arc cot", "arc csc", "arc sec", 
      "arc sin", "arc tan", "arccosec", "arccosecant", "arccosine", 
      "arccotangent", "arcctg", "arcdegree", "arcosec", "arcsecant", 
      "arcsine", "arcsinus", "arctangent", "arctg", "arcus cosecans", 
      "arcus cosinus", "arcus cotangens", "arcus secans", "arcus sinus", 
      "arcus tangens", "asec", "asin", "atan", "circular functions", 
      "complex expand", "complex exponentials", "complex powers", 
      "compound arguments", "conversion", "cosec", "cosecant", "csc", 
      "degree", "degree of arc", "de Moivre's Theorem", "Euler's formula", 
      "exp to trig", "expanding into polar form", 
      "expanding into real and imaginary parts", "exponentials", 
      "factorial simplification", "factoring", "hyperbolic functions", 
      "imaginary unit", "inverse cosecant", "inverse cosine", 
      "inverse cotangent", "inverse secant", "inverse sin", "inverse sine", 
      "inverse tan function", "inverse tangent", 
      "inverse trigonometric function", "multiple angle formulas", 
      "plane angle", "polar angles", "powers", "radian", 
      "radical simplification", "relations", "roots", "sec", "secant", "sen", 
      "sin", "sine", "sinus", "speed", "tan", "tangent", "tg", "trig expand", 
      "trig factor", "trigonometric expansion", "trigonometric functions", 
      "trigonometric simplification", "trig reduce", "trig to exp"}, "index" -> 
    True, "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "With careful attention to branch cuts, Mathematica supports \
trigonometric functions everywhere in the complex plane, with extensive exact \
and algebraic transformations, together with efficient arbitrary-precision \
numerical evaluation. Mathematica follows the standard mathematical \
convention of using radians for trigonometric function arguments.", 
    "synonyms" -> {}, "title" -> "Trigonometric Functions", "type" -> "Guide",
     "uri" -> "guide/TrigonometricFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 61, 1, 70, "GuideTitle",
 CellID->24618],
Cell[683, 28, 498, 12, 70, "GuideAbstract",
 CellID->417688928],
Cell[1184, 42, 1163, 35, 70, "InlineGuideFunctionListing",
 CellID->8672],
Cell[2350, 79, 1199, 35, 70, "InlineGuideFunctionListing",
 CellID->1563],
Cell[3552, 116, 47, 1, 70, "GuideDelimiter",
 CellID->78383194],
Cell[3602, 119, 351, 10, 70, "GuideText",
 CellID->28781],
Cell[3956, 131, 550, 19, 70, "GuideText",
 CellID->20990],
Cell[4509, 152, 44, 1, 70, "GuideDelimiter",
 CellID->21302],
Cell[4556, 155, 260, 8, 70, "GuideText",
 CellID->502],
Cell[4819, 165, 278, 8, 70, "GuideText",
 CellID->26928],
Cell[5100, 175, 44, 1, 70, "GuideDelimiter",
 CellID->30721],
Cell[5147, 178, 748, 28, 70, "GuideText",
 CellID->24898],
Cell[5898, 208, 562, 21, 70, "GuideText",
 CellID->31447],
Cell[6463, 231, 753, 28, 70, "GuideText",
 CellID->10945],
Cell[7219, 261, 406, 12, 70, "GuideText",
 CellID->2222],
Cell[7628, 275, 265, 8, 70, "GuideText",
 CellID->8686]
}, Open  ]],
Cell[CellGroupData[{
Cell[7930, 288, 57, 1, 70, "GuideTutorialsSection",
 CellID->5794],
Cell[7990, 291, 186, 4, 70, "GuideTutorial",
 CellID->23577],
Cell[8179, 297, 164, 3, 70, "GuideTutorial",
 CellID->12844],
Cell[8346, 302, 171, 3, 70, "GuideTutorial",
 CellID->116573284]
}, Open  ]],
Cell[CellGroupData[{
Cell[8554, 310, 59, 1, 70, "GuideMoreAboutSection",
 CellID->18683],
Cell[8616, 313, 152, 3, 70, "GuideMoreAbout",
 CellID->21547],
Cell[8771, 318, 155, 3, 70, "GuideMoreAbout",
 CellID->13240],
Cell[8929, 323, 165, 3, 70, "GuideMoreAbout",
 CellID->12933]
}, Open  ]],
Cell[CellGroupData[{
Cell[9131, 331, 68, 1, 70, "GuideRelatedLinksSection",
 CellID->64148170],
Cell[9202, 334, 685, 18, 70, "GuideRelatedLinks",
 CellID->119800695]
}, Open  ]],
Cell[9902, 355, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

