(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13742,        458]
NotebookOptionsPosition[     10990,        376]
NotebookOutlinePosition[     12064,        405]
CellTagsIndexPosition[     12021,        402]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Variant Letters", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "In catering to the fine points of mathematical typesetting and notational \
clarity, ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "provides a variety of special variant forms of letters. "
}], "GuideAbstract",
 CellID->370814146],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Notation and Doubled Letters"
}], "GuideFunctionsSubsection",
 CellID->13616218],

Cell[TextData[{
 Cell[TextData[ButtonBox["\[ImaginaryI]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ImaginaryI"]], "InlineFunctionSans"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[ImaginaryI]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/ImaginaryI"]], "InlineCharacterName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " special form of ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " representing ",
 Cell[BoxData[
  SqrtBox[
   RowBox[{"-", "1"}]]], "InlineFormula"],
 " (entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]ii\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")"
}], "GuideText",
 CellID->707566154],

Cell[TextData[{
 Cell[TextData[ButtonBox["\[ConstantC]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ConstantC"]], "InlineFunctionSans"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[ConstantC]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/ConstantC"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[DifferentialD]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DifferentialD"]], "InlineFunctionSans"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[DifferentialD]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/DifferentialD"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[ExponentialE]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ExponentialE"]], "InlineFunctionSans"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[ExponentialE]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/ExponentialE"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[ImaginaryJ]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ImaginaryJ"]], "InlineFunctionSans"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[ImaginaryJ]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/ImaginaryJ"]], "InlineCharacterName"]
}], "InlineGuideFunctionListing",
 CellID->215779674],

Cell[TextData[{
 Cell[TextData[ButtonBox["\[DoubledGamma]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DoubledGamma"]], "InlineFunctionSans"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[DoubledGamma]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/DoubledGamma"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[DoubledPi]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DoubledPi"]], "InlineFunctionSans"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[DoubledPi]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/DoubledPi"]], "InlineCharacterName"]
}], "InlineGuideFunctionListing",
 CellID->182581920],

Cell["\t", "GuideDelimiterSubsection",
 CellID->129315664]
}, Open  ]],

Cell[CellGroupData[{

Cell["Special Letter-Based Forms", "GuideFunctionsSubsection",
 CellID->229350169],

Cell[TextData[{
 Cell[TextData[ButtonBox["\[Micro]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Micro"]], "InlineFunctionSans"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[Micro]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Micro"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[Angstrom]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Angstrom"]], "InlineFunctionSans"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[Angstrom]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Angstrom"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[HBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/HBar"]], "InlineFunctionSans"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[HBar]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/HBar"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[WeierstrassP]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/WeierstrassP"]], "InlineFunctionSans"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[WeierstrassP]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/WeierstrassP"]], "InlineCharacterName"]
}], "InlineGuideFunctionListing",
 CellID->36444766],

Cell["\t", "GuideDelimiterSubsection",
 CellID->68646030]
}, Open  ]],

Cell[CellGroupData[{

Cell["Variant Greek Letters", "GuideFunctionsSubsection",
 CellID->93566279],

Cell[TextData[{
 Cell[TextData[ButtonBox["\[CurlyEpsilon]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CurlyEpsilon"]], "InlineFunctionSans"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[CurlyEpsilon]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/CurlyEpsilon"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CurlyTheta]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CurlyTheta"]], "InlineFunctionSans"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[CurlyTheta]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/CurlyTheta"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CurlyKappa]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CurlyKappa"]], "InlineFunctionSans"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[CurlyKappa]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/CurlyKappa"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CurlyPi]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CurlyPi"]], "InlineFunctionSans"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[CurlyPi]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/CurlyPi"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CurlyRho]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CurlyRho"]], "InlineFunctionSans"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[CurlyRho]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/CurlyRho"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[FinalSigma]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/FinalSigma"]], "InlineFunctionSans"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[FinalSigma]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/FinalSigma"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CurlyPhi]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CurlyPhi"]], "InlineFunctionSans"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[CurlyPhi]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/CurlyPhi"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\[CurlyCapitalUpsilon]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CurlyCapitalUpsilon"]], 
  "InlineFunctionSans"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[CurlyCapitalUpsilon]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/CurlyCapitalUpsilon"]], 
  "InlineCharacterName"]
}], "InlineGuideFunctionListing",
 CellID->306787546],

Cell["\t", "GuideDelimiterSubsection",
 CellID->344693794]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dotless Letters", "GuideFunctionsSubsection",
 CellID->221596853],

Cell[TextData[{
 Cell[TextData[ButtonBox["\[DotlessI]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DotlessI"]], "InlineFunctionSans"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[DotlessI]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/DotlessI"]], "InlineCharacterName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " dotless ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 ", used for unit vectors with hats, etc."
}], "GuideText",
 CellID->716676037],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\\[DotlessJ]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/DotlessJ"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[ScriptDotlessI]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/ScriptDotlessI"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\\[ScriptDotlessJ]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/ScriptDotlessJ"]], 
  "InlineCharacterName"]
}], "InlineGuideFunctionListing",
 CellID->287564312]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Notational Alphabets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotationalAlphabetCharacters"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Greek Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GreekLetters"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "GuideMoreAbout",
 CellID->270810353],

Cell[TextData[ButtonBox["Listing of All Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "GuideMoreAbout",
 CellID->37101391]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Variant Letters - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 36.1602626}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "", "status" -> "None", "summary" -> 
    "In catering to the fine points of mathematical typesetting and \
notational clarity, Mathematica provides a variety of special variant forms \
of letters. ", "synonyms" -> {}, "title" -> "Variant Letters", "type" -> 
    "Guide", "uri" -> "guide/VariantLetters"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 57, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[679, 28, 256, 7, 70, "GuideAbstract",
 CellID->370814146],
Cell[CellGroupData[{
Cell[960, 39, 148, 5, 70, "GuideFunctionsSubsection",
 CellID->13616218],
Cell[1111, 46, 697, 24, 70, "GuideText",
 CellID->707566154],
Cell[1811, 72, 1495, 44, 70, "InlineGuideFunctionListing",
 CellID->215779674],
Cell[3309, 118, 732, 21, 70, "InlineGuideFunctionListing",
 CellID->182581920],
Cell[4044, 141, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->129315664]
}, Open  ]],
Cell[CellGroupData[{
Cell[4139, 147, 82, 1, 70, "GuideFunctionsSubsection",
 CellID->229350169],
Cell[4224, 150, 1431, 43, 70, "InlineGuideFunctionListing",
 CellID->36444766],
Cell[5658, 195, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->68646030]
}, Open  ]],
Cell[CellGroupData[{
Cell[5752, 201, 76, 1, 70, "GuideFunctionsSubsection",
 CellID->93566279],
Cell[5831, 204, 2994, 89, 70, "InlineGuideFunctionListing",
 CellID->306787546],
Cell[8828, 295, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->344693794]
}, Open  ]],
Cell[CellGroupData[{
Cell[8923, 301, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->221596853],
Cell[8997, 304, 491, 16, 70, "GuideText",
 CellID->716676037],
Cell[9491, 322, 691, 22, 70, "InlineGuideFunctionListing",
 CellID->287564312]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10231, 350, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[10296, 353, 165, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[10464, 358, 143, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[10610, 363, 164, 3, 70, "GuideMoreAbout",
 CellID->270810353],
Cell[10777, 368, 171, 3, 70, "GuideMoreAbout",
 CellID->37101391]
}, Open  ]],
Cell[10963, 374, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

