(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15900,        502]
NotebookOptionsPosition[     11384,        383]
NotebookOutlinePosition[     13849,        433]
CellTagsIndexPosition[     13806,        430]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Viewers and Annotation", "GuideTitle",
 CellID->21735],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s dynamic interactivity system makes it easy to view and annotate any \
object in a dynamic way. Building on ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic programming architecture, constructs can be nested and combined \
in arbitrary ways, and both their content and control can be fully dynamic \
and programmatic."
}], "GuideAbstract",
 CellID->32389],

Cell[TextData[{
 Cell[TextData[ButtonBox["TabView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TabView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "make any list of objects be selectable with tabs"
}], "GuideText",
 CellID->786],

Cell[TextData[{
 Cell[TextData[ButtonBox["SlideView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SlideView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "view any list of objects as a sequence of slides"
}], "GuideText",
 CellID->8381],

Cell[TextData[{
 Cell[TextData[ButtonBox["FlipView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FlipView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "flip between displaying two or more objects"
}], "GuideText",
 CellID->31785],

Cell[TextData[{
 Cell[TextData[ButtonBox["MenuView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MenuView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["OpenerView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/OpenerView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PopupView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PopupView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->522],

Cell["\t", "GuideDelimiter",
 CellID->18345],

Cell[TextData[{
 Cell[TextData[ButtonBox["Labeled",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Labeled"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "associate any label with any object"
}], "GuideText",
 CellID->20979],

Cell[TextData[{
 Cell[TextData[ButtonBox["Framed",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Framed"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "put a frame around an object"
}], "GuideText",
 CellID->16085],

Cell[TextData[{
 Cell[TextData[ButtonBox["Panel",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Panel"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "put an object in a panel"
}], "GuideText",
 CellID->15713],

Cell[TextData[{
 Cell[TextData[ButtonBox["Text",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Text"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Style",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Style"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Row",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Row"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Column",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Column"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Grid",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Grid"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->741103048],

Cell["\t", "GuideDelimiter",
 CellID->30935],

Cell[TextData[{
 Cell[TextData[ButtonBox["Tooltip",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tooltip"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "attach any tooltip to any object"
}], "GuideText",
 CellID->19735],

Cell[TextData[{
 Cell[TextData[ButtonBox["Mouseover",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Mouseover"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "specify what to show when the mouse is over an object"
}], "GuideText",
 CellID->30883],

Cell[TextData[{
 Cell[TextData[ButtonBox["StatusArea",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/StatusArea"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "put a string in the window status area"
}], "GuideText",
 CellID->2186],

Cell[TextData[{
 Cell[TextData[ButtonBox["PopupWindow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PopupWindow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "attach a popup window with any content"
}], "GuideText",
 CellID->83264736],

Cell["\t", "GuideDelimiter",
 CellID->16096],

Cell[TextData[{
 Cell[TextData[ButtonBox["Annotation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Annotation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "attach a general annotation to an object"
}], "GuideText",
 CellID->20648],

Cell[TextData[{
 Cell[TextData[ButtonBox["MouseAnnotation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MouseAnnotation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find the annotation for the object the mouse is over"
}], "GuideText",
 CellID->2085],

Cell["\t", "GuideDelimiter",
 CellID->14752],

Cell[TextData[{
 Cell[TextData[ButtonBox["Monitor",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Monitor"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "monitor the progress of a computation"
}], "GuideText",
 CellID->521],

Cell["\t", "GuideDelimiter",
 CellID->9260],

Cell[TextData[{
 Cell[TextData[ButtonBox["Manipulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Manipulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "general interactive manipulation"
}], "GuideText",
 CellID->21982],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListAnimate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListAnimate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "animate a list of graphics or other objects"
}], "GuideText",
 CellID->6636]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->7688],

Cell[TextData[ButtonBox["Views",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Views"]], "GuideTutorial",
 CellID->684899832]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->26792],

Cell[TextData[ButtonBox["Dynamic Interactivity Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicInteractivityLanguage"]], "GuideMoreAbout",
 CellID->27065],

Cell[TextData[ButtonBox["Layout & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LayoutAndTables"]], "GuideMoreAbout",
 CellID->19278],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "GuideMoreAboutSub",
 CellID->31496],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "GuideMoreAbout",
 CellID->184873245],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60VisualizationAndGraphics"]], "GuideMoreAbout",
 CellID->164100761]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Viewers and Annotation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 36.4727706}", "context" -> "", 
    "keywords" -> {
     "2D layout", "animate sequence of expressions", "applets", 
      "background panel", "balloon help", "click view", 
      "click-interactive panels", "controls", "cycling between views", 
      "direct manipulation", "display panel", "display style", "flip view", 
      "formulas in 3D graphics", "formulas in graphics", 
      "formulas in notebooks", "framed (Version 1 option)", "gamepad", 
      "graphical user interface", "GUI", "information drill down", 
      "information drilldown", "interactive", "interactive panels", 
      "interface builder", "joystick", "list animate", "list of frames", 
      "make movie", "mouse annotation", "mouse interactive", "mouse over", 
      "open viewer", "opener view", "popup box", "popup view", "popup window",
       "screen tip", "ScreenTip", "slide sequence", "slide show", 
      "slide view", "slider", "spread-sheet", "spreadsheet", "status area", 
      "tab selector", "tab view", "tab view control", "table", 
      "tabular layout", "tabulation", "text in 3D graphics", 
      "text in graphics", "text in notebooks", "textual form in 3D graphics", 
      "textual form in graphics", "textual form in notebooks", 
      "user interfaces"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica's dynamic interactivity system makes it easy to view and \
annotate any object in a dynamic way. Building on Mathematica's symbolic \
programming architecture, constructs can be nested and combined in arbitrary \
ways, and both their content and control can be fully dynamic and \
programmatic.", "synonyms" -> {}, "title" -> "Viewers and Annotation", "type" -> 
    "Guide", "uri" -> "guide/ViewersAndAnnotation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 60, 1, 70, "GuideTitle",
 CellID->21735],
Cell[682, 28, 441, 11, 70, "GuideAbstract",
 CellID->32389],
Cell[1126, 41, 414, 12, 70, "GuideText",
 CellID->786],
Cell[1543, 55, 419, 12, 70, "GuideText",
 CellID->8381],
Cell[1965, 69, 413, 12, 70, "GuideText",
 CellID->31785],
Cell[2381, 83, 1039, 26, 70, "InlineGuideFunctionListing",
 CellID->522],
Cell[3423, 111, 44, 1, 70, "GuideDelimiter",
 CellID->18345],
Cell[3470, 114, 403, 12, 70, "GuideText",
 CellID->20979],
Cell[3876, 128, 394, 12, 70, "GuideText",
 CellID->16085],
Cell[4273, 142, 388, 12, 70, "GuideText",
 CellID->15713],
Cell[4664, 156, 1564, 41, 70, "InlineGuideFunctionListing",
 CellID->741103048],
Cell[6231, 199, 44, 1, 70, "GuideDelimiter",
 CellID->30935],
Cell[6278, 202, 400, 12, 70, "GuideText",
 CellID->19735],
Cell[6681, 216, 425, 12, 70, "GuideText",
 CellID->30883],
Cell[7109, 230, 411, 12, 70, "GuideText",
 CellID->2186],
Cell[7523, 244, 417, 12, 70, "GuideText",
 CellID->83264736],
Cell[7943, 258, 44, 1, 70, "GuideDelimiter",
 CellID->16096],
Cell[7990, 261, 414, 12, 70, "GuideText",
 CellID->20648],
Cell[8407, 275, 435, 12, 70, "GuideText",
 CellID->2085],
Cell[8845, 289, 44, 1, 70, "GuideDelimiter",
 CellID->14752],
Cell[8892, 292, 403, 12, 70, "GuideText",
 CellID->521],
Cell[9298, 306, 43, 1, 70, "GuideDelimiter",
 CellID->9260],
Cell[9344, 309, 406, 12, 70, "GuideText",
 CellID->21982],
Cell[9753, 323, 418, 12, 70, "GuideText",
 CellID->6636]
}, Open  ]],
Cell[CellGroupData[{
Cell[10208, 340, 57, 1, 70, "GuideTutorialsSection",
 CellID->7688],
Cell[10268, 343, 129, 3, 70, "GuideTutorial",
 CellID->684899832]
}, Open  ]],
Cell[CellGroupData[{
Cell[10434, 351, 59, 1, 70, "GuideMoreAboutSection",
 CellID->26792],
Cell[10496, 354, 171, 3, 70, "GuideMoreAbout",
 CellID->27065],
Cell[10670, 359, 143, 3, 70, "GuideMoreAbout",
 CellID->19278],
Cell[10816, 364, 157, 3, 70, "GuideMoreAboutSub",
 CellID->31496],
Cell[10976, 369, 176, 3, 70, "GuideMoreAbout",
 CellID->184873245],
Cell[11155, 374, 187, 4, 70, "GuideMoreAbout",
 CellID->164100761]
}, Open  ]],
Cell[11357, 381, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

