(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10696,        358]
NotebookOptionsPosition[      7586,        267]
NotebookOutlinePosition[      9078,        303]
CellTagsIndexPosition[      9035,        300]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Web Operations", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides many mechanisms for interfacing with the web\[LongDash]from \
exporting graphics and structured active documents, to interacting with web \
services, importing web data, supporting web-oriented XML, interfacing with \
web servers, and creating complete web",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "-driven websites."
}], "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Creating Web Pages \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CreatingWebPages"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->635639774],

Cell[TextData[{
 Cell[TextData[ButtonBox["Export",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Export"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "export any graphic, expression or notebook to all standard web formats"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"HTML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HTML"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"GIF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/GIF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"JPEG\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/JPEG"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"Flash\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/SWF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"XHTML+MathML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XHTMLMathML"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"PDF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PDF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/CreatingWebPages"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->56660330]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Web Import \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/WebFormats"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->453862854],

Cell[TextData[{
 Cell[TextData[ButtonBox["Import",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Import"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " import from web URLs, extracting data and content"
}], "GuideText",
 CellID->537113828],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"HTML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/HTML"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"XML\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XML"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"ApacheLog\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ApacheLog"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"RSS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/RSS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/WebFormats"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->123659359]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Web Services \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:WebServices/guide/WebServiceOperations"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->303367770],

Cell[TextData[{
 Cell[TextData[ButtonBox["InstallService",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/InstallService"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "install web services from a WSDL description"
}], "GuideText",
 CellID->320785531]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["XML \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/XMLImportAndExport"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->393687744],

Cell[TextData[{
 Cell[TextData[ButtonBox["XMLElement",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/XMLElement"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["XMLObject",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/XMLObject"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "general symbolic representation of XML"
}], "GuideText",
 CellID->392042457]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Exchanging Material with the Web",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExchangingMaterialWithTheWeb"]], "GuideTutorial",\

 CellID->536319828],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternetConnectivity"],
  FontSlant->"Italic"],
 ButtonBox[" Internet Connectivity",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternetConnectivity"]
}], "GuideTutorial",
 CellID->134075405]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Systems Interfaces & Deployment",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/SystemsInterfacesAndDeploymentOverview"]], "GuideMoreAbout",
 CellID->431270840],

Cell[TextData[ButtonBox["Web Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebFormats"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->691481123],

Cell[TextData[{
 ButtonBox["web",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/webmathematica"], None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/webmathematica"], None}],
  FontSlant->"Italic"]
}], "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Web Operations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 37.2696660}", "context" -> "", 
    "keywords" -> {
     "download from internet", "ExpressionML", "external data", "ftp", 
      "get data from web", "http", "import html", "install service", 
      "NotebookML", "SymbolicXML", "URLs", "web", "web import", "website", 
      "XML", "xml element", "xml object"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica provides many mechanisms for interfacing with the web--from \
exporting graphics and structured active documents, to interacting with web \
services, importing web data, supporting web-oriented XML, interfacing with \
web servers, and creating complete webMathematica-driven websites.", 
    "synonyms" -> {}, "title" -> "Web Operations", "type" -> "Guide", "uri" -> 
    "guide/WebOperations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 56, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[678, 28, 447, 11, 70, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[1150, 43, 222, 5, 70, "GuideFunctionsSubsection",
 CellID->635639774],
Cell[1375, 50, 295, 9, 70, "GuideText",
 CellID->203374175],
Cell[1673, 61, 1469, 41, 70, "InlineGuideFunctionListing",
 CellID->56660330]
}, Open  ]],
Cell[CellGroupData[{
Cell[3179, 107, 208, 5, 70, "GuideFunctionsSubsection",
 CellID->453862854],
Cell[3390, 114, 269, 8, 70, "GuideText",
 CellID->537113828],
Cell[3662, 124, 1037, 29, 70, "InlineGuideFunctionListing",
 CellID->123659359]
}, Open  ]],
Cell[CellGroupData[{
Cell[4736, 158, 232, 5, 70, "GuideFunctionsSubsection",
 CellID->303367770],
Cell[4971, 165, 430, 12, 70, "GuideText",
 CellID->320785531]
}, Open  ]],
Cell[CellGroupData[{
Cell[5438, 182, 209, 5, 70, "GuideFunctionsSubsection",
 CellID->393687744],
Cell[5650, 189, 400, 13, 70, "GuideText",
 CellID->392042457]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6099, 208, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[6164, 211, 181, 4, 70, "GuideTutorial",
 CellID->536319828],
Cell[6348, 217, 303, 9, 70, "GuideTutorial",
 CellID->134075405]
}, Open  ]],
Cell[CellGroupData[{
Cell[6688, 231, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[6753, 234, 189, 4, 70, "GuideMoreAbout",
 CellID->431270840],
Cell[6945, 240, 138, 3, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[CellGroupData[{
Cell[7120, 248, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->691481123],
Cell[7192, 251, 352, 11, 70, "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],
Cell[7559, 265, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

