(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8021,        261]
NotebookOptionsPosition[      4661,        174]
NotebookOutlinePosition[      6849,        220]
CellTagsIndexPosition[      6806,        217]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Zeta Functions & Polylogarithms", "GuideTitle",
 CellID->21011],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports zeta and polylogarithm functions of a complex variable in full \
generality, performing efficient arbitrary-precision evaluation and \
implementing extensive symbolic transformations."
}], "GuideAbstract",
 CellID->315639797],

Cell[TextData[{
 Cell[TextData[ButtonBox["Zeta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Zeta"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Riemann and Hurwitz zeta function"
}], "GuideText",
 CellID->7245],

Cell[TextData[{
 Cell[TextData[ButtonBox["RiemannSiegelZ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RiemannSiegelZ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RiemannSiegelTheta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RiemannSiegelTheta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StieltjesGamma",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StieltjesGamma"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->6702],

Cell[TextData[{
 Cell[TextData[ButtonBox["ZetaZero",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ZetaZero"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "zeros of the zeta function on the critical line"
}], "GuideText",
 CellID->215022630],

Cell["\t", "GuideDelimiter",
 CellID->28564],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolyLog",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PolyLog"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ordinary and Nielsen generalized polylogarithm function"
}], "GuideText",
 CellID->31539],

Cell[TextData[{
 Cell[TextData[ButtonBox["LerchPhi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LerchPhi"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Lerch ",
 Cell[BoxData[
  FormBox["\[CapitalPhi]", TraditionalForm]], "InlineMath"],
 " function"
}], "GuideText",
 CellID->2572],

Cell["\t", "GuideDelimiter",
 CellID->71108413],

Cell[TextData[{
 Cell[TextData[ButtonBox["FunctionExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FunctionExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "expand out symbolic forms of functions"
}], "GuideText",
 CellID->39319744]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->2257],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "GuideTutorial",
 CellID->16541]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->31654],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "GuideMoreAbout",
 CellID->11080],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "GuideMoreAbout",
 CellID->19359]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->109729704],

Cell[TextData[{
 ButtonBox["Demonstrations related to Zeta Functions & Polylogarithms",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
FunctionExpand+OR+LerchPhi+OR+PolyLog+OR+RiemannSiegelTheta+OR+RiemannSiegelZ+\
OR+StieltjesGamma+OR+Zeta+OR+ZetaZero)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->649389986]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Zeta Functions & Polylogarithms - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 43.3635720}", "context" -> "", 
    "keywords" -> {
     "Catalan beta function", "Clausen function", "dilog", 
      "dilogarithm function", "Dirichlet L series", 
      "Euler-Maclaurin summation", "Euler's constant", 
      "Fermi-Dirac integrals", "generalization of Euler's constant", 
      "generalized zeta function", "harmonic sums", "Hurwitz zeta function", 
      "hyperlogarithm", "Jonquiere's function", "Keiper's algorithm", 
      "Lerch function Phi", "Lerch phi", "Lerch transcendent", 
      "L-series in number theory", "Nielsen functions", "phi", "poly log", 
      "polylogarithm", "reduction formulas", "reflection formulas", 
      "Riemann hypothesis", "Riemann Siegel", "Riemann Siegel theta", 
      "Riemann-Siegel", "Riemann-Siegel formula", "Riemann-Siegel theta", 
      "Riemann zeta function", "special functions", "Spence's integral", 
      "Stieltjes' constants", "Stieltjes' gamma", "sums of reciprocal powers",
       "transformations", "trilogarithm", "zeta function", 
      "zeta function root", "zeta zero"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica supports zeta and polylogarithm functions of a complex \
variable in full generality, performing efficient arbitrary-precision \
evaluation and implementing extensive symbolic transformations.", 
    "synonyms" -> {}, "title" -> "Zeta Functions & Polylogarithms", "type" -> 
    "Guide", "uri" -> "guide/ZetaFunctionsAndPolylogarithms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 69, 1, 70, "GuideTitle",
 CellID->21011],
Cell[691, 28, 302, 7, 70, "GuideAbstract",
 CellID->315639797],
Cell[996, 37, 244, 8, 70, "GuideText",
 CellID->7245],
Cell[1243, 47, 643, 17, 70, "InlineGuideFunctionListing",
 CellID->6702],
Cell[1889, 66, 421, 12, 70, "GuideText",
 CellID->215022630],
Cell[2313, 80, 44, 1, 70, "GuideDelimiter",
 CellID->28564],
Cell[2360, 83, 273, 8, 70, "GuideText",
 CellID->31539],
Cell[2636, 93, 315, 11, 70, "GuideText",
 CellID->2572],
Cell[2954, 106, 47, 1, 70, "GuideDelimiter",
 CellID->71108413],
Cell[3004, 109, 278, 9, 70, "GuideText",
 CellID->39319744]
}, Open  ]],
Cell[CellGroupData[{
Cell[3319, 123, 57, 1, 70, "GuideTutorialsSection",
 CellID->2257],
Cell[3379, 126, 148, 3, 70, "GuideTutorial",
 CellID->16541]
}, Open  ]],
Cell[CellGroupData[{
Cell[3564, 134, 59, 1, 70, "GuideMoreAboutSection",
 CellID->31654],
Cell[3626, 137, 163, 3, 70, "GuideMoreAbout",
 CellID->11080],
Cell[3792, 142, 146, 3, 70, "GuideMoreAbout",
 CellID->19359]
}, Open  ]],
Cell[CellGroupData[{
Cell[3975, 150, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->109729704],
Cell[4047, 153, 572, 16, 70, "GuideRelatedLinks",
 CellID->649389986]
}, Open  ]],
Cell[4634, 172, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

