(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12112,        413]
NotebookOptionsPosition[      9479,        327]
NotebookOutlinePosition[     10719,        363]
CellTagsIndexPosition[     10634,        358]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Error and Interrupt Handling" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ErrorAndInterruptHandling"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Error and Interrupt Handling\"\>", 
       2->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       4->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLSetMessageHandler()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLSetMessageHandler"], 
          "MLMessageHandlerObject()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLMessageHandlerObject"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"MLSetMessageHandler()\"\>", 
       2->"\<\"MLMessageHandlerObject()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLAbort", "ObjectNameAlt",
 CellID->27388],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell["int MLAbort", "InlineCode"],
     "\[LineSeparator]is a global variable set when a program created using ",
     
     Cell[BoxData[
      ButtonBox["mcc",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/program/mcc"]], "InlineCode"],
     " or ",
     Cell[BoxData[
      ButtonBox["mprep",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/program/mprep"]], "InlineCode"],
     " has been sent an abort message. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29646]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkInterrupt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkInterrupt"], "[", 
   StyleBox["link", "TI"], "]"}]], "InlineCode"],
 " can be used to send an abort interrupt from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to a program connected to a particular link. "
}], "Notes",
 CellID->14868],

Cell[TextData[{
 StyleBox["MLAbort", "InlineCode"],
 " is set to 1 if the program has received an abort message; otherwise the \
value is 0."
}], "Notes",
 CellID->904102807],

Cell[TextData[{
 StyleBox["MLAbort()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->561086849],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->153241358],

Cell["\<\
#include <math.h>
#include \"mathlink.h\"

/* totals the numbers and calculates the square root */

double f(double* list, int len)
{
\tdouble sum;

\twhile(len--)
\t{
\t\tsum += *list++;
\t\t/* check for the abort */
\t\tif(MLAbort) return (double)0;
\t}

\treturn sqrt(sum);
}\
\>", "Program",
 CellID->1291261201]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25065],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLSetMessageHandler()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLSetMessageHandler"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLMessageHandlerObject()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLMessageHandlerObject"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->864695171]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23614],

Cell[TextData[ButtonBox["Error and Interrupt Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ErrorAndInterruptHandling"]], "Tutorials",
 CellID->18108518],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLAbort - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 45, 55.5682800}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLAbortint MLAbort is a global variable set when a program created using \
mcc or mprep has been sent an abort message. ", "synonyms" -> {}, "title" -> 
    "MLAbort", "type" -> "MathLink C Function", "uri" -> "ref/c/MLAbort"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5445, 173, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->561086849]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10491, 351}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2704, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3327, 90, 48, 1, 70, "ObjectNameAlt",
 CellID->27388],
Cell[3378, 93, 667, 21, 70, "Usage",
 CellID->29646]
}, Open  ]],
Cell[CellGroupData[{
Cell[4082, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4560, 136, 373, 12, 70, "Notes",
 CellID->14868],
Cell[4936, 150, 174, 5, 70, "Notes",
 CellID->904102807],
Cell[5113, 157, 295, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[5445, 173, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->561086849],
Cell[CellGroupData[{
Cell[5830, 187, 148, 5, 70, "ExampleSection",
 CellID->153241358],
Cell[5981, 194, 326, 20, 70, "Program",
 CellID->1291261201]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6356, 220, 311, 9, 70, "SeeAlsoSection",
 CellID->25065],
Cell[6670, 231, 485, 13, 70, "SeeAlso",
 CellID->864695171]
}, Open  ]],
Cell[CellGroupData[{
Cell[7192, 249, 314, 9, 70, "TutorialsSection",
 CellID->23614],
Cell[7509, 260, 167, 3, 70, "Tutorials",
 CellID->18108518],
Cell[7679, 265, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[8013, 276, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[8343, 287, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[8706, 301, 299, 8, 70, "MoreAboutSection"],
Cell[9008, 311, 429, 11, 70, "MoreAbout"]
}, Open  ]],
Cell[9452, 325, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

