(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13690,        467]
NotebookOptionsPosition[     10919,        376]
NotebookOutlinePosition[     12181,        413]
CellTagsIndexPosition[     12096,        408]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Running Mathematica from Within an External Program" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Running Mathematica from Within an External Program\"\>", 
       2->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       4->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLOpenArgcArgv()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLOpenArgcArgv"], 
          "MLOpenString()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLOpenString"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLOpenArgcArgv()\"\>", 
       2->"\<\"MLOpenString()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "MathLink Connection Management" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkConnectionManagement"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"MathLink Connection Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLActivate()", "ObjectNameAlt",
 CellID->8168],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLActivate", 
       RowBox[{"(", 
        RowBox[{
         ButtonBox["MLINK",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/c/MLINK"], " ", 
         StyleBox["link", "TI"]}], ")"}]}]], "InlineCode"],
     "\[LineSeparator]activates a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection, waiting for the program at the other end to respond. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26545]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["MLActivate()", "InlineCode"],
 " can be called only after ",
 StyleBox[ButtonBox["MLOpenArgcArgv()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLOpenArgcArgv"], "InlineCode"],
 " or ",
 StyleBox[ButtonBox["MLOpenString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLOpenString"], "InlineCode"],
 ". "
}], "Notes",
 CellID->3317],

Cell[TextData[{
 StyleBox["MLActivate()", "InlineCode"],
 " returns 0 in the event of an error, and a nonzero value if the function \
succeeds."
}], "Notes",
 CellID->415154332],

Cell[TextData[{
 "Use ",
 StyleBox[ButtonBox["MLError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLError"], "InlineCode"],
 " to retrieve the error code if ",
 StyleBox["MLActivate()", "InlineCode"],
 " fails."
}], "Notes",
 CellID->324488821],

Cell[TextData[{
 StyleBox["MLActivate()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->753838702],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->476055129],

Cell["\<\
#include \"mathlink.h\"

/* create a link and establish the connection */

int main(int argc, char **argv)
{
\tMLENV env;
\tMLINK link;
\tint error;

\tenv = MLInitialize((char *)0);
    if(env == (MLENV)0)
      { /* unable to initialize the MathLink environment */ }

\t/* let MLOpenArgcArgv process the command line */
\tlink = MLOpenArgcArgv(env, argc, argv, &error);
\tif(link == (MLINK)0 || error != MLEOK)
      { /* unable to create the link */ }

\t/* MLActivate will establish the connection */
\tif(!MLActivate(link))
      { /* unable to establish communication */ }

\t/* ... */

\tMLClose(link);
\tMLDeinitialize(env);

\treturn 0;
}\
\>", "Program",
 CellID->632709675]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27986],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLOpenArgcArgv()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLOpenArgcArgv"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLOpenString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLOpenString"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->909899748]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9345],

Cell[TextData[{
 ButtonBox["Running ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"],
  FontSlant->"Italic"],
 ButtonBox[" from Within an External Program",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"]
}], "Tutorials",
 CellID->3916],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->150919916],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkConnectionManagement"],
  FontSlant->"Italic"],
 ButtonBox[" Connection Management",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkConnectionManagement"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLActivate() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 46, 2.1778242}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLActivate()int MLActivate(MLINK link) activates a MathLink connection, \
waiting for the program at the other end to respond. ", "synonyms" -> {}, 
    "title" -> "MLActivate", "type" -> "MathLink C Function", "uri" -> 
    "ref/c/MLActivate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5916, 187, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->753838702]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11953, 401}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2924, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3547, 94, 52, 1, 70, "ObjectNameAlt",
 CellID->8168],
Cell[3602, 97, 655, 20, 70, "Usage",
 CellID->26545]
}, Open  ]],
Cell[CellGroupData[{
Cell[4294, 122, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4772, 139, 370, 12, 70, "Notes",
 CellID->3317],
Cell[5145, 153, 177, 5, 70, "Notes",
 CellID->415154332],
Cell[5325, 160, 253, 9, 70, "Notes",
 CellID->324488821],
Cell[5581, 171, 298, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[5916, 187, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->753838702],
Cell[CellGroupData[{
Cell[6301, 201, 148, 5, 70, "ExampleSection",
 CellID->476055129],
Cell[6452, 208, 694, 32, 70, "Program",
 CellID->632709675]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7195, 246, 311, 9, 70, "SeeAlsoSection",
 CellID->27986],
Cell[7509, 257, 455, 13, 70, "SeeAlso",
 CellID->909899748]
}, Open  ]],
Cell[CellGroupData[{
Cell[8001, 275, 313, 9, 70, "TutorialsSection",
 CellID->9345],
Cell[8317, 286, 490, 15, 70, "Tutorials",
 CellID->3916],
Cell[8810, 303, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[9144, 314, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[9474, 325, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[9837, 339, 319, 9, 70, "MoreAboutSection",
 CellID->150919916],
Cell[10159, 350, 429, 11, 70, "MoreAbout"],
Cell[10591, 363, 286, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[10892, 374, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

