(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11831,        403]
NotebookOptionsPosition[      9245,        318]
NotebookOutlinePosition[     10503,        355]
CellTagsIndexPosition[     10418,        350]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Expressions in External Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Expressions in External Programs\"\>", 
       2->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       4->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLCreateMark()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLCreateMark"], 
          "MLSeekToMark()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLSeekToMark"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLCreateMark()\"\>", 
       2->"\<\"MLSeekToMark()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLDestroyMark()", "ObjectNameAlt",
 CellID->16234],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"void", " ", "MLDestroyMark", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["link", "TI"]}], ",", 
         RowBox[{
          ButtonBox["MLMARK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLMARK"], " ", 
          StyleBox["mark", "TI"]}]}], ")"}]}]], "InlineCode"],
     "\[LineSeparator]destroys the specified mark on a link. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21115]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Calling ",
 StyleBox["MLDestroyMark()", "InlineCode"],
 " releases memory associated with the storage of expressions recorded after \
the mark. "
}], "Notes",
 CellID->4410],

Cell[TextData[{
 StyleBox["MLDestroyMark()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->349507268],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->53966498],

Cell["\<\
#include \"mathlink.h\"

/* create a mark in a link, read some data, then back up */

void f(MLINK lp)
{
\tMLMARK mark;

\tmark = MLCreateMark(lp);
\tif(mark == (MLMARK)0)
\t\t{ /* mark creation failed */ }

\t/* read data from the link */

\tMLSeekToMark(lp, mark, 0);

\tMLDestroyMark(lp, mark);
}\
\>", "Program",
 CellID->808831790]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14881],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLCreateMark()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLCreateMark"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLSeekToMark()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLSeekToMark"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->1017798322]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10263],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], "Tutorials",
 CellID->5695],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLDestroyMark() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 46, 10.3655338}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLDestroyMark()void MLDestroyMark(MLINK link,MLMARK mark) destroys the \
specified mark on a link. ", "synonyms" -> {"destroy mark"}, "title" -> 
    "MLDestroyMark", "type" -> "MathLink C Function", "uri" -> 
    "ref/c/MLDestroyMark"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5193, 163, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->349507268]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10275, 343}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2710, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3333, 91, 56, 1, 70, "ObjectNameAlt",
 CellID->16234],
Cell[3392, 94, 754, 23, 70, "Usage",
 CellID->21115]
}, Open  ]],
Cell[CellGroupData[{
Cell[4183, 122, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4661, 139, 191, 6, 70, "Notes",
 CellID->4410],
Cell[4855, 147, 301, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[5193, 163, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->349507268],
Cell[CellGroupData[{
Cell[5578, 177, 147, 5, 70, "ExampleSection",
 CellID->53966498],
Cell[5728, 184, 346, 20, 70, "Program",
 CellID->808831790]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6123, 210, 311, 9, 70, "SeeAlsoSection",
 CellID->14881],
Cell[6437, 221, 452, 13, 70, "SeeAlso",
 CellID->1017798322]
}, Open  ]],
Cell[CellGroupData[{
Cell[6926, 239, 314, 9, 70, "TutorialsSection",
 CellID->10263],
Cell[7243, 250, 199, 4, 70, "Tutorials",
 CellID->5695],
Cell[7445, 256, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[7779, 267, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[8109, 278, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[8472, 292, 299, 8, 70, "MoreAboutSection"],
Cell[8774, 302, 429, 11, 70, "MoreAbout"]
}, Open  ]],
Cell[9218, 316, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

