(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13281,        454]
NotebookOptionsPosition[     10425,        363]
NotebookOutlinePosition[     11742,        400]
CellTagsIndexPosition[     11657,        395]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       2->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLSetUserData()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLSetUserData"], 
          "MLUserData()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLUserData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLSetUserData()\"\>", 
       2->"\<\"MLUserData()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "MathLink Connection Management" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkConnectionManagement"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"MathLink Connection Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLDuplicateLink()", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MLINK",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/c/MLINK"], " ", "MLDuplicateLink", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["parent", "TI"]}], ",", 
         RowBox[{"const", " ", "char", " ", "*", 
          StyleBox["name", "TI"]}], ",", 
         RowBox[{"int", " ", "*", 
          StyleBox["err", "TI"]}]}], ")"}]}]], "InlineCode"],
     " \[LineSeparator]returns a copy of ",
     Cell[BoxData[
      StyleBox["parent", "TI"]], "InlineFormula"],
     " and sets the new link object's name to ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The newly created link has an exact copy of the incoming and outgoing data \
streams of the ",
 Cell[BoxData[
  StyleBox["parent", "TI"]], "InlineFormula"],
 " link."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 StyleBox["MLDuplicateLink()", "InlineCode"],
 " does not copy user data blocks."
}], "Notes",
 CellID->1848196105],

Cell[TextData[{
 "Upon successful completion, ",
 StyleBox["MLDuplicateLink()", "InlineCode"],
 " returns a new link object and sets ",
 Cell[BoxData[
  StyleBox["err", "TI"]], "InlineFormula"],
 " to ",
 StyleBox["MLEOK", "InlineCode"],
 "."
}], "Notes",
 CellID->1428466527],

Cell[TextData[{
 "In the event of an error, ",
 StyleBox["MLDuplicateLink()", "InlineCode"],
 " returns ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    ButtonBox["MLINK",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/c/MLINK"], ")"}], "0"}]], "InlineCode"],
 " and sets ",
 Cell[BoxData[
  StyleBox["err", "TI"]], "InlineFormula"],
 " to the appropriate value."
}], "Notes",
 CellID->1517229476],

Cell[TextData[{
 StyleBox["MLDuplicateLink()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->651234890],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->183696661],

Cell["\<\
#include \"mathlink.h\"

/* make a copy of a link */

MLINK f(MLINK lp)
{
\tMLINK newlink;
\tint error;

\tnewlink = MLDuplicateLink(lp, (const char *)\"Duplicate 1\", &error);
\tif(newlink == (MLINK)0 || error != MLEOK)
\t\t{ /* unable to create a copy of the link */ }

\treturn newlink;
}\
\>", "Program",
 CellID->813155701]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLSetUserData()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLSetUserData"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLUserData()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLUserData"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->1429149499]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkConnectionManagement"],
  FontSlant->"Italic"],
 ButtonBox[" Connection Management",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkConnectionManagement"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLDuplicateLink() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 46, 11.7405690}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLDuplicateLink()MLINK MLDuplicateLink(MLINK parent,const char *name,int \
*err) returns a copy of parent and sets the new link object's name to name.", 
    "synonyms" -> {"duplicate link"}, "title" -> "MLDuplicateLink", "type" -> 
    "MathLink C Function", "uri" -> "ref/c/MLDuplicateLink"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6267, 206, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->651234890]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11514, 388}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2659, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3282, 90, 63, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[3348, 93, 1023, 31, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4408, 129, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4886, 146, 218, 7, 70, "Notes",
 CellID->1067943069],
Cell[5107, 155, 131, 4, 70, "Notes",
 CellID->1848196105],
Cell[5241, 161, 276, 10, 70, "Notes",
 CellID->1428466527],
Cell[5520, 173, 404, 15, 70, "Notes",
 CellID->1517229476],
Cell[5927, 190, 303, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[6267, 206, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->651234890],
Cell[CellGroupData[{
Cell[6652, 220, 148, 5, 70, "ExampleSection",
 CellID->183696661],
Cell[6803, 227, 338, 17, 70, "Program",
 CellID->813155701]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7190, 250, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7509, 261, 450, 13, 70, "SeeAlso",
 CellID->1429149499]
}, Open  ]],
Cell[CellGroupData[{
Cell[7996, 279, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[8317, 290, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[8651, 301, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[8981, 312, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[9344, 326, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[9665, 337, 429, 11, 70, "MoreAbout"],
Cell[10097, 350, 286, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[10398, 361, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

