(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18498,        597]
NotebookOptionsPosition[     15066,        489]
NotebookOutlinePosition[     16577,        529]
CellTagsIndexPosition[     16492,        524]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Expressions in External Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"], 
          "Handling Lists, Arrays and Other Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/HandlingListsArraysAndOtherExpressions"], 
          "Portability of MathLink Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PortabilityOfMathLinkPrograms"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Expressions in External Programs\"\>", 
       2->"\<\"Handling Lists, Arrays and Other Expressions\"\>", 
       3->"\<\"Portability of MathLink Programs\"\>", 
       4->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       5->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       6->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLReleaseByteString()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLReleaseByteString"], 
          "MLGetString()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetString"], 
          "MLGetUCS2String()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetUCS2String"], 
          "MLGetUTF8String()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetUTF8String"], 
          "MLGetUTF16String()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetUTF16String"], 
          "MLGetUTF32String()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetUTF32String"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"MLReleaseByteString()\"\>", 
       2->"\<\"MLGetString()\"\>", 3->"\<\"MLGetUCS2String()\"\>", 
       4->"\<\"MLGetUTF8String()\"\>", 5->"\<\"MLGetUTF16String()\"\>", 
       6->"\<\"MLGetUTF32String()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "MathLink C Functions for Exchanging Strings" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingStrings"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"MathLink C Functions for Exchanging Strings\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLGetByteString()", "ObjectNameAlt",
 CellID->16085],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLGetByteString", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["link", "TI"]}], ",", 
         RowBox[{"const", " ", "unsigned", " ", 
          RowBox[{"char", " ", "**", 
           StyleBox["s", "TI"]}]}], ",", 
         RowBox[{"int", " ", "*", 
          StyleBox["n", "TI"]}], ",", 
         RowBox[{"long", " ", 
          StyleBox["spec", "TI"]}]}], ")"}]}]], "InlineCode"],
     "\[LineSeparator]gets a string of characters from the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection specified by ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     ", storing the codes for the characters in ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " and the number of characters in ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". The code ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"],
     " is used for any character whose ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " character code is larger than 255. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2420]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["MLGetByteString()", "InlineCode"],
 " allocates memory for the array of character codes. You must call ",
 StyleBox[ButtonBox["MLReleaseByteString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseByteString"], "InlineCode"],
 " to disown this memory.",
 " ",
 "If ",
 StyleBox["MLGetByteString()", "InlineCode"],
 " fails and the function's return value indicates an error, do not call ",
 StyleBox["MLReleaseByteString()", "InlineCode"],
 " on the value contained in ",
 StyleBox["s", "TI"],
 "."
}], "Notes",
 CellID->9431],

Cell[TextData[{
 StyleBox["MLGetByteString()", "InlineCode"],
 " is convenient in situations where no special characters occur. "
}], "Notes",
 CellID->31516],

Cell[TextData[{
 "The character codes used by ",
 StyleBox["MLGetByteString()", "InlineCode"],
 " are exactly the ones returned by ",
 StyleBox[ButtonBox["ToCharacterCode",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToCharacterCode"], "InlineFormula"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Notes",
 CellID->28786],

Cell[TextData[{
 "The array of character codes in ",
 StyleBox["MLGetByteString()", "InlineCode"],
 " is not terminated by a null character. "
}], "Notes",
 CellID->5034],

Cell[TextData[{
 "Characters such as newlines are specified by their raw character codes, not \
by ASCII forms such as ",
 StyleBox["\[Backslash]n", "InlineCode"],
 ". "
}], "Notes",
 CellID->7491],

Cell[TextData[{
 StyleBox["MLGetByteString()", "InlineCode"],
 " returns immutable data."
}], "Notes",
 CellID->877534309],

Cell[TextData[{
 StyleBox["MLGetByteString()", "InlineCode"],
 " returns 0 in the event of an error, and a nonzero value if the function \
succeeds."
}], "Notes",
 CellID->641539503],

Cell[TextData[{
 "Use ",
 StyleBox[ButtonBox["MLError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLError"], "InlineCode"],
 " to retrieve the error code if ",
 StyleBox["MLGetByteString()", "InlineCode"],
 " fails."
}], "Notes",
 CellID->1986518981],

Cell[TextData[{
 StyleBox["MLGetByteString()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->53871089],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->47121799],

Cell["\<\
#include \"mathlink.h\"

/* read a string encoded with codes from ToCharacterCode[] from a link */

void f(MLINK lp)
{
\tconst unsigned char *string;
\tint length;

\tif(! MLGetByteString(lp, &string, &length, 0))
\t\t{
\t\t\t/* unable to read the byte string from lp */
\t\t\treturn;
\t\t}

\t/* ... */

\tMLReleaseByteString(lp, string, length);
}\
\>", "Program",
 CellID->1298158537]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31092],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLReleaseByteString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseByteString"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetString"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetUCS2String()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUCS2String"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetUTF8String()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUTF8String"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetUTF16String()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUTF16String"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetUTF32String()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUTF32String"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->2045892490]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28647],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], "Tutorials",
 CellID->26930],

Cell[TextData[ButtonBox["Handling Lists, Arrays and Other Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/HandlingListsArraysAndOtherExpressions"]], "Tutorials",
 CellID->106700868],

Cell[TextData[{
 ButtonBox["Portability of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"]
}], "Tutorials",
 CellID->65592066],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->165924676],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingStrings"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Strings",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingStrings"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLGetByteString() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 46, 26.4128196}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLGetByteString()int MLGetByteString(MLINK link,const unsigned char \
**s,int *n,long spec) gets a string of characters from the MathLink \
connection specified by link, storing the codes for the characters in s and \
the number of characters in n. The code spec is used for any character whose \
Mathematica character code is larger than 255. ", 
    "synonyms" -> {"get byte string"}, "title" -> "MLGetByteString", "type" -> 
    "MathLink C Function", "uri" -> "ref/c/MLGetByteString"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8988, 274, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->53871089]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16350, 517}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3957, 86, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4580, 113, 58, 1, 70, "ObjectNameAlt",
 CellID->16085],
Cell[4641, 116, 1466, 43, 70, "Usage",
 CellID->2420]
}, Open  ]],
Cell[CellGroupData[{
Cell[6144, 164, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6622, 181, 565, 16, 70, "Notes",
 CellID->9431],
Cell[7190, 199, 158, 4, 70, "Notes",
 CellID->31516],
Cell[7351, 205, 349, 12, 70, "Notes",
 CellID->28786],
Cell[7703, 219, 170, 5, 70, "Notes",
 CellID->5034],
Cell[7876, 226, 197, 6, 70, "Notes",
 CellID->7491],
Cell[8076, 234, 122, 4, 70, "Notes",
 CellID->877534309],
Cell[8201, 240, 182, 5, 70, "Notes",
 CellID->641539503],
Cell[8386, 247, 259, 9, 70, "Notes",
 CellID->1986518981],
Cell[8648, 258, 303, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[8988, 274, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->53871089],
Cell[CellGroupData[{
Cell[9372, 288, 147, 5, 70, "ExampleSection",
 CellID->47121799],
Cell[9522, 295, 397, 21, 70, "Program",
 CellID->1298158537]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9968, 322, 311, 9, 70, "SeeAlsoSection",
 CellID->31092],
Cell[10282, 333, 1464, 41, 70, "SeeAlso",
 CellID->2045892490]
}, Open  ]],
Cell[CellGroupData[{
Cell[11783, 379, 314, 9, 70, "TutorialsSection",
 CellID->28647],
Cell[12100, 390, 200, 4, 70, "Tutorials",
 CellID->26930],
Cell[12303, 396, 200, 4, 70, "Tutorials",
 CellID->106700868],
Cell[12506, 402, 415, 12, 70, "Tutorials",
 CellID->65592066],
Cell[12924, 416, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[13258, 427, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[13588, 438, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[13951, 452, 319, 9, 70, "MoreAboutSection",
 CellID->165924676],
Cell[14273, 463, 429, 11, 70, "MoreAbout"],
Cell[14705, 476, 319, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[15039, 487, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

