(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17131,        567]
NotebookOptionsPosition[     13908,        466]
NotebookOutlinePosition[     15309,        504]
CellTagsIndexPosition[     15224,        499]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Expressions in External Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"], 
          "Handling Lists, Arrays and Other Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/HandlingListsArraysAndOtherExpressions"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Expressions in External Programs\"\>", 
       2->"\<\"Handling Lists, Arrays and Other Expressions\"\>", 
       3->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       4->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       5->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLGetNext()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetNext"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MLGetNext()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "Installable MathLink Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/InstallableMathLinkPrograms"], 
          "MathLink C Functions for Exchanging Data" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingData"], 
          "MathLink C Functions for Exchanging Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingExpressions"], 
          "MathLink C Language Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCLanguageFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"Installable MathLink Programs\"\>", 
       3->"\<\"MathLink C Functions for Exchanging Data\"\>", 
       4->"\<\"MathLink C Functions for Exchanging Expressions\"\>", 
       5->"\<\"MathLink C Language Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLGetFunction()", "ObjectNameAlt",
 CellID->31306],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLGetFunction", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["link", "TI"]}], ",", 
         RowBox[{"const", " ", 
          RowBox[{"char", " ", "**", 
           StyleBox["s", "TI"]}]}], ",", 
         RowBox[{"int", " ", "*", 
          StyleBox["n", "TI"]}]}], ")"}]}]], "InlineCode"],
     "\[LineSeparator]gets a function with a symbol as a head from the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection specified by ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     ", storing the name of the symbol in ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " and the number of arguments of the function in ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18847]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["MLGetFunction()", "InlineCode"],
 " allocates memory for the character string corresponding to the name of the \
head of the function. You must call ",
 StyleBox[ButtonBox["MLReleaseSymbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseSymbol"], "InlineCode"],
 " to disown this memory.",
 " ",
 "If ",
 StyleBox["MLGetFunction()", "InlineCode"],
 " fails and the function's return value indicates an error, do not call ",
 StyleBox["MLReleaseSymbol()", "InlineCode"],
 " on the contents of ",
 StyleBox["s", "TI"],
 "."
}], "Notes",
 CellID->4806],

Cell[TextData[{
 "External programs should not modify the character string ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21452],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"MLGetFunction", 
   RowBox[{"(", 
    RowBox[{
     StyleBox["link", "TI"], ",", 
     RowBox[{"&", 
      StyleBox["s", "TI"]}], ",", 
     RowBox[{"&", 
      StyleBox["n", "TI"]}]}], ")"}]}]], "InlineCode"],
 " has the same effect as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["MLGetNext",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/c/MLGetNext"], 
    RowBox[{"(", 
     StyleBox["link", "TI"], ")"}]}], ";", 
   RowBox[{
    ButtonBox["MLGetArgCount",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/c/MLGetArgCount"], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["link", "TI"], ",", 
      RowBox[{"&", 
       StyleBox["n", "TI"]}]}], ")"}]}], ";", 
   RowBox[{
    ButtonBox["MLGetSymbol",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/c/MLGetSymbol"], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["link", "TI"], ",", 
      RowBox[{"&", 
       StyleBox["s", "TI"]}]}], ")"}]}]}]], "InlineCode"],
 ". "
}], "Notes",
 CellID->13696],

Cell[TextData[{
 StyleBox["MLGetFunction()", "InlineCode"],
 " returns 0 in the event of an error, and a nonzero value if the function \
succeeds."
}], "Notes",
 CellID->1093240310],

Cell[TextData[{
 "Use ",
 StyleBox[ButtonBox["MLError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLError"], "InlineCode"],
 " to retrieve the error code if ",
 StyleBox["MLGetFunction()", "InlineCode"],
 " fails."
}], "Notes",
 CellID->665835627],

Cell[TextData[{
 StyleBox["MLGetFunction()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->400595703],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->165590366],

Cell["\<\
#include \"mathlink.h\"

/* read a Mathematica function from a link */

void f(MLINK lp)
{\[LineSeparator]\tconst char *f;
\tint n;

\tif(! MLGetFunction(lp, &f, &n))
\t\t{
\t\t\t/* unable to read the function from lp */
\t\t\treturn;
\t\t}

\t/* ... */

\tMLReleaseSymbol(lp, f);
}\
\>", "Program",
 CellID->1247493947]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26535],

Cell[TextData[Cell[TextData[StyleBox[ButtonBox["MLGetNext()",
 BaseStyle->"Link",
 ButtonData->"paclet:ref/c/MLGetNext"],
 FontFamily->"Verdana"]], "InlineCode"]], "SeeAlso",
 CellID->177916432]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29571],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], "Tutorials",
 CellID->26930],

Cell[TextData[ButtonBox["Handling Lists, Arrays and Other Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/HandlingListsArraysAndOtherExpressions"]], "Tutorials",
 CellID->106700868],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->2259018],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 ButtonBox["Installable ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Data",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Language Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLGetFunction() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 46, 27.3972198}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLGetFunction()int MLGetFunction(MLINK link,const char **s,int *n) gets \
a function with a symbol as a head from the MathLink connection specified by \
link, storing the name of the symbol in s and the number of arguments of the \
function in n. ", "synonyms" -> {"get function"}, "title" -> "MLGetFunction", 
    "type" -> "MathLink C Function", "uri" -> "ref/c/MLGetFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8595, 270, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->400595703]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15081, 492}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3652, 81, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4275, 108, 56, 1, 70, "ObjectNameAlt",
 CellID->31306],
Cell[4334, 111, 1175, 35, 70, "Usage",
 CellID->18847]
}, Open  ]],
Cell[CellGroupData[{
Cell[5546, 151, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6024, 168, 590, 17, 70, "Notes",
 CellID->4806],
Cell[6617, 187, 169, 6, 70, "Notes",
 CellID->21452],
Cell[6789, 195, 1022, 39, 70, "Notes",
 CellID->13696],
Cell[7814, 236, 181, 5, 70, "Notes",
 CellID->1093240310],
Cell[7998, 243, 256, 9, 70, "Notes",
 CellID->665835627],
Cell[8257, 254, 301, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[8595, 270, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->400595703],
Cell[CellGroupData[{
Cell[8980, 284, 148, 5, 70, "ExampleSection",
 CellID->165590366],
Cell[9131, 291, 330, 20, 70, "Program",
 CellID->1247493947]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9510, 317, 311, 9, 70, "SeeAlsoSection",
 CellID->26535],
Cell[9824, 328, 194, 4, 70, "SeeAlso",
 CellID->177916432]
}, Open  ]],
Cell[CellGroupData[{
Cell[10055, 337, 314, 9, 70, "TutorialsSection",
 CellID->29571],
Cell[10372, 348, 200, 4, 70, "Tutorials",
 CellID->26930],
Cell[10575, 354, 200, 4, 70, "Tutorials",
 CellID->106700868],
Cell[10778, 360, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[11112, 371, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[11442, 382, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[11805, 396, 317, 9, 70, "MoreAboutSection",
 CellID->2259018],
Cell[12125, 407, 429, 11, 70, "MoreAbout"],
Cell[12557, 420, 378, 11, 70, "MoreAbout"],
Cell[12938, 433, 310, 8, 70, "MoreAbout"],
Cell[13251, 443, 331, 8, 70, "MoreAbout"],
Cell[13585, 453, 281, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[13881, 464, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

