(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14028,        479]
NotebookOptionsPosition[     11058,        385]
NotebookOutlinePosition[     12437,        423]
CellTagsIndexPosition[     12352,        418]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       2->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLSetEnvIDString()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLSetEnvIDString"], 
          "MLReleaseEnvIDString()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLReleaseEnvIDString"], 
          "MLActivate()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLActivate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLSetEnvIDString()\"\>", 
       2->"\<\"MLReleaseEnvIDString()\"\>", 
       3->"\<\"MLActivate()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLGetLinkedEnvIDString()", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLGetLinkedEnvIDString", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["link", "TI"]}], ",", 
         RowBox[{"const", " ", 
          RowBox[{"char", " ", "**", 
           StyleBox["e", "TI"]}]}]}], ")"}]}]], "InlineCode"],
     " \[LineSeparator]returns the identification string of the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " environment connected to ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     " and stores it in ",
     Cell[BoxData[
      StyleBox["e", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["MLGetLinkedEnvIDString()", "InlineCode"],
 " allocates the memory for the string ",
 Cell[BoxData[
  StyleBox["eid", "TI"]], "InlineFormula"],
 ". You must call ",
 StyleBox[ButtonBox["MLReleaseEnvIDString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseEnvIDString"], "InlineCode"],
 " to disown this memory.",
 " ",
 "If ",
 StyleBox["MLGetLinkedEnvIDString()", "InlineCode"],
 " fails and the function's return value indicates an error, do not call ",
 StyleBox["MLReleaseEnvIDString()", "InlineCode"],
 " on the contents of ",
 StyleBox["e", "TI"],
 "."
}], "Notes",
 CellID->198722466],

Cell[TextData[{
 StyleBox["MLGetLinkedEnvIDString()", "InlineCode"],
 " returns an immutable string."
}], "Notes",
 CellID->1007946451],

Cell[TextData[{
 "The environment identification returned by ",
 StyleBox["MLGetLinkedEnvIDString()", "InlineCode"],
 " is a null-terminated ASCII string."
}], "Notes",
 CellID->313889670],

Cell[TextData[{
 StyleBox["MLGetLinkedEnvIDString()", "InlineCode"],
 " will not work until ",
 Cell[BoxData[
  StyleBox["link", "TI"]], "InlineFormula"],
 " is connected."
}], "Notes",
 CellID->530542633],

Cell[TextData[{
 StyleBox["MLGetLinkedEnvIDString()", "InlineCode"],
 " returns 0 in the event of an error, and a nonzero value if the function \
succeeds."
}], "Notes",
 CellID->1357200123],

Cell[TextData[{
 "Use ",
 StyleBox[ButtonBox["MLError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLError"], "InlineCode"],
 " to retrieve the error code if ",
 StyleBox["MLGetLinkedEnvIDString()", "InlineCode"],
 " fails."
}], "Notes",
 CellID->1193788257],

Cell[TextData[{
 StyleBox["MLGetLinkedEnvIDString()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->190593992],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->167918378],

Cell["\<\
#include <string.h>
#include \"mathlink.h\"

/* read the id from a link and check for \"My Remote Program\" */

#define ERROR -1

int f(MLINK lp)
{
\tint isCorrectProg;
\tconst char *e;

\tif(! MLGetLinkedEnvIDString(lp, &e))
\t\t{
\t\t\t/* unable to read the link id from lp */
\t\t\treturn ERROR;
\t\t}

\tisCorrectProg = strcmp(envid, \"My Remote Program\") == 0;

\tMLReleaseEnvIDString(lp, e, length);

\treturn isCorrectProg;
}\
\>", "Program",
 CellID->988855229]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLSetEnvIDString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLSetEnvIDString"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLReleaseEnvIDString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseEnvIDString"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLActivate()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLActivate"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->132154713]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLGetLinkedEnvIDString() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 46, 35.9599390}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLGetLinkedEnvIDString()int MLGetLinkedEnvIDString(MLINK link,const char \
**e) returns the identification string of the MathLink environment connected \
to link and stores it in e.", "synonyms" -> {"get linked env ID string"}, 
    "title" -> "MLGetLinkedEnvIDString", "type" -> "MathLink C Function", 
    "uri" -> "ref/c/MLGetLinkedEnvIDString"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6802, 223, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->190593992]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12209, 411}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2644, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3267, 91, 70, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[3340, 94, 967, 30, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4344, 129, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4822, 146, 631, 19, 70, "Notes",
 CellID->198722466],
Cell[5456, 167, 135, 4, 70, "Notes",
 CellID->1007946451],
Cell[5594, 173, 188, 5, 70, "Notes",
 CellID->313889670],
Cell[5785, 180, 205, 7, 70, "Notes",
 CellID->530542633],
Cell[5993, 189, 190, 5, 70, "Notes",
 CellID->1357200123],
Cell[6186, 196, 266, 9, 70, "Notes",
 CellID->1193788257],
Cell[6455, 207, 310, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[6802, 223, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->190593992],
Cell[CellGroupData[{
Cell[7187, 237, 148, 5, 70, "ExampleSection",
 CellID->167918378],
Cell[7338, 244, 480, 26, 70, "Program",
 CellID->988855229]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7867, 276, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[8186, 287, 714, 20, 70, "SeeAlso",
 CellID->132154713]
}, Open  ]],
Cell[CellGroupData[{
Cell[8937, 312, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[9258, 323, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[9592, 334, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[9922, 345, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[10285, 359, 299, 8, 70, "MoreAboutSection"],
Cell[10587, 369, 429, 11, 70, "MoreAbout"]
}, Open  ]],
Cell[11031, 383, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

