(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16986,        542]
NotebookOptionsPosition[     13892,        444]
NotebookOutlinePosition[     15254,        482]
CellTagsIndexPosition[     15169,        477]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       2->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLPutMessage()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutMessage"], 
          "MLPutMessageWithArg()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutMessageWithArg"], 
          "MLMessageReady()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLMessageReady"], 
          "MLSetMessageHandler()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLSetMessageHandler"], 
          "MLMessageHandlerObject()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLMessageHandlerObject"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"MLPutMessage()\"\>", 
       2->"\<\"MLPutMessageWithArg()\"\>", 3->"\<\"MLMessageReady()\"\>", 
       4->"\<\"MLSetMessageHandler()\"\>", 
       5->"\<\"MLMessageHandlerObject()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "Low-Level MathLink Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelMathLinkOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"Low-Level MathLink Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLGetMessage()", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLGetMessage", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["link", "TI"]}], ",", 
         RowBox[{"int", "*", " ", 
          StyleBox["code", "TI"]}], ",", 
         RowBox[{"int", "*", 
          StyleBox["param", "TI"]}]}], ")"}]}]], "InlineCode"],
     " \[LineSeparator]reads an out-of-band message code from the urgent \
message channel associated with ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     " and stores the code in ",
     Cell[BoxData[
      StyleBox["code", "TI"]], "InlineFormula"],
     " and any parameter in ",
     Cell[BoxData[
      StyleBox["param", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["MLGetMessage()", "InlineCode"],
 " returns a nonzero value if it reads an out-of-band message and 0 \
otherwise."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 StyleBox["MLGetMessage()", "InlineCode"],
 " is a nonblocking function."
}], "Notes",
 CellID->1984395325],

Cell[TextData[{
 StyleBox["MLGetMessage()", "InlineCode"],
 " can return the following messages:"
}], "Notes",
 CellID->1853697729],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["MLTerminateMessage", "InlineCode"], Cell[
    "shut down the current program", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["MLInterruptMessage", "InlineCode"], Cell[
    "interrupt the current operation", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["MLAbortMessage", "InlineCode"], Cell[
    "abort the current operation", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["MLEndPacketMessage", "InlineCode"], Cell[
    "obsolete message", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLSynchronizeMessage", Cell["\<\
synchronize the internal expression streams for both sides of the link\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLImDyingMessage", Cell[
    "other side of the link is shutting down", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLWaitingAcknowledgement", Cell[
    "other side of the link needs a response", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLMarkTopLevelMessage", Cell[TextData[{
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " library internal message"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLLinkClosingMessage", Cell[TextData[{
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " library internal message"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLAuthenticationFailure", Cell[
    "failure to authenticate message", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLFirstUserMessage", Cell[
    "beginning of user-defined message space", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MLLastUserMessage", Cell[
    "end of user-defined message space", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, {None}},
    "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->1570442537],

Cell[TextData[{
 StyleBox["MLFirstUserMessage", "InlineCode"],
 " should be used as the starting value for any user-defined messages",
 ". ",
 "You could define a new message as ",
 StyleBox["#define MyAppMessage MLFirstUserMessage + 1", "InlineCode"],
 "."
}], "Notes",
 CellID->1552464274],

Cell[TextData[{
 "User-defined messages should not have values larger than ",
 StyleBox["MLLastUserMessage", "InlineCode"],
 "."
}], "Notes",
 CellID->164372524],

Cell[TextData[{
 "Standard ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " messages do not have any parameters."
}], "Notes",
 CellID->1829955688],

Cell[TextData[{
 StyleBox["MLGetMessage()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1657599],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->173415779],

Cell["\<\
#include \"mathlink.h\"

/* read an out-of-band message code from a link */

void f(MLINK lp)
{
\tint code, param;

\tif(MLMessageReady(lp))
\t{
\t\tif(! MLGetMessage(lp, &code, &param))
\t\t\t{ /* unable to read the message code from lp */ }
\t}
}\
\>", "Program",
 CellID->453873974]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLPutMessage()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutMessage"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLPutMessageWithArg()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutMessageWithArg"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLMessageReady()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLMessageReady"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLSetMessageHandler()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLSetMessageHandler"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLMessageHandlerObject()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLMessageHandlerObject"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->626170393]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 ButtonBox["Low-Level ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"],
  FontSlant->"Italic"],
 ButtonBox[" Operations",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLGetMessage() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 46, 42.5851086}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLGetMessage()int MLGetMessage(MLINK link,int* code,int*param) reads an \
out-of-band message code from the urgent message channel associated with link \
and stores the code in code and any parameter in param.", 
    "synonyms" -> {"get message"}, "title" -> "MLGetMessage", "type" -> 
    "MathLink C Function", "uri" -> "ref/c/MLGetMessage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8908, 264, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1657599]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15028, 470}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3131, 71, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3754, 98, 60, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[3817, 101, 1058, 32, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4912, 138, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5390, 155, 174, 5, 70, "Notes",
 CellID->1067943069],
Cell[5567, 162, 123, 4, 70, "Notes",
 CellID->1984395325],
Cell[5693, 168, 131, 4, 70, "Notes",
 CellID->1853697729],
Cell[5827, 174, 2130, 47, 70, "2ColumnTableMod",
 CellID->1570442537],
Cell[7960, 223, 291, 8, 70, "Notes",
 CellID->1552464274],
Cell[8254, 233, 161, 5, 70, "Notes",
 CellID->164372524],
Cell[8418, 240, 150, 6, 70, "Notes",
 CellID->1829955688],
Cell[8571, 248, 300, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[8908, 264, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1657599],
Cell[CellGroupData[{
Cell[9291, 278, 148, 5, 70, "ExampleSection",
 CellID->173415779],
Cell[9442, 285, 295, 16, 70, "Program",
 CellID->453873974]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9786, 307, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[10105, 318, 1232, 34, 70, "SeeAlso",
 CellID->626170393]
}, Open  ]],
Cell[CellGroupData[{
Cell[11374, 357, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[11695, 368, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[12029, 379, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[12359, 390, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[12722, 404, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[13043, 415, 429, 11, 70, "MoreAbout"],
Cell[13475, 428, 375, 11, 70, "MoreAbout"]
}, Open  ]],
Cell[13865, 442, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

