(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14020,        471]
NotebookOptionsPosition[     11203,        381]
NotebookOutlinePosition[     12540,        419]
CellTagsIndexPosition[     12455,        414]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       2->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLSetMessageHandler()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLSetMessageHandler"], 
          "MLPutMessage()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutMessage"], 
          "MLGetMessage()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetMessage"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLSetMessageHandler()\"\>", 
       2->"\<\"MLPutMessage()\"\>", 
       3->"\<\"MLGetMessage()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "Low-Level MathLink Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelMathLinkOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"Low-Level MathLink Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLGetMessageHandler()", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MLMessageHandlerObject",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/c/MLMessageHandlerObject"], " ", 
       "MLGetMessageHandler", 
       RowBox[{"(", 
        RowBox[{
         ButtonBox["MLINK",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/c/MLINK"], " ", 
         StyleBox["link", "TI"]}], ")"}]}]], "InlineCode"],
     " \[LineSeparator]returns the message handler function installed for the \
",
     StyleBox["MLINK", "InlineCode"],
     " object ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The urgent message handler function is called when ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " receives an urgent message from the other end of the connection."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 StyleBox["MLGetMessageHandler()", "InlineCode"],
 " returns ",
 StyleBox["(", "InlineCode"],
 StyleBox[ButtonBox["MLMessageHandlerObject",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLMessageHandlerObject"], "InlineCode"],
 StyleBox[")0", "InlineCode"],
 " if ",
 Cell[BoxData[
  StyleBox["link", "TI"]], "InlineFormula"],
 " does not have an installed message handler function."
}], "Notes",
 CellID->1978460016],

Cell[TextData[{
 StyleBox[ButtonBox["MLMessageHandlerObject",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLMessageHandlerObject"], "InlineCode"],
 " is a pointer to a function of the form ",
 Cell[BoxData[
  RowBox[{"void", " ", "f", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      ButtonBox["MLINK",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/c/MLINK"], " ", "link"}], ",", 
     RowBox[{"int", " ", "m1"}], ",", 
     RowBox[{"int", " ", "m2"}]}], ")"}]}]], "InlineCode"],
 "."
}], "Notes",
 CellID->1536022905],

Cell[TextData[{
 StyleBox["MLGetMessageHandler()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->544715468],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->6073767],

Cell["\<\
#include \"mathlink.h\"

/* a function to read MathLink urgent messages */

void AppMessageHandler(MLINK link, int m1, int m2)
{
\t/* ... */
}


/* check that a link uses AppMessageHandler for urgent messages */

void check_the_message_handler(MLINK link)
{
\tMLMessageHandlerObject handler;

\thandler = MLGetMessageHandler(link);
\tif(handler != (MLMessageHandlerObject)AppMessageHandler)
\t{
\t\tif(! MLSetMessageHandler(link, \
(MLMessageHandlerObject)AppMessageHandler))
\t\t\t{ /* unable to set AppMessageHandler as the handler for
\t\t\t     link */ }
\t}
}\
\>", "Program",
 CellID->487444582]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLSetMessageHandler()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLSetMessageHandler"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLPutMessage()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutMessage"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetMessage()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetMessage"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->1375924851]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 ButtonBox["Low-Level ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"],
  FontSlant->"Italic"],
 ButtonBox[" Operations",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLGetMessageHandler() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 46, 42.3819784}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLGetMessageHandler()MLMessageHandlerObject MLGetMessageHandler(MLINK \
link) returns the message handler function installed for the MLINK object \
link.", "synonyms" -> {"get message handler"}, "title" -> 
    "MLGetMessageHandler", "type" -> "MathLink C Function", "uri" -> 
    "ref/c/MLGetMessageHandler"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6426, 204, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->544715468]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12312, 407}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2823, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3446, 94, 67, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[3516, 97, 850, 27, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4403, 129, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4881, 146, 220, 6, 70, "Notes",
 CellID->1067943069],
Cell[5104, 154, 436, 13, 70, "Notes",
 CellID->1978460016],
Cell[5543, 169, 536, 17, 70, "Notes",
 CellID->1536022905],
Cell[6082, 188, 307, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[6426, 204, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->544715468],
Cell[CellGroupData[{
Cell[6811, 218, 146, 5, 70, "ExampleSection",
 CellID->6073767],
Cell[6960, 225, 611, 27, 70, "Program",
 CellID->487444582]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7620, 258, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7939, 269, 709, 20, 70, "SeeAlso",
 CellID->1375924851]
}, Open  ]],
Cell[CellGroupData[{
Cell[8685, 294, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[9006, 305, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[9340, 316, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[9670, 327, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[10033, 341, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[10354, 352, 429, 11, 70, "MoreAbout"],
Cell[10786, 365, 375, 11, 70, "MoreAbout"]
}, Open  ]],
Cell[11176, 379, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

