(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16961,        547]
NotebookOptionsPosition[     13751,        446]
NotebookOutlinePosition[     15155,        485]
CellTagsIndexPosition[     15070,        480]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Expressions in External Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"], 
          "Handling Lists, Arrays and Other Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/HandlingListsArraysAndOtherExpressions"], 
          "Portability of MathLink Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PortabilityOfMathLinkPrograms"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Expressions in External Programs\"\>", 
       2->"\<\"Handling Lists, Arrays and Other Expressions\"\>", 
       3->"\<\"Portability of MathLink Programs\"\>", 
       4->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       5->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       6->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLReleaseReal64List()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLReleaseReal64List"], 
          "MLGetReal32List()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetReal32List"], 
          "MLGetReal128List()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetReal128List"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"MLReleaseReal64List()\"\>", 
       2->"\<\"MLGetReal32List()\"\>", 
       3->"\<\"MLGetReal128List()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "MathLink C Functions for Exchanging Data" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingData"], 
          "MathLink C Functions for Exchanging Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingLists"], 
          "MathLink C Functions for Exchanging Reals" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingReals"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"MathLink C Functions for Exchanging Data\"\>", 
       3->"\<\"MathLink C Functions for Exchanging Lists\"\>", 
       4->"\<\"MathLink C Functions for Exchanging Reals\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLGetReal64List()", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLGetReal64List", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["link", "TI"]}], ",", 
         RowBox[{"double", " ", "**", 
          StyleBox["a", "TI"]}], ",", 
         RowBox[{"int", " ", "*", 
          StyleBox["n", "TI"]}]}], ")"}]}]], "InlineCode"],
     " \[LineSeparator]gets a list of double-precision floating-point numbers \
from the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection specified by ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     ", storing the numbers in array ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and the length of the list in ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["MLGetReal64List()", "InlineCode"],
 " allocates memory for the array of numbers. You must call ",
 StyleBox[ButtonBox["MLReleaseReal64List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseReal64List"], "InlineCode"],
 " to disown this memory.",
 " ",
 "If ",
 StyleBox["MLGetReal64List()", "InlineCode"],
 " fails and the function's return value indicates an error, do not call ",
 StyleBox["MLReleaseReal64List()", "InlineCode"],
 " on the contents of ",
 StyleBox["a", "TI"],
 "."
}], "Notes",
 CellID->27725],

Cell[TextData[{
 StyleBox["MLGetReal64List()", "InlineCode"],
 " returns immutable data."
}], "Notes",
 CellID->945040826],

Cell[TextData[{
 StyleBox["MLGetReal64List()", "InlineCode"],
 " returns 0 in the event of an error, and a nonzero value if the function \
succeeds."
}], "Notes",
 CellID->1093240310],

Cell[TextData[{
 "Use ",
 StyleBox[ButtonBox["MLError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLError"], "InlineCode"],
 " to retrieve the error code if ",
 StyleBox["MLGetReal64List()", "InlineCode"],
 " fails."
}], "Notes",
 CellID->860602369],

Cell[TextData[{
 StyleBox["MLGetReal64List()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->85799026],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->69403254],

Cell["\<\
#include \"mathlink.h\"

/* read a list of double-precision floating-point numbers from a link */

void f(MLINK lp)
{
\tdouble *list;
\tint length;

\tif(! MLGetReal64List(lp, &list, &length))
\t\t{
\t\t\t/* unable to read the list of numbers from lp */
\t\t\treturn;
\t\t}

\t/* ... */

\tMLReleaseReal64List(lp, list, length);
}\
\>", "Program",
 CellID->725757467]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLReleaseReal64List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseReal64List"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetReal32List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetReal32List"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLGetReal128List()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetReal128List"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->872305580]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], "Tutorials",
 CellID->26930],

Cell[TextData[ButtonBox["Handling Lists, Arrays and Other Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/HandlingListsArraysAndOtherExpressions"]], "Tutorials",
 CellID->106700868],

Cell[TextData[{
 ButtonBox["Portability of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"]
}], "Tutorials",
 CellID->65592066],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Data",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingLists"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Lists",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingLists"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingReals"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Reals",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingReals"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLGetReal64List() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 46, 50.4446848}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLGetReal64List()int MLGetReal64List(MLINK link,double **a,int *n) gets \
a list of double-precision floating-point numbers from the MathLink \
connection specified by link, storing the numbers in array a and the length \
of the list in n.", "synonyms" -> {"get real list"}, "title" -> 
    "MLGetReal64List", "type" -> "MathLink C Function", "uri" -> 
    "ref/c/MLGetReal64List"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7804, 232, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->85799026]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14928, 473}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3992, 87, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4615, 114, 63, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[4681, 117, 1142, 35, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5860, 157, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6338, 174, 551, 16, 70, "Notes",
 CellID->27725],
Cell[6892, 192, 122, 4, 70, "Notes",
 CellID->945040826],
Cell[7017, 198, 183, 5, 70, "Notes",
 CellID->1093240310],
Cell[7203, 205, 258, 9, 70, "Notes",
 CellID->860602369],
Cell[7464, 216, 303, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[7804, 232, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->85799026],
Cell[CellGroupData[{
Cell[8188, 246, 147, 5, 70, "ExampleSection",
 CellID->69403254],
Cell[8338, 253, 377, 21, 70, "Program",
 CellID->725757467]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8764, 280, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[9083, 291, 722, 20, 70, "SeeAlso",
 CellID->872305580]
}, Open  ]],
Cell[CellGroupData[{
Cell[9842, 316, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[10163, 327, 200, 4, 70, "Tutorials",
 CellID->26930],
Cell[10366, 333, 200, 4, 70, "Tutorials",
 CellID->106700868],
Cell[10569, 339, 415, 12, 70, "Tutorials",
 CellID->65592066],
Cell[10987, 353, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[11321, 364, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[11651, 375, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[12014, 389, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[12335, 400, 429, 11, 70, "MoreAbout"],
Cell[12767, 413, 310, 8, 70, "MoreAbout"],
Cell[13080, 423, 313, 8, 70, "MoreAbout"],
Cell[13396, 433, 313, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[13724, 444, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

