(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13479,        460]
NotebookOptionsPosition[     10539,        367]
NotebookOutlinePosition[     11956,        406]
CellTagsIndexPosition[     11871,        401]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Handling Lists, Arrays and Other Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/HandlingListsArraysAndOtherExpressions"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Handling Lists, Arrays and Other Expressions\"\>", 
       2->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       4->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "MathLink C Functions for Exchanging Data" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingData"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"MathLink C Functions for Exchanging Data\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLGetRealArray()", "ObjectNameAlt",
 CellID->13188],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLGetRealArray", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["link", "TI"]}], ",", 
         RowBox[{"double", " ", "**", 
          StyleBox["a", "TI"]}], ",", 
         RowBox[{"long", " ", "**", 
          StyleBox["dims", "TI"]}], ",", 
         RowBox[{
          RowBox[{"char", " ", "**"}], "*", 
          StyleBox["heads", "TI"]}], ",", 
         RowBox[{"long", " ", "*", 
          StyleBox["d", "TI"]}]}], ")"}]}]], "InlineCode"],
     "\[LineSeparator]gets an array of floating",
     "-",
     "point numbers from the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection specified by ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     ", storing the array in ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     ", its dimensions in ",
     Cell[BoxData[
      StyleBox["dims", "TI"]], "InlineFormula"],
     " and its depth in ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7716]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The array ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is laid out in memory like a C array declared as ",
 Cell[BoxData[
  RowBox[{"double", " ", 
   RowBox[{
    RowBox[{
     StyleBox["a", "TI"], "[", 
     StyleBox["m", "TI"], "]"}], "[", 
    StyleBox["n", "TI"], "]"}], 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineCode"],
 ". "
}], "Notes",
 CellID->25756],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["heads", "TI"]], "InlineFormula"],
 " gives a list of character strings corresponding to the names of symbols \
that appear as heads at each level in the array. "
}], "Notes",
 CellID->28],

Cell[TextData[{
 StyleBox["MLGetRealArray()", "InlineCode"],
 " allocates memory which must be released by calling ",
 StyleBox[ButtonBox["MLDisownRealArray()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLDisownRealArray"], "InlineCode"],
 ".",
 " ",
 "If ",
 StyleBox["MLGetRealArray()", "InlineCode"],
 " fails and the function's return value indicates an error, do not call ",
 StyleBox["MLReleaseRealArray()", "InlineCode"],
 " on the contents of ",
 StyleBox["a", "TI"],
 "."
}], "Notes",
 CellID->6929],

Cell[TextData[{
 StyleBox["MLGetRealArray()", "InlineCode"],
 " returns immutable data."
}], "Notes",
 CellID->1735149478],

Cell[TextData[{
 StyleBox["MLGetRealArray()", "InlineCode"],
 " returns 0 in the event of an error, and a nonzero value if the function \
succeeds."
}], "Notes",
 CellID->1093240310],

Cell[TextData[{
 "Use ",
 StyleBox[ButtonBox["MLError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLError"], "InlineCode"],
 " to retrieve the error code if ",
 StyleBox["MLGetRealArray()", "InlineCode"],
 " fails."
}], "Notes",
 CellID->1582649673],

Cell[TextData[{
 StyleBox["MLGetRealArray()", "InlineCode"],
 " is equivalent to ",
 StyleBox[ButtonBox["MLGetReal64Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetReal64Array"], "InlineCode"],
 "."
}], "Notes",
 CellID->1722889158]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->389171683],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->9273591],

Cell["\<\
#include \"mathlink.h\"

/* read an array of double-precision floating-point numbers from a link */

void f(MLINK lp)
{
\tdouble *data;
\tlong *dims;
\tchar **heads;
\tlong d; /* stores the rank of the array */

\tif(! MLGetRealArray(lp, &data, &dims, &heads, &d))
\t\t{
\t\t\t/* unable to read the array from lp */
\t\t\treturn;
\t\t}

\t/* ... */

\tMLDisownRealArray(lp, data, dims, heads, d);\t
}\
\>", "Program",
 CellID->1826857015]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23346],

Cell[TextData[ButtonBox["Handling Lists, Arrays and Other Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/HandlingListsArraysAndOtherExpressions"]], "Tutorials",
 CellID->106700868],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->313582276],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Data",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLGetRealArray() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 46, 50.8665706}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLGetRealArray()int MLGetRealArray(MLINK link,double **a,long \
**dims,char ***heads,long *d) gets an array of floating-point numbers from \
the MathLink connection specified by link, storing the array in a, its \
dimensions in dims and its depth in d. ", "synonyms" -> {"get real array"}, 
    "title" -> "MLGetRealArray", "type" -> "MathLink C Function", "uri" -> 
    "ref/c/MLGetRealArray"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6855, 227, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->389171683]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11728, 394}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2249, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2872, 78, 57, 1, 70, "ObjectNameAlt",
 CellID->13188],
Cell[2932, 81, 1399, 44, 70, "Usage",
 CellID->7716]
}, Open  ]],
Cell[CellGroupData[{
Cell[4368, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4846, 147, 399, 15, 70, "Notes",
 CellID->25756],
Cell[5248, 164, 230, 6, 70, "Notes",
 CellID->28],
Cell[5481, 172, 515, 16, 70, "Notes",
 CellID->6929],
Cell[5999, 190, 122, 4, 70, "Notes",
 CellID->1735149478],
Cell[6124, 196, 182, 5, 70, "Notes",
 CellID->1093240310],
Cell[6309, 203, 258, 9, 70, "Notes",
 CellID->1582649673],
Cell[6570, 214, 248, 8, 70, "Notes",
 CellID->1722889158]
}, Closed]],
Cell[CellGroupData[{
Cell[6855, 227, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->389171683],
Cell[CellGroupData[{
Cell[7240, 241, 146, 5, 70, "ExampleSection",
 CellID->9273591],
Cell[7389, 248, 448, 23, 70, "Program",
 CellID->1826857015]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7886, 277, 314, 9, 70, "TutorialsSection",
 CellID->23346],
Cell[8203, 288, 200, 4, 70, "Tutorials",
 CellID->106700868],
Cell[8406, 294, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[8740, 305, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[9070, 316, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[9433, 330, 319, 9, 70, "MoreAboutSection",
 CellID->313582276],
Cell[9755, 341, 429, 11, 70, "MoreAbout"],
Cell[10187, 354, 310, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[10512, 365, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

