(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16445,        584]
NotebookOptionsPosition[     12273,        443]
NotebookOutlinePosition[     13517,        480]
CellTagsIndexPosition[     13432,        475]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       2->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLOpenArgcArgv()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLOpenArgcArgv"], 
          "MLOpenString()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLOpenString"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLOpenArgcArgv()\"\>", 
       2->"\<\"MLOpenString()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "MathLink Connection Management" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkConnectionManagement"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"MathLink Connection Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLLinkName()", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"const", " ", "char", " ", "*", " ", "MLLinkName", 
       RowBox[{"(", 
        RowBox[{
         ButtonBox["MLINK",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/c/MLINK"], " ", 
         StyleBox["link", "TI"]}], ")"}]}]], "InlineCode"],
     " \[LineSeparator]returns the name string used to create the link."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " links are created using a combination of link mode, link protocol, and \
other options. The link name provides necessary information for the link mode \
and link protocol used to create the link."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 StyleBox["MLLinkName()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->683282342],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->693700762],

Cell["Use the Pipes protocol on Unix or Mac OS X to launch a link:", \
"ExampleText",
 CellID->1866453312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkLaunch", "[", 
  "\"\</Applications/Mathematica\\\\ 6.0.app/Contents/MacOS/MathKernel \
-mathlink\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1264074213],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"/Applications/Mathematica\\\\ \
6.0.app/Contents/MacOS/MathKernel -mathlink\"\>", ",", "17", ",", "4"}], 
  "]"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1181210383]
}, Open  ]],

Cell["\<\
The link name contains the pathname and command-line arguments to use to \
connect to the link:\
\>", "ExampleText",
 CellID->1188589966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->738674168],

Cell[BoxData["\<\"/Applications/Mathematica\\\\ \
6.0.app/Contents/MacOS/MathKernel -mathlink\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->293778269]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1239070596],

Cell["Use the TCPIP protocol to create a link:", "ExampleText",
 CellID->239578120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkCreate", "[", 
  RowBox[{"LinkProtocol", "\[Rule]", "\"\<TCPIP\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57624715],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"59107@10.37.129.2,59108@10.37.129.2\"\>", ",", "18", ",", 
   "5"}], "]"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->2130943855]
}, Open  ]],

Cell["\<\
The link name contains the port and hostname pairs to use to establish the \
TCP connection:\
\>", "ExampleText",
 CellID->1522110860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1292020956],

Cell[BoxData["\<\"59107@10.37.129.2,59108@10.37.129.2\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->1789052675]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1183423969],

Cell["Use the SharedMemory protocol to create a link:", "ExampleText",
 CellID->1689767078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkCreate", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1591532018],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"jzs_shm\"\>", ",", "19", ",", "6"}], "]"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1969803141]
}, Open  ]],

Cell["The link name contains the name of the shared memory object:", \
"ExampleText",
 CellID->873488635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->525277553],

Cell[BoxData["\<\"jzs_shm\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->34560454]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->682614044],

Cell[TextData[{
 "Declare a ",
 StyleBox["const char *", "InlineCode"],
 " variable and get the link name:"
}], "ExampleText",
 CellID->2104269028],

Cell["\<\
#include \"mathlink.h\"

/* read a link's name */

const char * f(MLINK lp)
{
\treturn MLLinkName(lp);
}\
\>", "Program",
 CellID->1036965688]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLOpenArgcArgv()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLOpenArgcArgv"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLOpenString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLOpenString"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->394698177]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkConnectionManagement"],
  FontSlant->"Italic"],
 ButtonBox[" Connection Management",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkConnectionManagement"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLLinkName() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 47, 6.7263516}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLLinkName()const char * MLLinkName(MLINK link) returns the name string \
used to create the link.", "synonyms" -> {"link name"}, "title" -> 
    "MLLinkName", "type" -> "MathLink C Function", "uri" -> 
    "ref/c/MLLinkName"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5092, 157, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->683282342]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13289, 468}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2668, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3291, 90, 58, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[3352, 93, 592, 17, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3981, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4459, 132, 295, 7, 70, "Notes",
 CellID->1067943069],
Cell[4757, 141, 298, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[5092, 157, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->683282342],
Cell[CellGroupData[{
Cell[5477, 171, 148, 5, 70, "ExampleSection",
 CellID->693700762],
Cell[5628, 178, 106, 2, 70, "ExampleText",
 CellID->1866453312],
Cell[CellGroupData[{
Cell[5759, 184, 192, 5, 70, "Input",
 CellID->1264074213],
Cell[5954, 191, 227, 6, 70, "Output",
 CellID->1181210383]
}, Open  ]],
Cell[6196, 200, 147, 4, 70, "ExampleText",
 CellID->1188589966],
Cell[CellGroupData[{
Cell[6368, 208, 120, 4, 70, "Input",
 CellID->738674168],
Cell[6491, 214, 153, 3, 70, "Output",
 CellID->293778269]
}, Open  ]],
Cell[6659, 220, 126, 3, 70, "ExampleDelimiter",
 CellID->1239070596],
Cell[6788, 225, 83, 1, 70, "ExampleText",
 CellID->239578120],
Cell[CellGroupData[{
Cell[6896, 230, 157, 4, 70, "Input",
 CellID->57624715],
Cell[7056, 236, 188, 5, 70, "Output",
 CellID->2130943855]
}, Open  ]],
Cell[7259, 244, 144, 4, 70, "ExampleText",
 CellID->1522110860],
Cell[CellGroupData[{
Cell[7428, 252, 121, 4, 70, "Input",
 CellID->1292020956],
Cell[7552, 258, 114, 2, 70, "Output",
 CellID->1789052675]
}, Open  ]],
Cell[7681, 263, 126, 3, 70, "ExampleDelimiter",
 CellID->1183423969],
Cell[7810, 268, 91, 1, 70, "ExampleText",
 CellID->1689767078],
Cell[CellGroupData[{
Cell[7926, 273, 102, 3, 70, "Input",
 CellID->1591532018],
Cell[8031, 278, 156, 4, 70, "Output",
 CellID->1969803141]
}, Open  ]],
Cell[8202, 285, 105, 2, 70, "ExampleText",
 CellID->873488635],
Cell[CellGroupData[{
Cell[8332, 291, 120, 4, 70, "Input",
 CellID->525277553],
Cell[8455, 297, 84, 2, 70, "Output",
 CellID->34560454]
}, Open  ]],
Cell[8554, 302, 125, 3, 70, "ExampleDelimiter",
 CellID->682614044],
Cell[8682, 307, 147, 5, 70, "ExampleText",
 CellID->2104269028],
Cell[8832, 314, 152, 10, 70, "Program",
 CellID->1036965688]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9033, 330, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[9352, 341, 455, 13, 70, "SeeAlso",
 CellID->394698177]
}, Open  ]],
Cell[CellGroupData[{
Cell[9844, 359, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[10165, 370, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[10499, 381, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[10829, 392, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[11192, 406, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[11513, 417, 429, 11, 70, "MoreAbout"],
Cell[11945, 430, 286, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[12246, 441, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

