(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15040,        500]
NotebookOptionsPosition[     12091,        404]
NotebookOutlinePosition[     13327,        440]
CellTagsIndexPosition[     13242,        435]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Running Mathematica from Within an External Program" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"], 
          "Error and Interrupt Handling" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ErrorAndInterruptHandling"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Running Mathematica from Within an External Program\"\>", 
       2->"\<\"Error and Interrupt Handling\"\>", 
       3->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       4->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       5->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLGetNext()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetNext"], "MLEndPacket()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLEndPacket"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLGetNext()\"\>", 
       2->"\<\"MLEndPacket()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "MathLink C Functions for Exchanging Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingExpressions"], 
          "MathLink C Language Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkCLanguageFunctions"],
           "MathLink Expression Packet Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkExpressionPacketHandling"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"MathLink C Functions for Exchanging Expressions\"\>", 
       3->"\<\"MathLink C Language Functions\"\>", 
       4->"\<\"MathLink Expression Packet Handling\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLNewPacket()", "ObjectNameAlt",
 CellID->32586],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLNewPacket", 
       RowBox[{"(", 
        RowBox[{
         ButtonBox["MLINK",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/c/MLINK"], " ", 
         StyleBox["link", "TI"]}], ")"}]}]], "InlineCode"],
     "\[LineSeparator]skips to the end of the current packet on ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6091]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["MLNewPacket()", "InlineCode"],
 Cell["", "InlineCode"],
 " works even if the head of the current top",
 "-",
 "level expression is not a standard packet type. "
}], "Notes",
 CellID->10558],

Cell[TextData[{
 StyleBox["MLNewPacket()", "InlineCode"],
 Cell["", "InlineCode"],
 " does nothing if you are already at the end of a packet. "
}], "Notes",
 CellID->17392],

Cell[TextData[{
 StyleBox["MLNewPacket()", "InlineCode"],
 Cell["", "InlineCode"],
 " returns 0 in the event of an error, and a nonzero value if the function \
succeeds."
}], "Notes",
 CellID->61072040],

Cell[TextData[{
 "Use ",
 StyleBox["MLError()", "InlineCode"],
 " to retrieve the error code if ",
 StyleBox["MLNewPacket()", "InlineCode"],
 " fails."
}], "Notes",
 CellID->2088076661],

Cell[TextData[{
 StyleBox["MLNewPacket()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->690475320],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->477146894],

Cell["\<\
#include \"mathlink.h\"

/* read the next number from a link and ignore everything else */

void f(MLINK lp)
{
\t/* determine the type of the data on the link */
\tswitch(MLGetType(lp))
\t{
\t\tcase MLTKINT:
\t\t\t/* integer data */
\t\t\tbreak;
\t\tcase MLTKREAL:
\t\t\t/* floating point data */
\t\t\tbreak;
\t\tdefault:
\t\t\t/* Skip to the next packet if not a number. */
\t\t\tif(! MLNewPacket(lp))
\t\t\t\t{ /* unable to jump ahead to the next packet on lp */ }
\t}
}\
\>", "Program",
 CellID->1644347074]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3848],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLGetNext()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetNext"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLEndPacket()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLEndPacket"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->798669331]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9963],

Cell[TextData[{
 ButtonBox["Running ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"],
  FontSlant->"Italic"],
 ButtonBox[" from Within an External Program",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"]
}], "Tutorials",
 CellID->3916],

Cell[TextData[ButtonBox["Error and Interrupt Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ErrorAndInterruptHandling"]], "Tutorials",
 CellID->18108518],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->50036101],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Language Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkExpressionPacketHandling"],
  FontSlant->"Italic"],
 ButtonBox[" Expression Packet Handling",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkExpressionPacketHandling"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLNewPacket() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 47, 7.7888788}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLNewPacket()int MLNewPacket(MLINK link) skips to the end of the current \
packet on link. ", "synonyms" -> {"new packet"}, "title" -> "MLNewPacket", 
    "type" -> "MathLink C Function", "uri" -> "ref/c/MLNewPacket"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6474, 199, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->690475320]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13099, 428}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3521, 78, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4144, 105, 54, 1, 70, "ObjectNameAlt",
 CellID->32586],
Cell[4201, 108, 635, 20, 70, "Usage",
 CellID->6091]
}, Open  ]],
Cell[CellGroupData[{
Cell[4873, 133, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5351, 150, 216, 7, 70, "Notes",
 CellID->10558],
Cell[5570, 159, 172, 5, 70, "Notes",
 CellID->17392],
Cell[5745, 166, 202, 6, 70, "Notes",
 CellID->61072040],
Cell[5950, 174, 185, 7, 70, "Notes",
 CellID->2088076661],
Cell[6138, 183, 299, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[6474, 199, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->690475320],
Cell[CellGroupData[{
Cell[6859, 213, 148, 5, 70, "ExampleSection",
 CellID->477146894],
Cell[7010, 220, 521, 23, 70, "Program",
 CellID->1644347074]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7580, 249, 310, 9, 70, "SeeAlsoSection",
 CellID->3848],
Cell[7893, 260, 443, 13, 70, "SeeAlso",
 CellID->798669331]
}, Open  ]],
Cell[CellGroupData[{
Cell[8373, 278, 313, 9, 70, "TutorialsSection",
 CellID->9963],
Cell[8689, 289, 490, 15, 70, "Tutorials",
 CellID->3916],
Cell[9182, 306, 167, 3, 70, "Tutorials",
 CellID->18108518],
Cell[9352, 311, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[9686, 322, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[10016, 333, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[10379, 347, 318, 9, 70, "MoreAboutSection",
 CellID->50036101],
Cell[10700, 358, 429, 11, 70, "MoreAbout"],
Cell[11132, 371, 331, 8, 70, "MoreAbout"],
Cell[11466, 381, 281, 8, 70, "MoreAbout"],
Cell[11750, 391, 299, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[12064, 402, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

