(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22712,        715]
NotebookOptionsPosition[     19779,        622]
NotebookOutlinePosition[     21057,        659]
CellTagsIndexPosition[     20972,        654]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       2->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLNewPacket()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLNewPacket"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MLNewPacket()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "C/C++ Language Interface" :> 
          Documentation`HelpLookup["paclet:guide/CLanguageInterface"], 
          "MathLink API" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkAPI"], 
          "MathLink C Functions for Exchanging Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingExpressions"], 
          "MathLink C Language Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkCLanguageFunctions"],
           "MathLink Expression Packet Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkExpressionPacketHandling"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"C/C++ Language Interface\"\>", 3->"\<\"MathLink API\"\>", 
       4->"\<\"MathLink C Functions for Exchanging Expressions\"\>", 
       5->"\<\"MathLink C Language Functions\"\>", 
       6->"\<\"MathLink Expression Packet Handling\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLNextPacket()", "ObjectNameAlt",
 CellID->18481],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLNextPacket", 
       RowBox[{"(", 
        RowBox[{
         ButtonBox["MLINK",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/c/MLINK"], " ", 
         StyleBox["link", "TI"]}], ")"}]}]], "InlineCode"],
     "\[LineSeparator]goes to the next packet on ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     " and returns a constant to indicate its head. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16500]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following packets can be returned:", "Notes",
 CellID->2147345468],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "BEGINDLGPKT", 
    RowBox[{
     ButtonBox["BeginDialogPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BeginDialogPacket"], "[", 
     StyleBox["integer", "TI"], "]"}], Cell[TextData[{
     "start a dialog subsession referenced by ",
     Cell[BoxData[
      StyleBox["integer", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "CALLPKT", 
    RowBox[{
     ButtonBox["CallPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CallPacket"], "[", 
     RowBox[{
      StyleBox["integer", "TI"], ",", 
      StyleBox["list", "TI"]}], "]"}], Cell[TextData[{
     "request to invoke the external function numbered ",
     Cell[BoxData[
      StyleBox["integer", "TI"]], "InlineFormula"],
     " with arguments ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "DISPLAYENDPKT", 
    RowBox[{
     ButtonBox["DisplayEndPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DisplayEndPacket"], "[", "]"}], Cell[
    "obsolete postscript graphics-related packet", "TableText"]},
   {Cell["      ", "TableRowIcon"], "DISPLAYPKT", 
    RowBox[{
     ButtonBox["DisplayPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DisplayPacket"], "[", "]"}], Cell[
    "obsolete postscript graphics-related packet ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "ENDDLGPKT", 
    RowBox[{
     ButtonBox["EndDialogPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EndDialogPacket"], "[", 
     StyleBox["integer", "TI"], "]"}], Cell[TextData[{
     "end the dialog subsession referenced by ",
     Cell[BoxData[
      StyleBox["integer", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "ENTEREXPRPKT", 
    RowBox[{
     ButtonBox["EnterExpressionPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EnterExpressionPacket"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "ENTERTEXTPKT", 
    RowBox[{
     ButtonBox["EnterTextPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EnterTextPacket"], "[", 
     StyleBox["string", "TI"], "]"}], Cell[TextData[{
     "parse ",
     Cell[BoxData[
      StyleBox["string", "TI"]], "InlineFormula"],
     " and evaluate as an expression"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "EVALUATEPKT", 
    RowBox[{
     ButtonBox["EvaluatePacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EvaluatePacket"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " while avoiding the Kernel main loop"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "INPUTNAMEPKT", 
    RowBox[{
     ButtonBox["InputNamePacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InputNamePacket"], "[", 
     StyleBox["string", "TI"], "]"}], Cell[TextData[{
     "name to be assigned to the next input (usually ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        StyleBox[
         ButtonBox["In",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/In"], "InlineFormula"], 
        StyleBox["[", "InlineFormula"], 
        StyleBox["n", "TI"], 
        StyleBox["]", "InlineFormula"]}], 
       StyleBox[":=", "InlineFormula"]}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "INPUTPKT", 
    RowBox[{
     ButtonBox["InputPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InputPacket"], "[", "]"}], Cell[TextData[{
     "prompt for input, as generated by ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     "'s ",
     Cell[BoxData[
      StyleBox[
       RowBox[{
        ButtonBox["Input",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Input"], "[", "]"}], "InlineFormula"]], 
      "InlineFormula"],
     " function"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "INPUTSTRPKT", 
    RowBox[{
     ButtonBox["InputStringPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InputStringPacket"], "[", "]"}], Cell[
    "request input as a string", "TableText"]},
   {Cell["      ", "TableRowIcon"], "MENUPKT", 
    RowBox[{
     ButtonBox["MenuPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MenuPacket"], "[", 
     RowBox[{
      StyleBox["integer", "TI"], ",", 
      StyleBox["string", "TI"]}], "]"}], Cell[TextData[{
     "menu request with title ",
     Cell[BoxData[
      StyleBox["string", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "MESSAGEPKT", 
    RowBox[{
     ButtonBox["MessagePacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MessagePacket"], "[", 
     RowBox[{
      StyleBox["symbol", "TI"], ",", 
      StyleBox["string", "TI"]}], "]"}], Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " message identifier (",
     Cell[BoxData[
      RowBox[{
       StyleBox["symbol", "TI"], "::", 
       StyleBox["string", "TI"]}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "OUTPUTNAMEPKT", 
    RowBox[{
     ButtonBox["OutputNamePacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OutputNamePacket"], "[", 
     StyleBox["string", "TI"], "]"}], Cell[TextData[{
     "name to be assigned to the next output (usually ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        StyleBox[
         ButtonBox["Out",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Out"], "InlineFormula"], 
        StyleBox["[", "InlineFormula"], 
        StyleBox["n", "TI"], 
        StyleBox["]", "InlineFormula"]}], 
       StyleBox["=", "InlineFormula"]}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "RESUMEPKT", 
    RowBox[{
     ButtonBox["ResumePacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ResumePacket"], "[", "]"}], Cell[
    "obsolete packet", "TableText"]},
   {Cell["      ", "TableRowIcon"], "RETURNEXPRPKT", 
    RowBox[{
     ButtonBox["ReturnExpressionPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReturnExpressionPacket"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "result of ",
     Cell[BoxData[
      StyleBox[
       RowBox[{
        ButtonBox["EnterExpressionPacket",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/EnterExpressionPacket"], "[", "]"}], 
       "InlineFormula"]], "InlineFormula"],
     " evaluation"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "RETURNPKT", 
    RowBox[{
     ButtonBox["ReturnPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReturnPacket"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "result of a calculation", "TableText"]},
   {Cell["      ", "TableRowIcon"], "RETURNTEXTPKT", 
    RowBox[{
     ButtonBox["ReturnTextPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReturnTextPacket"], "[", 
     StyleBox["string", "TI"], "]"}], Cell[
    "formatted text representation of a result", "TableText"]},
   {Cell["      ", "TableRowIcon"], "SUSPENDPKT", 
    RowBox[{
     ButtonBox["SuspendPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SuspendPacket"], "[", "]"}], Cell[
    "obsolete packet", "TableText"]},
   {Cell["      ", "TableRowIcon"], "SYNTAXPACKET", 
    RowBox[{
     ButtonBox["SyntaxPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SyntaxPacket"], "[", 
     StyleBox["integer", "TI"], "]"}], Cell["\<\
position at which a syntax error was detected in the input line\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "TEXTPACKET", 
    RowBox[{
     ButtonBox["TextPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TextPacket"], "[", 
     StyleBox["string", "TI"], "]"}], Cell[TextData[{
     "text output from ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     ", as produced by ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Print",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Print"], "[", "]"}]], "InlineFormula"]
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True}}}},
 CellID->1972592841],

Cell[TextData[{
 StyleBox["MLNextPacket()", "InlineCode"],
 " returns ",
 StyleBox["ILLEGALPKT", "InlineCode"],
 " in the event of an error. ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 " defines ",
 StyleBox["ILLEGALPKT", "InlineCode"],
 " as 0."
}], "Notes",
 CellID->72854446],

Cell[TextData[{
 StyleBox["MLNextPacket()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->538901144],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->550596803],

Cell["\<\
#include \"mathlink.h\"

/* read the type of the incoming packet on a link */

void f(MLINK lp)
{
\tswitch(MLNextPacket(lp))
\t{
\t\tcase CALLPKT:
\t\t\t/* read the CallPacket[] */
\t\t\tbreak;
\t\tcase EVALUATEPKT:
\t\t\t/* read the EvaluatePacket[] */
\t\t\tbreak;
\t\tcase RETURNPKT:
\t\t\t/* read the EvaluatePacket[] */

\t\t/* ... */

\t\tcase ILLEGALPKT:
\t\t\t/* unable to read the next packet from lp */
\t}\t
}\
\>", "Program",
 CellID->897729398]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28241],

Cell[TextData[Cell[TextData[StyleBox[ButtonBox["MLNewPacket()",
 BaseStyle->"Link",
 ButtonData->"paclet:ref/c/MLNewPacket"],
 FontFamily->"Verdana"]], "InlineCode"]], "SeeAlso",
 CellID->553024960]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18880],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->34328170],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[ButtonBox["C/C++ Language Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CLanguageInterface"]], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"],
  FontSlant->"Italic"],
 ButtonBox[" API",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Language Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkExpressionPacketHandling"],
  FontSlant->"Italic"],
 ButtonBox[" Expression Packet Handling",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkExpressionPacketHandling"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLNextPacket() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 47, 14.3984230}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLNextPacket()int MLNextPacket(MLINK link) goes to the next packet on \
link and returns a constant to indicate its head. ", 
    "synonyms" -> {"next packet"}, "title" -> "MLNextPacket", "type" -> 
    "MathLink C Function", "uri" -> "ref/c/MLNextPacket"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14748, 432, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->538901144]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20828, 647}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3250, 74, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3873, 101, 55, 1, 70, "ObjectNameAlt",
 CellID->18481],
Cell[3931, 104, 666, 20, 70, "Usage",
 CellID->16500]
}, Open  ]],
Cell[CellGroupData[{
Cell[4634, 129, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5112, 146, 76, 1, 70, "Notes",
 CellID->2147345468],
Cell[5191, 149, 8861, 251, 70, "3ColumnTableMod",
 CellID->1972592841],
Cell[14055, 402, 353, 12, 70, "Notes",
 CellID->72854446],
Cell[14411, 416, 300, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[14748, 432, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->538901144],
Cell[CellGroupData[{
Cell[15133, 446, 148, 5, 70, "ExampleSection",
 CellID->550596803],
Cell[15284, 453, 467, 25, 70, "Program",
 CellID->897729398]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15800, 484, 311, 9, 70, "SeeAlsoSection",
 CellID->28241],
Cell[16114, 495, 198, 4, 70, "SeeAlso",
 CellID->553024960]
}, Open  ]],
Cell[CellGroupData[{
Cell[16349, 504, 314, 9, 70, "TutorialsSection",
 CellID->18880],
Cell[16666, 515, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[17000, 526, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[17330, 537, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[17693, 551, 318, 9, 70, "MoreAboutSection",
 CellID->34328170],
Cell[18014, 562, 429, 11, 70, "MoreAbout"],
Cell[18446, 575, 134, 2, 70, "MoreAbout"],
Cell[18583, 579, 234, 8, 70, "MoreAbout"],
Cell[18820, 589, 331, 8, 70, "MoreAbout"],
Cell[19154, 599, 281, 8, 70, "MoreAbout"],
Cell[19438, 609, 299, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[19752, 620, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

