(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14820,        500]
NotebookOptionsPosition[     12209,        417]
NotebookOutlinePosition[     13340,        447]
CellTagsIndexPosition[     13297,        444]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["OBSOLETE  MATHEMATICA MATHLINK C FUNCTION", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Running Mathematica from Within an External Program" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Running Mathematica from Within an External Program\"\>", 
       2->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       4->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLActivate" :> 
          Documentation`HelpLookup["paclet:ref/c/MLActivate"], "MLOpenString" :> 
          Documentation`HelpLookup["paclet:ref/c/MLOpenString"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLActivate\"\>", 
       2->"\<\"MLOpenString\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLOpenArgv()", "ObjectNameAlt",
 CellID->13273],

Cell[TextData[{
 "As of Version 6.0, ",
 StyleBox["MLOpenArgv()", "InlineCode"],
 " has been superseded by ",
 StyleBox[ButtonBox["MLOpenArgcArgv",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLOpenArgcArgv"], "InlineCode"],
 "."
}], "ObsolescenceNote",
 CellID->2068542891],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MLINK",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/c/MLINK"], " ", "MLOpenArgv", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLENV",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLENV"], " ", 
          StyleBox["env", "TI"]}], ",", 
         RowBox[{"char", " ", "**", 
          StyleBox["argv0", "TI"]}], ",", 
         RowBox[{"char", " ", "**", 
          StyleBox["argv1", "TI"]}], ",", 
         RowBox[{"long", " ", "*", 
          StyleBox["errno", "TI"]}]}], ")"}]}]], "InlineCode"],
     "\[LineSeparator]opens a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection taking parameters from an ",
     StyleBox["argv", "InlineCode"],
     " array. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23489]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox[ButtonBox["MLInitialize()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLInitialize"], "InlineCode"],
 " must be called before ",
 StyleBox["MLOpenArgv()", "InlineCode"],
 ". "
}], "Notes",
 CellID->4497],

Cell[TextData[{
 StyleBox["MLOpenArgv()", "InlineCode"],
 " scans for the following at successive locations starting at ",
 Cell[BoxData[
  StyleBox["argv0", "TI"]], "InlineFormula"],
 " and going up to just before ",
 Cell[BoxData[
  StyleBox["argv1", "TI"]], "InlineFormula"],
 ": "
}], "Notes",
 CellID->25338],

Cell[BoxData[GridBox[{
   {"\"\<-linkconnect\>\"", Cell[TextData[{
     "connect to an existing link (",
     Cell[BoxData[
      ButtonBox["LinkConnect",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LinkConnect"]], "InlineFormula"],
     ") "
    }], "TableText"]},
   {"\"\<-linkcreate\>\"", Cell[TextData[{
     "create a link (",
     Cell[BoxData[
      ButtonBox["LinkCreate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LinkCreate"]], "InlineFormula"],
     ") "
    }], "TableText"]},
   {"\"\<-linklaunch\>\"", Cell[TextData[{
     "launch a child process (",
     Cell[BoxData[
      ButtonBox["LinkLaunch",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LinkLaunch"]], "InlineFormula"],
     ") "
    }], "TableText"]},
   {
    RowBox[{"\"\<-linkname\>\"", ",", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""}], Cell[
    "the name to use in opening the link ", "TableText"]},
   {
    RowBox[{"\"\<-linkprotocol\>\"", ",", "\"\<\!\(\*
StyleBox[\"protocol\", \"TI\"]\)\>\""}], Cell[TextData[{
     "the link protocol to use (",
     Cell[BoxData["tcp"], "InlineCode"],
     ", ",
     Cell[BoxData["pipes"], "InlineCode"],
     ", etc.) "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTable",
 CellID->25576],

Cell[TextData[{
 StyleBox["MLOpenArgv()", "InlineCode"],
 " is not sensitive to the case of argument names. "
}], "Notes",
 CellID->22674],

Cell[TextData[{
 StyleBox["MLOpenArgv()", "InlineCode"],
 " ignores argument names that it does not recognize. "
}], "Notes",
 CellID->20325],

Cell[TextData[{
 StyleBox["MLOpenArgv()", "InlineCode"],
 " is called automatically by the ",
 StyleBox[ButtonBox["MLMain()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLMain"], "InlineCode"],
 " function created by ",
 StyleBox[ButtonBox["mprep",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mprep"], "InlineCode"],
 " and ",
 StyleBox[ButtonBox["mcc",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mcc"], "InlineCode"],
 ". "
}], "Notes",
 CellID->31465],

Cell[TextData[{
 "With a main program ",
 StyleBox["main(intargc, char *argv[])", "InlineCode"],
 " typical usage is ",
 Cell[TextData[{
  "MLOpenArgv(",
  StyleBox["env", "TI"],
  ", argv, argv+argc, ",
  StyleBox["errno", "TI"],
  ")"
 }], "InlineCode"],
 ". "
}], "Notes",
 CellID->23829],

Cell[TextData[{
 "Avoiding an explicit ",
 StyleBox["argc", "InlineCode"],
 " argument allows ",
 StyleBox["MLOpenArgv()", "InlineCode"],
 " to work independent of the size of an ",
 StyleBox["int", "InlineCode"],
 ". "
}], "Notes",
 CellID->2650],

Cell[TextData[{
 "On some computer systems, giving ",
 Cell[BoxData["0"], "InlineFormula"],
 " for ",
 Cell[BoxData[
  StyleBox["argv0", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["argv1", "TI"]], "InlineFormula"],
 " will cause arguments to be requested interactively, typically through a \
dialog box. "
}], "Notes",
 CellID->16736]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18421],

Cell[TextData[{
 StyleBox[ButtonBox["MLActivate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLActivate"],
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["MLOpenString",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLOpenString"],
  FontFamily->"Verdana"]
}], "SeeAlso",
 CellID->14039]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28989],

Cell[TextData[{
 ButtonBox["Running ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"],
  FontSlant->"Italic"],
 ButtonBox[" from Within an External Program",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"]
}], "Tutorials",
 CellID->3916],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLOpenArgv() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 47, 14.8984358}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Obsolete  Mathematica MathLink C Function", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "ObsoleteFlag", "summary" -> 
    "MLOpenArgv()MLINK MLOpenArgv(MLENV env,char **argv0,char **argv1,long \
*errno) opens a MathLink connection taking parameters from an argv array. ", 
    "synonyms" -> {"open argv"}, "title" -> "MLOpenArgv", "type" -> 
    "MathLink C Function", "uri" -> "ref/c/MLOpenArgv"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2728, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3351, 91, 53, 1, 70, "ObjectNameAlt",
 CellID->13273],
Cell[3407, 94, 279, 9, 70, "ObsolescenceNote",
 CellID->2068542891],
Cell[3689, 105, 1029, 32, 70, "Usage",
 CellID->23489]
}, Open  ]],
Cell[CellGroupData[{
Cell[4755, 142, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5233, 159, 236, 8, 70, "Notes",
 CellID->4497],
Cell[5472, 169, 313, 10, 70, "Notes",
 CellID->25338],
Cell[5788, 181, 1374, 42, 70, "2ColumnTable",
 CellID->25576],
Cell[7165, 225, 138, 4, 70, "Notes",
 CellID->22674],
Cell[7306, 231, 141, 4, 70, "Notes",
 CellID->20325],
Cell[7450, 237, 482, 16, 70, "Notes",
 CellID->31465],
Cell[7935, 255, 291, 13, 70, "Notes",
 CellID->23829],
Cell[8229, 270, 247, 9, 70, "Notes",
 CellID->2650],
Cell[8479, 281, 353, 12, 70, "Notes",
 CellID->16736]
}, Closed]],
Cell[CellGroupData[{
Cell[8869, 298, 311, 9, 70, "SeeAlsoSection",
 CellID->18421],
Cell[9183, 309, 379, 13, 70, "SeeAlso",
 CellID->14039]
}, Open  ]],
Cell[CellGroupData[{
Cell[9599, 327, 314, 9, 70, "TutorialsSection",
 CellID->28989],
Cell[9916, 338, 490, 15, 70, "Tutorials",
 CellID->3916],
Cell[10409, 355, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[10743, 366, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[11073, 377, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[11436, 391, 299, 8, 70, "MoreAboutSection"],
Cell[11738, 401, 429, 11, 70, "MoreAbout"]
}, Open  ]],
Cell[12182, 415, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

