(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16103,        534]
NotebookOptionsPosition[     13034,        438]
NotebookOutlinePosition[     14427,        476]
CellTagsIndexPosition[     14342,        471]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       2->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLPutInteger16Array()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutInteger16Array"], 
          "MLPutInteger32Array()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutInteger32Array"], 
          "MLPutInteger64Array()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutInteger64Array"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"MLPutInteger16Array()\"\>", 
       2->"\<\"MLPutInteger32Array()\"\>", 
       3->"\<\"MLPutInteger64Array()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "MathLink C Functions for Exchanging Data" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingData"], 
          "MathLink C Functions for Exchanging Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingExpressions"], 
          "MathLink C Functions for Exchanging Multidimensional Arrays" :> 
          Documentation`HelpLookup[
           "paclet:guide/\
MathLinkCFunctionsForExchangingMultidimensionalArrays"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"MathLink C Functions for Exchanging Data\"\>", 
       3->"\<\"MathLink C Functions for Exchanging Expressions\"\>", 
       4->"\<\"MathLink C Functions for Exchanging Multidimensional \
Arrays\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLPutByteArray()", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLPutByteArray", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["link", "TI"]}], ",", 
         RowBox[{"unsigned", " ", "char", " ", "*", 
          StyleBox["a", "TI"]}], ",", 
         RowBox[{"int", " ", "*", 
          StyleBox["dims", "TI"]}], ",", 
         RowBox[{"char", " ", "**", 
          StyleBox["heads", "TI"]}], ",", 
         RowBox[{"int", " ", 
          StyleBox["d", "TI"]}]}], ")"}]}]], "InlineCode"],
     " \[LineSeparator]puts an array of integers in the range 0\[Dash]255 to \
the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection specified by ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     " to form a depth ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " array with dimensions ",
     Cell[BoxData[
      StyleBox["dims", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The array ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " must be laid out in memory like a C array declared explicitly as ",
 Cell[BoxData[
  RowBox[{"unsigned", " ", "char", " ", 
   RowBox[{
    RowBox[{
     StyleBox["a", "TI"], "[", 
     StyleBox["m", "TI"], "]"}], "[", 
    StyleBox["n", "TI"], "]"}], 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineCode"],
 ". "
}], "Notes",
 CellID->21154],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["heads", "TI"]], "InlineFormula"],
 " is given as ",
 StyleBox["NULL", "InlineCode"],
 ", the array will be assumed to have head ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 " at every level. "
}], "Notes",
 CellID->20593],

Cell[TextData[{
 "The length of the array at level ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " is taken to be ",
 Cell[BoxData[
  RowBox[{
   StyleBox["dims", "TI"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineCode"],
 ". "
}], "Notes",
 CellID->14059],

Cell[TextData[{
 StyleBox["MLPutByteArray()", "InlineCode"],
 " returns 0 in the event of an error, and a nonzero value otherwise."
}], "Notes",
 CellID->307456629],

Cell[TextData[{
 "Use ",
 StyleBox[ButtonBox["MLError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLError"], "InlineCode"],
 " to retrieve the error code if ",
 StyleBox["MLPutByteArray()", "InlineCode"],
 " fails."
}], "Notes",
 CellID->577908921],

Cell[TextData[{
 StyleBox["MLPutByteArray()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->91803656],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->152814979],

Cell["\<\
#include \"mathlink.h\"

/* send a list of integers in the range 0-255 to a link */

void f(MLINK lp)
{
\tunsigned char array[10][5][3][4];
\tlong dims[4];
\tint i;

\tfor(i = 0; i < 600; i++)
\t\t*((unsigned char *)array + i) = i;

\tdims[0] = 10;
\tdims[1] = 5;
\tdims[2] = 3;
\tdims[3] = 4;

\tif(! MLPutByteArray(lp, (unsigned char *)array, (long *)dims, (char **)0, \
4))
\t\t{ /* unable to send array of integers to lp */ }
}\
\>", "Program",
 CellID->1150478942]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLPutInteger16Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutInteger16Array"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLPutInteger32Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutInteger32Array"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLPutInteger64Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutInteger64Array"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->341826540]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->528712204],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Data",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:guide/MathLinkCFunctionsForExchangingMultidimensionalArrays"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Multidimensional Arrays",
  BaseStyle->"Link",
  ButtonData->
   "paclet:guide/MathLinkCFunctionsForExchangingMultidimensionalArrays"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLPutByteArray() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 47, 15.6484550}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLPutByteArray()int MLPutByteArray(MLINK link,unsigned char *a,int \
*dims,char **heads,int d) puts an array of integers in the range 0-255 to the \
MathLink connection specified by link to form a depth d array with dimensions \
dims. ", "synonyms" -> {"put byte array"}, "title" -> "MLPutByteArray", 
    "type" -> "MathLink C Function", "uri" -> "ref/c/MLPutByteArray"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7715, 245, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->91803656]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14200, 464}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3410, 76, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4033, 103, 62, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[4098, 106, 1283, 39, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5418, 150, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5896, 167, 430, 15, 70, "Notes",
 CellID->21154],
Cell[6329, 184, 342, 13, 70, "Notes",
 CellID->20593],
Cell[6674, 199, 272, 11, 70, "Notes",
 CellID->14059],
Cell[6949, 212, 164, 4, 70, "Notes",
 CellID->307456629],
Cell[7116, 218, 257, 9, 70, "Notes",
 CellID->577908921],
Cell[7376, 229, 302, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[7715, 245, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->91803656],
Cell[CellGroupData[{
Cell[8099, 259, 148, 5, 70, "ExampleSection",
 CellID->152814979],
Cell[8250, 266, 479, 24, 70, "Program",
 CellID->1150478942]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8778, 296, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[9097, 307, 736, 20, 70, "SeeAlso",
 CellID->341826540]
}, Open  ]],
Cell[CellGroupData[{
Cell[9870, 332, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[10191, 343, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[10525, 354, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[10855, 365, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[11218, 379, 319, 9, 70, "MoreAboutSection",
 CellID->528712204],
Cell[11540, 390, 429, 11, 70, "MoreAbout"],
Cell[11972, 403, 310, 8, 70, "MoreAbout"],
Cell[12285, 413, 331, 8, 70, "MoreAbout"],
Cell[12619, 423, 373, 10, 70, "MoreAbout"]
}, Open  ]],
Cell[13007, 436, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

