(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19629,        624]
NotebookOptionsPosition[     16427,        520]
NotebookOutlinePosition[     17673,        556]
CellTagsIndexPosition[     17588,        551]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Expressions in External Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Expressions in External Programs\"\>", 
       2->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       4->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLPutNext()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutNext"], "MLPutType()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutType"], 
          "MLPutRawSize()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutRawSize"], 
          "MLPutArgCount()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutArgCount"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLPutNext()\"\>", 
       2->"\<\"MLPutType()\"\>", 3->"\<\"MLPutRawSize()\"\>", 
       4->"\<\"MLPutArgCount()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level MathLink Operations" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelMathLinkOperations"],
           "MathLink C Functions for Exchanging Data" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingData"], 
          "MathLink C Functions for Exchanging Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingExpressions"], 
          "MathLink C Language Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCLanguageFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Low-Level MathLink Operations\"\>", 
       2->"\<\"MathLink C Functions for Exchanging Data\"\>", 
       3->"\<\"MathLink C Functions for Exchanging Expressions\"\>", 
       4->"\<\"MathLink C Language Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLPutRawData()", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLPutRawData", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["link", "TI"]}], ",", " ", 
         RowBox[{"const", " ", "unsigned", " ", "char", " ", "*", 
          StyleBox["d", "TI"]}], ",", " ", 
         RowBox[{"int", " ", 
          StyleBox["l", "TI"]}]}], ")"}]}]], "InlineFormula"],
     " \[LineSeparator]puts raw character data or numeric data from ",
     StyleBox["d", "TI"],
     " of length ",
     StyleBox["l", "TI"],
     " bytes to ",
     StyleBox["link", "TI"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Use ",
 StyleBox["MLPutRawData()", "InlineCode"],
 " in conjuction with ",
 StyleBox[ButtonBox["MLPutType()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutType"], "InlineCode"],
 " and ",
 StyleBox[ButtonBox["MLPutRawSize()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutRawSize"], "InlineCode"],
 " to manually put data to a link rather than using the type-specific API \
functions such as ",
 StyleBox[ButtonBox["MLPutInteger32()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutInteger32"], "InlineCode"],
 " or ",
 StyleBox[ButtonBox["MLPutUTF8String()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutUTF8String"], "InlineCode"],
 "."
}], "Notes",
 CellID->142858308],

Cell[TextData[{
 "Sending numerical data with ",
 StyleBox["MLPutRawData()", "InlineCode"],
 " bypasses the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library's internal mechanisms for ensuring data compatiblity between \
heterogenous computer systems. To use this function, users will need to \
account for endianness and C type size differences between computer systems."
}], "Notes",
 CellID->1381236454],

Cell[TextData[{
 "When sending character data use ",
 StyleBox[ButtonBox["MLPutType()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutType"], "InlineCode"],
 "with the token argument ",
 StyleBox["MLTKOLDSTR", "InlineCode"],
 " for string data or ",
 StyleBox["MLTKOLDSYM ", "InlineCode"],
 "for symbol data. Do not use ",
 StyleBox["MLPutRawData()", "InlineCode"],
 " to send character data in any format other than 7-bit ASCII encoding. "
}], "Notes",
 CellID->198960383],

Cell[TextData[{
 "When sending numerical data use ",
 StyleBox[ButtonBox["MLPutType()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutType"], "InlineCode"],
 " with the correct token for the binary data. The ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 " contains the complete list of these tokens, but the more common tokens are \
listed here for convenience."
}], "Notes",
 CellID->645881931],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox[
     RowBox[{"unsigned", " ", "char"}], "InlineCode"], Cell[TextData[StyleBox[
    "MLTK_CUCHAR", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["short", "InlineCode"], Cell[TextData[StyleBox[
    "MLTK_CSHORT", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["int", "InlineCode"], Cell[TextData[StyleBox[
    "MLTK_CINT", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["long", "InlineCode"], Cell[TextData[StyleBox[
    "MLTK_CLONG", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["float", "InlineCode"], Cell[TextData[StyleBox[
    "MLTK_CFLOAT", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["double", "InlineCode"], Cell[TextData[StyleBox[
    "MLTK_CDOUBLE", "InlineCode"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox[
     RowBox[{"long", " ", "double"}], "InlineCode"], Cell[TextData[StyleBox[
    "MLTK_CLONGDOUBLE", "InlineCode"]], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->1520283591],

Cell[TextData[{
 StyleBox["MLPutRawData()", "InlineCode"],
 " returns 0 in the event of an error and non-zero value if the function \
succeeds."
}], "Notes",
 CellID->514426913],

Cell[TextData[{
 "Use ",
 StyleBox[ButtonBox["MLError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLError"], "InlineCode"],
 " to retrieve the error code if ",
 StyleBox["MLPutRawData()", "InlineCode"],
 " fails."
}], "Notes",
 CellID->203963969],

Cell[TextData[{
 StyleBox["MLPutRawData()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->638526371]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->46774000],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->94660687],

Cell["\<\
#include \"mathlink.h\"

/* send a function as raw data to a link */

void f(MLINK lp)
{
\tint a = 2, b = 3;

\tif(! MLPutType(lp, MLTKFUNC))
\t\t{ return; /* unable to put the function type to lp */ }

\tif(! MLPutArgCount(lp, 2))
\t\t{ return; /* unable to put the number of arguments to lp */ }

\tif(! MLPutType(lp, MLTKOLDSYM))
\t\t{ return; /* unable to put function head type to lp */ }
\t
\tif(! MLPutRawSize(lp, 4))
\t\t{ return; /* unable to put the size of the symbol to lp */ }

\tif(! MLPutRawData(lp, (const unsigned char *)\"Plus\", 4))
\t\t{ return; /* unable to put the raw bytes to lp */ }

\tif(! MLPutType(lp, MLTK_CINT))
\t\t{ return; /* unable to put the argument type to lp */ }

\tif(! MLPutRawSize(lp, sizeof(int)))
\t\t{ return; /* unable to put the size of the integer to lp */ }

\tif(! MLPutRawData(lp, (const unsigned char *)&a, sizeof(a)))
\t\t{ return; /* unable to put the raw bytes of a to lp */ }

\tif(! MLPutType(lp, MLTK_CINT))
\t\t{ return; /* unable to put the second argument type to lp */ }

\tif(! MLPutRawSize(lp, sizeof(int)))
\t\t{ return; /* unable to put the size of the integer to lp */ }

\tif(! MLPutRawData(lp, (const unsigned char *)&b, sizeof(b)))
\t\t{ return; /* unable to put the raw bytes of b to lp */ }
}\
\>", "Code",
 CellID->635121130]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 StyleBox[ButtonBox["MLPutNext()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutNext"], "InlineCode",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["MLPutType()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutType"], "InlineCode",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["MLPutRawSize()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutRawSize"], "InlineCode",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["MLPutArgCount()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutArgCount"], "InlineCode",
  FontFamily->"Verdana"]
}], "SeeAlso",
 CellID->1487106320]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], "Tutorials",
 CellID->5695],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[{
 ButtonBox["Low-Level ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"],
  FontSlant->"Italic"],
 ButtonBox[" Operations",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"]
}], "MoreAbout",
 CellID->535827399],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Data",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"]
}], "MoreAbout",
 CellID->1252163122],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"]
}], "MoreAbout",
 CellID->1913334501],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Language Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"]
}], "MoreAbout",
 CellID->992828129]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLPutRawData() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 47, 38.3990374}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Symbol", 
    "language" -> "en", "paclet" -> "", "status" -> "None", "summary" -> 
    "int MLPutRawData (MLINK link, const unsigned char *d, int l) puts raw \
character data or numeric data from d of length l bytes to link.", 
    "synonyms" -> {}, "title" -> "MLPutRawData", "type" -> "Symbol", "uri" -> 
    "ref/MLPutRawData"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10015, 293, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->46774000]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17445, 544}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3531, 77, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4154, 104, 57, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[4214, 107, 908, 28, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5159, 140, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5637, 157, 722, 22, 70, "Notes",
 CellID->142858308],
Cell[6362, 181, 416, 10, 70, "Notes",
 CellID->1381236454],
Cell[6781, 193, 481, 13, 70, "Notes",
 CellID->198960383],
Cell[7265, 208, 540, 15, 70, "Notes",
 CellID->645881931],
Cell[7808, 225, 1429, 32, 70, "2ColumnTableMod",
 CellID->1520283591],
Cell[9240, 259, 177, 5, 70, "Notes",
 CellID->514426913],
Cell[9420, 266, 255, 9, 70, "Notes",
 CellID->203963969],
Cell[9678, 277, 300, 11, 70, "Notes",
 CellID->638526371]
}, Closed]],
Cell[CellGroupData[{
Cell[10015, 293, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->46774000],
Cell[CellGroupData[{
Cell[10399, 307, 147, 5, 70, "ExampleSection",
 CellID->94660687],
Cell[10549, 314, 1308, 43, 70, "Code",
 CellID->635121130]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11906, 363, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[12225, 374, 864, 27, 70, "SeeAlso",
 CellID->1487106320]
}, Open  ]],
Cell[CellGroupData[{
Cell[13126, 406, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[13447, 417, 199, 4, 70, "Tutorials",
 CellID->5695],
Cell[13649, 423, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[13983, 434, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[14313, 445, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[14676, 459, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[14997, 470, 395, 12, 70, "MoreAbout",
 CellID->535827399],
Cell[15395, 484, 331, 9, 70, "MoreAbout",
 CellID->1252163122],
Cell[15729, 495, 352, 9, 70, "MoreAbout",
 CellID->1913334501],
Cell[16084, 506, 301, 9, 70, "MoreAbout",
 CellID->992828129]
}, Open  ]],
Cell[16400, 518, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

