(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19088,        601]
NotebookOptionsPosition[     15821,        497]
NotebookOutlinePosition[     17117,        534]
CellTagsIndexPosition[     17032,        529]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Expressions in External Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"], 
          "Handling Lists, Arrays and Other Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/HandlingListsArraysAndOtherExpressions"], 
          "Portability of MathLink Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PortabilityOfMathLinkPrograms"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Expressions in External Programs\"\>", 
       2->"\<\"Handling Lists, Arrays and Other Expressions\"\>", 
       3->"\<\"Portability of MathLink Programs\"\>", 
       4->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       5->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       6->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLPutByteString()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutByteString"], 
          "MLPutUCS2String()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutUCS2String"], 
          "MLPutUTF8String()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutUTF8String"], 
          "MLPutUTF16String()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutUTF16String"], 
          "MLPutUTF32String()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutUTF32String"], 
          "MLPutSymbol()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutSymbol"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLPutByteString()\"\>", 
       2->"\<\"MLPutUCS2String()\"\>", 3->"\<\"MLPutUTF8String()\"\>", 
       4->"\<\"MLPutUTF16String()\"\>", 5->"\<\"MLPutUTF32String()\"\>", 
       6->"\<\"MLPutSymbol()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "C/C++ Language Interface" :> 
          Documentation`HelpLookup["paclet:guide/CLanguageInterface"], 
          "MathLink API" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkAPI"], 
          "MathLink C Functions for Exchanging Data" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingData"], 
          "MathLink C Functions for Exchanging Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingExpressions"], 
          "MathLink C Functions for Exchanging Strings" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCFunctionsForExchangingStrings"], 
          "MathLink C Language Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkCLanguageFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"C/C++ Language Interface\"\>", 3->"\<\"MathLink API\"\>", 
       4->"\<\"MathLink C Functions for Exchanging Data\"\>", 
       5->"\<\"MathLink C Functions for Exchanging Expressions\"\>", 
       6->"\<\"MathLink C Functions for Exchanging Strings\"\>", 
       7->"\<\"MathLink C Language Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLPutString()", "ObjectNameAlt",
 CellID->21770],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLPutString", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["link", "TI"]}], ",", 
         RowBox[{"const", " ", "char", "*", 
          StyleBox["s", "TI"]}]}], ")"}]}]], "InlineCode"],
     "\[LineSeparator]puts a null-terminated string of C characters to the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection specified by ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7526]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A raw backslash in the string must be sent as two characters ",
 StyleBox["'\[Backslash]\[Backslash]'", "InlineCode"],
 ". "
}], "Notes",
 CellID->7917],

Cell[TextData[{
 "Special characters can be sent only using the format returned by ",
 StyleBox[ButtonBox["MLGetString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetString"], "InlineCode"],
 ". "
}], "Notes",
 CellID->21870],

Cell[TextData[{
 "The encoding normally used is the same as for ",
 StyleBox[ButtonBox["MLGetString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetString"], "InlineCode"],
 ". "
}], "Notes",
 CellID->1234405596],

Cell[TextData[{
 StyleBox["MLPutString()", "InlineCode"],
 " returns 0 in the event of an error, and a nonzero value if the function \
succeeds."
}], "Notes",
 CellID->565400835],

Cell[TextData[{
 "Use ",
 StyleBox[ButtonBox["MLError()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLError"], "InlineCode"],
 " to retrieve the error code if ",
 StyleBox["MLPutString()", "InlineCode"],
 " fails."
}], "Notes",
 CellID->310616397],

Cell[TextData[{
 StyleBox["MLPutString()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->103243580],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->23096612],

Cell["\<\
#include \"mathlink.h\"

/* send a string representing an expression to a Mathematica kernel
   for evaluation */

void f(MLINK lp)
{
    /* construct the packet to be sent to the kernel */
\tMLPutFunction(lp, \"EvaluatePacket\", 1);
    MLPutFunction(lp, \"ToExpression\", 1));
    MLPutString(lp, (const char *)\"3+4/Sqrt[19.2]\", 14));
    MLEndPacket(lp));

    /* send the packet */
\tif(! MLFlush(lp))
\t\t{ /* unable to flush an outgoing data buffered in lp */ }

}\
\>", "Program",
 CellID->537298890]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17852],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLPutByteString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutByteString"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLPutUCS2String()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutUCS2String"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLPutUTF8String()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutUTF8String"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLPutUTF16String()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutUTF16String"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLPutUTF32String()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutUTF32String"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLPutSymbol()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutSymbol"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->1865540540]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->415],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], "Tutorials",
 CellID->26930],

Cell[TextData[ButtonBox["Handling Lists, Arrays and Other Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/HandlingListsArraysAndOtherExpressions"]], "Tutorials",
 CellID->106700868],

Cell[TextData[{
 ButtonBox["Portability of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"]
}], "Tutorials",
 CellID->65592066],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->642143486],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[ButtonBox["C/C++ Language Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CLanguageInterface"]], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"],
  FontSlant->"Italic"],
 ButtonBox[" API",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Data",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingData"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingExpressions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingStrings"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Strings",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCFunctionsForExchangingStrings"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Language Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLPutString() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 47, 47.5086456}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLPutString()int MLPutString(MLINK link,const char*s) puts a \
null-terminated string of C characters to the MathLink connection specified \
by link. ", "synonyms" -> {"put string"}, "title" -> "MLPutString", "type" -> 
    "MathLink C Function", "uri" -> "ref/c/MLPutString"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8325, 239, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->103243580]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16889, 522}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4877, 102, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5500, 129, 54, 1, 70, "ObjectNameAlt",
 CellID->21770],
Cell[5557, 132, 842, 26, 70, "Usage",
 CellID->7526]
}, Open  ]],
Cell[CellGroupData[{
Cell[6436, 163, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6914, 180, 170, 5, 70, "Notes",
 CellID->7917],
Cell[7087, 187, 236, 7, 70, "Notes",
 CellID->21870],
Cell[7326, 196, 222, 7, 70, "Notes",
 CellID->1234405596],
Cell[7551, 205, 178, 5, 70, "Notes",
 CellID->565400835],
Cell[7732, 212, 254, 9, 70, "Notes",
 CellID->310616397],
Cell[7989, 223, 299, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[8325, 239, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->103243580],
Cell[CellGroupData[{
Cell[8710, 253, 147, 5, 70, "ExampleSection",
 CellID->23096612],
Cell[8860, 260, 519, 20, 70, "Program",
 CellID->537298890]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9428, 286, 311, 9, 70, "SeeAlsoSection",
 CellID->17852],
Cell[9742, 297, 1456, 41, 70, "SeeAlso",
 CellID->1865540540]
}, Open  ]],
Cell[CellGroupData[{
Cell[11235, 343, 312, 9, 70, "TutorialsSection",
 CellID->415],
Cell[11550, 354, 200, 4, 70, "Tutorials",
 CellID->26930],
Cell[11753, 360, 200, 4, 70, "Tutorials",
 CellID->106700868],
Cell[11956, 366, 415, 12, 70, "Tutorials",
 CellID->65592066],
Cell[12374, 380, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[12708, 391, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[13038, 402, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[13401, 416, 319, 9, 70, "MoreAboutSection",
 CellID->642143486],
Cell[13723, 427, 429, 11, 70, "MoreAbout"],
Cell[14155, 440, 134, 2, 70, "MoreAbout"],
Cell[14292, 444, 234, 8, 70, "MoreAbout"],
Cell[14529, 454, 310, 8, 70, "MoreAbout"],
Cell[14842, 464, 331, 8, 70, "MoreAbout"],
Cell[15176, 474, 319, 8, 70, "MoreAbout"],
Cell[15498, 484, 281, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[15794, 495, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

