(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14480,        465]
NotebookOptionsPosition[     11593,        374]
NotebookOutlinePosition[     12992,        413]
CellTagsIndexPosition[     12907,        408]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Expressions in External Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"], 
          "Handling Lists, Arrays and Other Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/HandlingListsArraysAndOtherExpressions"], 
          "Portability of MathLink Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PortabilityOfMathLinkPrograms"], 
          "MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Expressions in External Programs\"\>", 
       2->"\<\"Handling Lists, Arrays and Other Expressions\"\>", 
       3->"\<\"Portability of MathLink Programs\"\>", 
       4->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       5->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       6->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLGetInteger32Array()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetInteger32Array"], 
          "MLReleaseInteger32Array()" :> 
          Documentation`HelpLookup[
           "paclet:ref/c/MLReleaseInteger32Array"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"MLGetInteger32Array()\"\>", 
       2->"\<\"MLReleaseInteger32Array()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "MathLink C Functions for Exchanging Multidimensional Arrays" :> 
          Documentation`HelpLookup[
           "paclet:guide/\
MathLinkCFunctionsForExchangingMultidimensionalArrays"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"MathLink C Functions for Exchanging Multidimensional \
Arrays\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLReleaseByteArray()", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"void", " ", "MLReleaseByteArray", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLINK",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLINK"], " ", 
          StyleBox["link", "TI"]}], ",", 
         RowBox[{"unsigned", " ", "char", " ", "*", 
          StyleBox["a", "TI"]}], ",", 
         RowBox[{"int", " ", "*", 
          StyleBox["dims", "TI"]}], ",", 
         RowBox[{"char", " ", "**", 
          StyleBox["heads", "TI"]}], ",", 
         RowBox[{"int", " ", 
          StyleBox["d", "TI"]}]}], ")"}]}]], "InlineCode"],
     " \[LineSeparator]disowns the memory allocated by ",
     StyleBox[ButtonBox["MLGetByteArray()",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetByteArray"], "InlineCode"],
     " to store the array ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     ", its dimensions ",
     Cell[BoxData[
      StyleBox["dims", "TI"]], "InlineFormula"],
     " and the heads ",
     Cell[BoxData[
      StyleBox["heads", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["MLReleaseByteArray()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->520765627],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->16166837],

Cell["\<\
#include \"mathlink.h\"

/* read an array of integers each of size 1 byte and then release that memory \
to MathLink for deallocation */

void f(MLINK lp)
{
\tunsigned char *data;
\tint *dimensions;
\tchar **heads;
\tint depth;

\tif(! MLGetByteArray(lp, &data, &dimensions, &heads, &depth))
\t\t{ /* unable to read array from lp */ }

\t/* ... */

\tMLReleaseByteArray(lp, data, dimensions, heads, depth);
}\
\>", "Program",
 CellID->611035235]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLGetInteger32Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetInteger32Array"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLReleaseInteger32Array()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReleaseInteger32Array"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->1571000816]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Manipulating Expressions in External Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]], "Tutorials",
 CellID->26930],

Cell[TextData[ButtonBox["Handling Lists, Arrays and Other Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/HandlingListsArraysAndOtherExpressions"]], "Tutorials",
 CellID->106700868],

Cell[TextData[{
 ButtonBox["Portability of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"]
}], "Tutorials",
 CellID->65592066],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->18031949],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:guide/MathLinkCFunctionsForExchangingMultidimensionalArrays"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions for Exchanging Multidimensional Arrays",
  BaseStyle->"Link",
  ButtonData->
   "paclet:guide/MathLinkCFunctionsForExchangingMultidimensionalArrays"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLReleaseByteArray() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 48, 2.6184074}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLReleaseByteArray()void MLReleaseByteArray(MLINK link,unsigned char \
*a,int *dims,char **heads,int d) disowns the memory allocated by \
MLGetByteArray() to store the array a, its dimensions dims and the heads \
heads. ", "synonyms" -> {"release byte array"}, "title" -> 
    "MLReleaseByteArray", "type" -> "MathLink C Function", "uri" -> 
    "ref/c/MLReleaseByteArray"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6370, 185, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->520765627]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12764, 401}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3492, 78, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4115, 105, 66, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[4184, 108, 1328, 39, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5549, 152, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6027, 169, 306, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[6370, 185, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->520765627],
Cell[CellGroupData[{
Cell[6755, 199, 147, 5, 70, "ExampleSection",
 CellID->16166837],
Cell[6905, 206, 455, 21, 70, "Program",
 CellID->611035235]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7409, 233, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7728, 244, 488, 13, 70, "SeeAlso",
 CellID->1571000816]
}, Open  ]],
Cell[CellGroupData[{
Cell[8253, 262, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[8574, 273, 200, 4, 70, "Tutorials",
 CellID->26930],
Cell[8777, 279, 200, 4, 70, "Tutorials",
 CellID->106700868],
Cell[8980, 285, 415, 12, 70, "Tutorials",
 CellID->65592066],
Cell[9398, 299, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[9732, 310, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[10062, 321, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[10425, 335, 318, 9, 70, "MoreAboutSection",
 CellID->18031949],
Cell[10746, 346, 429, 11, 70, "MoreAbout"],
Cell[11178, 359, 373, 10, 70, "MoreAbout"]
}, Open  ]],
Cell[11566, 372, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

