(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13752,        473]
NotebookOptionsPosition[     10938,        385]
NotebookOutlinePosition[     12335,        423]
CellTagsIndexPosition[     12250,        418]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       2->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLNewParameters()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLNewParameters"], 
          "MLAllocParameter()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLAllocParameter"], 
          "MLInitialize()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLInitialize"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLNewParameters()\"\>", 
       2->"\<\"MLAllocParameter()\"\>", 
       3->"\<\"MLInitialize()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLSetAllocParameter()", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"void", " ", "MLSetAllocParameter", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"char", "*", " ", 
          StyleBox["p", "TI"]}], ",", 
         RowBox[{
          ButtonBox["MLAllocator",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLAllocator"], " ", 
          StyleBox["a", "TI"]}], ",", 
         RowBox[{
          ButtonBox["MLDeallocator",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLDeallocator"], " ", 
          StyleBox["d", "TI"]}]}], ")"}]}]], "InlineCode"],
     " \[LineSeparator]sets the memory allocator and deallocator specified by \
",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " in the ",
     StyleBox[ButtonBox["MLParameters",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLParameters"], "InlineCode"],
     " object ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " for later use with ",
     StyleBox["MLInitialize().", "InlineCode"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Use ",
 StyleBox["MLSetAllocParameter()", "InlineCode"],
 " to install special memory allocaters in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library. The library will use the allocators specified by ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " for all dynamic memory allocations."
}], "Notes",
 CellID->1512749380],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " must have the same call signature as the C memory allocator functions ",
 StyleBox["malloc()", "InlineCode"],
 " and ",
 StyleBox["free()", "InlineCode"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " must be thread-safe."
}], "Notes",
 CellID->1442521309],

Cell[TextData[{
 StyleBox["MLSetAllocParameter()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->2483656],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->406036498],

Cell["\<\
#include \"mathlink.h\"

void * Custom_Allocator(size_t size)
{
\t/* ... */
}

void Custom_Deallocator(void *ptr)
{
\t/* ... */
}


int main()
{
\tMLEnvironment env;
\tMLParameters p;
\tunsigned long revision;

\trevision = MLNewParameters((char *)&p, MLREVISION, MLAPIREVISION);
\tif(! revision)
\t\t{ /* unable to initialize the MLParameters object */ }

\tMLSetAllocParameter(&p, Custom_Allocator, Custom_Deallocator);

\t/* Install the Custom* memory allocator in MathLink. */
\tenv = MLInitialize(&p);
\tif(env == (MLENV)0)
\t\t{ /* unable to initialize MathLink environment */ }

\t/* ... */

\tMLDeinitialize(env);
\treturn 0;
}\
\>", "Program",
 CellID->719932827]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLNewParameters()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLNewParameters"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLAllocParameter()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLAllocParameter"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLInitialize()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLInitialize"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->990313835]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLSetAllocParameter() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 48, 26.1658852}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLSetAllocParameter()void MLSetAllocParameter(char* p,MLAllocator \
a,MLDeallocator d) sets the memory allocator and deallocator specified by a \
and d in the MLParameters object p for later use with MLInitialize().", 
    "synonyms" -> {"set alloc parameter"}, "title" -> "MLSetAllocParameter", 
    "type" -> "MathLink C Function", "uri" -> "ref/c/MLSetAllocParameter"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6488, 212, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->2483656]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12109, 411}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2635, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3258, 91, 67, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[3328, 94, 1326, 40, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4691, 139, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5169, 156, 432, 14, 70, "Notes",
 CellID->1512749380],
Cell[5604, 172, 336, 12, 70, "Notes",
 CellID->1067943069],
Cell[5943, 186, 198, 8, 70, "Notes",
 CellID->1442521309],
Cell[6144, 196, 307, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[6488, 212, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->2483656],
Cell[CellGroupData[{
Cell[6871, 226, 148, 5, 70, "ExampleSection",
 CellID->406036498],
Cell[7022, 233, 682, 37, 70, "Program",
 CellID->719932827]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7753, 276, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[8072, 287, 708, 20, 70, "SeeAlso",
 CellID->990313835]
}, Open  ]],
Cell[CellGroupData[{
Cell[8817, 312, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[9138, 323, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[9472, 334, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[9802, 345, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[10165, 359, 299, 8, 70, "MoreAboutSection"],
Cell[10467, 369, 429, 11, 70, "MoreAbout"]
}, Open  ]],
Cell[10911, 383, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

