(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12628,        422]
NotebookOptionsPosition[      9772,        333]
NotebookOutlinePosition[     11216,        372]
CellTagsIndexPosition[     11131,        367]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       2->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLSetSignalHandler()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLSetSignalHandler"], 
          "MLUnsetSignalHandler()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLUnsetSignalHandler"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"MLSetSignalHandler()\"\>", 
       2->"\<\"MLUnsetSignalHandler()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLSetSignalHandlerFromFunction()", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLSetSignalHandlerFromFunction", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"MLENV", " ", 
          StyleBox["ep", "TI"]}], ",", 
         RowBox[{"int", " ", 
          StyleBox["s", "TI"]}], ",", 
         RowBox[{"void", " ", "*", 
          StyleBox["sf", "TI"]}]}], ")"}]}]], "InlineCode"],
     " \[LineSeparator]installs the Unix signal handler pointed to by ",
     Cell[BoxData[
      StyleBox["sf", "TI"]], "InlineFormula"],
     " for signal ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " in the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " library signal-handling mechanism."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["MLSetSignalHandlerFromFunction()", "InlineCode"],
 " does nothing on Microsoft Windows."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["sf", "TI"]], "InlineFormula"],
 " is a pointer to a signal-handling function of type ",
 StyleBox["void (*func)(int)", "InlineCode"],
 ". See the header file ",
 StyleBox["signal.h", "InlineCode"],
 " on most Unix and Unix-like systems for further details."
}], "Notes",
 CellID->867717302],

Cell[TextData[{
 StyleBox["MLSetSignalHandlerFromFunction()", "InlineCode"],
 " returns ",
 StyleBox["MLEOK", "InlineCode"],
 " if no error occurs and one of the other error codes as listed in ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 " in the event of an error."
}], "Notes",
 CellID->163247937],

Cell[TextData[{
 StyleBox["MLSetSignalHandlerFromFunction()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->496710940],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->39462421],

Cell["\<\
#include <signal.h>
#include \"mathlink.h\"

void h(int signum)
{
\t/* ... */
}

/* set a SIGHUP signal handler in the MathLink environment */

void f(MLENV ep)
{
\tint err;
\terr = MLSetSignalHandlerFromFunction(ep, SIGHUP, (void *)h);
\tif(err != MLEOK)
\t\t{ /* unable to set the signal handler in ep */ }
}\
\>", "Program",
 CellID->1785009257]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLSetSignalHandler()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLSetSignalHandler"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLUnsetSignalHandler()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLUnsetSignalHandler"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->146816993]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLSetSignalHandlerFromFunction() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 48, 26.7596504}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLSetSignalHandlerFromFunction()int MLSetSignalHandlerFromFunction(MLENV \
ep,int s,void *sf) installs the Unix signal handler pointed to by sf for \
signal s in the MathLink library signal-handling mechanism.", 
    "synonyms" -> {"set signal handler from function"}, "title" -> 
    "MLSetSignalHandlerFromFunction", "type" -> "MathLink C Function", "uri" -> 
    "ref/c/MLSetSignalHandlerFromFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5874, 185, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->496710940]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10988, 360}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2513, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3136, 87, 78, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[3217, 90, 923, 28, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4177, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4655, 140, 149, 4, 70, "Notes",
 CellID->1067943069],
Cell[4807, 146, 333, 9, 70, "Notes",
 CellID->867717302],
Cell[5143, 157, 373, 10, 70, "Notes",
 CellID->163247937],
Cell[5519, 169, 318, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[5874, 185, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->496710940],
Cell[CellGroupData[{
Cell[6259, 199, 147, 5, 70, "ExampleSection",
 CellID->39462421],
Cell[6409, 206, 358, 19, 70, "Program",
 CellID->1785009257]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6816, 231, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7135, 242, 479, 13, 70, "SeeAlso",
 CellID->146816993]
}, Open  ]],
Cell[CellGroupData[{
Cell[7651, 260, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[7972, 271, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[8306, 282, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[8636, 293, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[8999, 307, 299, 8, 70, "MoreAboutSection"],
Cell[9301, 317, 429, 11, 70, "MoreAbout"]
}, Open  ]],
Cell[9745, 331, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

