(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13035,        434]
NotebookOptionsPosition[     10208,        345]
NotebookOutlinePosition[     11615,        384]
CellTagsIndexPosition[     11530,        379]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHLINK C FUNCTION", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink C API Developer Guide (Mac OS X)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Macintosh"], 
          "MathLink C API Developer Guide (Unix and Linux)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Unix"], 
          "MathLink C API Developer Guide (Windows)" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkDeveloperGuide-Windows"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MathLink C API Developer Guide (Mac OS X)\"\>", 
       2->"\<\"MathLink C API Developer Guide (Unix and Linux)\"\>", 
       3->"\<\"MathLink C API Developer Guide (Windows)\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLSetSignalHandler()" :> 
          Documentation`HelpLookup["paclet:ref/c/MLSetSignalHandler"], 
          "MLSetSignalHandlerFromFunction()" :> 
          Documentation`HelpLookup[
           "paclet:ref/c/MLSetSignalHandlerFromFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLSetSignalHandler()\"\>", 
       2->"\<\"MLSetSignalHandlerFromFunction()\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alphabetical Listing of MathLink C Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AlphabeticalListingOfMathLinkCFunctions"], 
          "Low-Level MathLink Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelMathLinkOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Alphabetical Listing of MathLink C Functions\"\>", 
       2->"\<\"Low-Level MathLink Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MLUnsetSignalHandler()", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"int", " ", "MLUnsetSignalHandler", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          ButtonBox["MLENV",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/c/MLENV"], " ", 
          StyleBox["env", "TI"]}], ",", 
         RowBox[{"int", " ", 
          StyleBox["signum", "TI"]}], ",", 
         RowBox[{"void", " ", "*", 
          StyleBox["f", "TI"]}]}], ")"}]}]], "InlineCode"],
     " \[LineSeparator]removes the Unix signal-handler function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " as a signal handler for signal ",
     Cell[BoxData[
      StyleBox["signum", "TI"]], "InlineFormula"],
     " from the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " library signal-handling mechanism."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["MLUnsetSignalHandler()", "InlineCode"],
 " does nothing on Microsoft Windows."
}], "Notes",
 CellID->1032631650],

Cell[TextData[{
 StyleBox["MLUnsetSignalHandler()", "InlineCode"],
 " returns ",
 StyleBox["MLEOK", "InlineCode"],
 " upon successful completion and one of the other error codes as specified \
in ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 " in the event of an error."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 StyleBox["MLUnsetSignalHandler()", "InlineCode"],
 " is declared in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file ",
 StyleBox[ButtonBox["mathlink.h",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/file/mathlink.h"], "InlineCode"],
 "."
}], "Notes",
 CellID->836595234]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->429481749],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->31012377],

Cell["\<\
#include <signal.h>
#include \"mathlink.h\"

void s(int signum)
{
\t/* ... */
}

/* remove a SIGHUP signal-handling function from a MathLink environment */
void f(MLENV ep)
{
\tint err;

\terr = MLUnsetSignalHandler(ep, SIGHUP, (void *)s);
\tif(error != MLEOK)
\t\t{ /* unable to remove the function from MathLink's signal-handler \
mechanism */ }
}\
\>", "Program",
 CellID->1785009257]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["MLSetSignalHandler()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLSetSignalHandler"],
  FontFamily->"Verdana"]], "InlineCode"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["MLSetSignalHandlerFromFunction()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLSetSignalHandlerFromFunction"],
  FontFamily->"Verdana"]], "InlineCode"]
}], "SeeAlso",
 CellID->1418711554]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "Tutorials",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "Tutorials",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "Tutorials",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[{
 ButtonBox["Alphabetical Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "MoreAbout"],

Cell[TextData[{
 ButtonBox["Low-Level ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"],
  FontSlant->"Italic"],
 ButtonBox[" Operations",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelMathLinkOperations"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MLUnsetSignalHandler() - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 48, 34.5879758}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "MathLink C Function", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MLUnsetSignalHandler()int MLUnsetSignalHandler(MLENV env,int signum,void \
*f) removes the Unix signal-handler function f as a signal handler for signal \
signum from the MathLink library signal-handling mechanism.", 
    "synonyms" -> {"unset signal handler"}, "title" -> "MLUnsetSignalHandler",
     "type" -> "MathLink C Function", "uri" -> 
    "ref/c/MLUnsetSignalHandler"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5853, 182, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->429481749]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11387, 372}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2742, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3365, 91, 68, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[3436, 94, 1035, 31, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4508, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4986, 147, 139, 4, 70, "Notes",
 CellID->1032631650],
Cell[5128, 153, 377, 11, 70, "Notes",
 CellID->1067943069],
Cell[5508, 166, 308, 11, 70, "Notes",
 CellID->836595234]
}, Closed]],
Cell[CellGroupData[{
Cell[5853, 182, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->429481749],
Cell[CellGroupData[{
Cell[6238, 196, 147, 5, 70, "ExampleSection",
 CellID->31012377],
Cell[6388, 203, 397, 20, 70, "Program",
 CellID->1785009257]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6834, 229, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7153, 240, 500, 13, 70, "SeeAlso",
 CellID->1418711554]
}, Open  ]],
Cell[CellGroupData[{
Cell[7690, 258, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[8011, 269, 331, 9, 70, "Tutorials",
 CellID->403767969],
Cell[8345, 280, 327, 9, 70, "Tutorials",
 CellID->309869466],
Cell[8675, 291, 326, 9, 70, "Tutorials",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[9038, 305, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[9359, 316, 429, 11, 70, "MoreAbout"],
Cell[9791, 329, 375, 11, 70, "MoreAbout"]
}, Open  ]],
Cell[10181, 343, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

