(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7847,        264]
NotebookOptionsPosition[      5633,        197]
NotebookOutlinePosition[      6933,        230]
CellTagsIndexPosition[      6890,        227]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[EscapeKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/EscapeKey"], 
          "\\[SpaceIndicator]" :> 
          Documentation`HelpLookup["paclet:ref/character/SpaceIndicator"], 
          "\\[ReturnIndicator]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/ReturnIndicator"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[EscapeKey]\"\>", 
       2->"\<\"\\\\[SpaceIndicator]\"\>", 
       3->"\<\"\\\\[ReturnIndicator]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[AliasIndicator]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[AliasIndicator]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->296254608],

Cell["\\[AliasIndicator]", "CharacterName",
 CellID->2510],

Cell["Unicode: F768.", "Notes",
 CellID->21003],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["esc", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->26869],

Cell["Letter\[Hyphen]like form. ", "Notes",
 CellID->17861],

Cell[TextData[{
 "Representation of the indicator for special character aliases in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Notes",
 CellID->14688],

Cell[TextData[{
 Cell["\\[AliasIndicator]", "InlineCharacterName"],
 " is an inactive letter\[Hyphen]like form, used in describing how to type \
aliases. "
}], "Notes",
 CellID->13401],

Cell[TextData[{
 "An active character of the same appearance is typically obtained by typing \
",
 StyleBox["Esc", "KeyEvent"],
 ". "
}], "Notes",
 CellID->9789]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->15255],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->16423]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->24182],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[EscapeKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EscapeKey"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[SpaceIndicator]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SpaceIndicator"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ReturnIndicator]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ReturnIndicator"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->10285]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[AliasIndicator] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 50.9106402}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F768. Alias: Esc esc Esc. Letter-like form. Representation of \
the indicator for special character aliases in Mathematica. \
\\[AliasIndicator] is an inactive letter-like form, used in describing how to \
type aliases. An active character of the same appearance is typically \
obtained by typing Esc. ", "synonyms" -> {"alias indicator"}, "title" -> 
    "\\[AliasIndicator]", "type" -> "Character Name", "uri" -> 
    "ref/character/AliasIndicator"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2183, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2806, 82, 599, 19, 70, "CharacterImage",
 CellID->296254608],
Cell[3408, 103, 58, 1, 70, "CharacterName",
 CellID->2510],
Cell[3469, 106, 47, 1, 70, "Notes",
 CellID->21003],
Cell[3519, 109, 235, 9, 70, "Notes",
 CellID->26869],
Cell[3757, 120, 59, 1, 70, "Notes",
 CellID->17861],
Cell[3819, 123, 169, 6, 70, "Notes",
 CellID->14688],
Cell[3991, 131, 184, 5, 70, "Notes",
 CellID->13401],
Cell[4178, 138, 161, 6, 70, "Notes",
 CellID->9789]
}, Open  ]],
Cell[CellGroupData[{
Cell[4376, 149, 53, 1, 70, "TutorialsSection",
 CellID->15255],
Cell[4432, 152, 196, 4, 70, "Tutorials",
 CellID->16423]
}, Open  ]],
Cell[CellGroupData[{
Cell[4665, 161, 38, 0, 70, "MoreAboutSection"],
Cell[4706, 163, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4886, 170, 50, 1, 70, "SeeAlsoSection",
 CellID->24182],
Cell[4939, 173, 652, 19, 70, "SeeAlso",
 CellID->10285]
}, Open  ]],
Cell[5606, 195, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

