(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7565,        253]
NotebookOptionsPosition[      5591,        190]
NotebookOutlinePosition[      6638,        219]
CellTagsIndexPosition[      6595,        216]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Greek Letters" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringGreekLetters"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Entering Greek Letters\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[CapitalAlpha]" :> 
          Documentation`HelpLookup["paclet:ref/character/CapitalAlpha"], 
          "\\[Proportional]" :> 
          Documentation`HelpLookup["paclet:ref/character/Proportional"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[CapitalAlpha]\"\>", 
       2->"\<\"\\\\[Proportional]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Greek Letters" :> 
          Documentation`HelpLookup["paclet:guide/GreekLetters"], 
          "Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Greek Letters\"\>", 
       2->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Alpha]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Alpha]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->327850350],

Cell["\\[Alpha]", "CharacterName",
 CellID->10808],

Cell["Unicode: 03B1.", "Notes",
 CellID->1832],

Cell[TextData[{
 "Aliases: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["a", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["alpha", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->20945],

Cell["Greek letter. ", "Notes",
 CellID->27756],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[Proportional]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Proportional"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->28321]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->19558],

Cell[TextData[ButtonBox["Entering Greek Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringGreekLetters"]], "Tutorials",
 CellID->23646],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->23196],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[CapitalAlpha]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalAlpha"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Proportional]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Proportional"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->20222]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->67591891],

Cell[TextData[ButtonBox["Greek Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GreekLetters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Alpha] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 34, 51.1918974}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 03B1. Aliases: Esc a Esc, Esc alpha Esc. Greek letter. Not the \
same as \\[Proportional]. ", "synonyms" -> {"alpha"}, "title" -> "\\[Alpha]", 
    "type" -> "Character Name", "uri" -> "ref/character/Alpha"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2268, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2891, 82, 581, 19, 70, "CharacterImage",
 CellID->327850350],
Cell[3475, 103, 50, 1, 70, "CharacterName",
 CellID->10808],
Cell[3528, 106, 46, 1, 70, "Notes",
 CellID->1832],
Cell[3577, 109, 418, 15, 70, "Notes",
 CellID->20945],
Cell[3998, 126, 47, 1, 70, "Notes",
 CellID->27756],
Cell[4048, 129, 214, 7, 70, "Notes",
 CellID->28321]
}, Open  ]],
Cell[CellGroupData[{
Cell[4299, 141, 53, 1, 70, "TutorialsSection",
 CellID->19558],
Cell[4355, 144, 153, 3, 70, "Tutorials",
 CellID->23646],
Cell[4511, 149, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4721, 157, 50, 1, 70, "SeeAlsoSection",
 CellID->23196],
Cell[4774, 160, 415, 11, 70, "SeeAlso",
 CellID->20222]
}, Open  ]],
Cell[CellGroupData[{
Cell[5226, 176, 57, 1, 70, "MoreAboutSection",
 CellID->67591891],
Cell[5286, 179, 117, 2, 70, "MoreAbout"],
Cell[5406, 183, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5564, 188, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

