(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8125,        269]
NotebookOptionsPosition[      6013,        203]
NotebookOutlinePosition[      7145,        233]
CellTagsIndexPosition[      7102,        230]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Greek Letters" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringGreekLetters"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Entering Greek Letters\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Delta]" :> 
          Documentation`HelpLookup["paclet:ref/character/Delta"], "\\[Del]" :> 
          Documentation`HelpLookup["paclet:ref/character/Del"], 
          "\\[EmptyUpTriangle]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/EmptyUpTriangle"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[Delta]\"\>", 2->"\<\"\\\\[Del]\"\>", 
       3->"\<\"\\\\[EmptyUpTriangle]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Greek Letters" :> 
          Documentation`HelpLookup["paclet:guide/GreekLetters"], 
          "Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Greek Letters\"\>", 
       2->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[CapitalDelta]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[CapitalDelta]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->250384994],

Cell["\\[CapitalDelta]", "CharacterName",
 CellID->22668],

Cell["Unicode: 0394.", "Notes",
 CellID->31068],

Cell[TextData[{
 "Aliases: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["D", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Delta", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->21991],

Cell["Greek letter. ", "Notes",
 CellID->32196],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[EmptyUpTriangle]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EmptyUpTriangle"]], 
  "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->7783],

Cell["Sometimes used in mathematics to denote Laplacian. ", "Notes",
 CellID->16828]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->7727],

Cell[TextData[ButtonBox["Entering Greek Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringGreekLetters"]], "Tutorials",
 CellID->29426],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->18703],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Delta]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Delta"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Del]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Del"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[EmptyUpTriangle]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EmptyUpTriangle"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->11027]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->786625105],

Cell[TextData[ButtonBox["Greek Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GreekLetters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[CapitalDelta] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 35, 22.9114594}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 0394. Aliases: Esc D Esc, Esc Delta Esc. Greek letter. Not the \
same as \\[EmptyUpTriangle]. Sometimes used in mathematics to denote \
Laplacian. ", "synonyms" -> {"capital delta"}, "title" -> "\\[CapitalDelta]", 
    "type" -> "Character Name", "uri" -> "ref/character/CapitalDelta"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2369, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2992, 84, 595, 19, 70, "CharacterImage",
 CellID->250384994],
Cell[3590, 105, 57, 1, 70, "CharacterName",
 CellID->22668],
Cell[3650, 108, 47, 1, 70, "Notes",
 CellID->31068],
Cell[3700, 111, 418, 15, 70, "Notes",
 CellID->21991],
Cell[4121, 128, 47, 1, 70, "Notes",
 CellID->32196],
Cell[4171, 131, 222, 8, 70, "Notes",
 CellID->7783],
Cell[4396, 141, 84, 1, 70, "Notes",
 CellID->16828]
}, Open  ]],
Cell[CellGroupData[{
Cell[4517, 147, 52, 1, 70, "TutorialsSection",
 CellID->7727],
Cell[4572, 150, 153, 3, 70, "Tutorials",
 CellID->29426],
Cell[4728, 155, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4938, 163, 50, 1, 70, "SeeAlsoSection",
 CellID->18703],
Cell[4991, 166, 619, 18, 70, "SeeAlso",
 CellID->11027]
}, Open  ]],
Cell[CellGroupData[{
Cell[5647, 189, 58, 1, 70, "MoreAboutSection",
 CellID->786625105],
Cell[5708, 192, 117, 2, 70, "MoreAbout"],
Cell[5828, 196, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5986, 201, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

