(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7412,        253]
NotebookOptionsPosition[      5446,        190]
NotebookOutlinePosition[      6528,        220]
CellTagsIndexPosition[      6485,        217]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Greek Letters" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringGreekLetters"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Entering Greek Letters\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Gamma]" :> 
          Documentation`HelpLookup["paclet:ref/character/Gamma"], 
          "\\[CapitalDigamma]" :> 
          Documentation`HelpLookup["paclet:ref/character/CapitalDigamma"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"\\\\[Gamma]\"\>", 
       2->"\<\"\\\\[CapitalDigamma]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[CapitalGamma]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[CapitalGamma]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->271320132],

Cell["\\[CapitalGamma]", "CharacterName",
 CellID->5716],

Cell["Unicode: 0393.", "Notes",
 CellID->10573],

Cell[TextData[{
 "Aliases: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["G", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Gamma", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->31561],

Cell["Greek letter. ", "Notes",
 CellID->23245],

Cell[TextData[{
 "Used in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6473]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->28274],

Cell[TextData[ButtonBox["Entering Greek Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringGreekLetters"]], "Tutorials",
 CellID->1550],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->2699],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Gamma]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Gamma"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CapitalDigamma]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalDigamma"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->18110]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->131204955],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[CapitalGamma] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 35, 31.2397976}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 0393. Aliases: Esc G Esc, Esc Gamma Esc. Greek letter. Used in \
TraditionalForm for Gamma. ", "synonyms" -> {"capital gamma"}, "title" -> 
    "\\[CapitalGamma]", "type" -> "Character Name", "uri" -> 
    "ref/character/CapitalGamma"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2129, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2752, 80, 595, 19, 70, "CharacterImage",
 CellID->271320132],
Cell[3350, 101, 56, 1, 70, "CharacterName",
 CellID->5716],
Cell[3409, 104, 47, 1, 70, "Notes",
 CellID->10573],
Cell[3459, 107, 418, 15, 70, "Notes",
 CellID->31561],
Cell[3880, 124, 47, 1, 70, "Notes",
 CellID->23245],
Cell[3930, 127, 318, 13, 70, "Notes",
 CellID->6473]
}, Open  ]],
Cell[CellGroupData[{
Cell[4285, 145, 53, 1, 70, "TutorialsSection",
 CellID->28274],
Cell[4341, 148, 152, 3, 70, "Tutorials",
 CellID->1550],
Cell[4496, 153, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4706, 161, 49, 1, 70, "SeeAlsoSection",
 CellID->2699],
Cell[4758, 164, 405, 11, 70, "SeeAlso",
 CellID->18110]
}, Open  ]],
Cell[CellGroupData[{
Cell[5200, 180, 58, 1, 70, "MoreAboutSection",
 CellID->131204955],
Cell[5261, 183, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5419, 188, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

