(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7477,        250]
NotebookOptionsPosition[      5580,        189]
NotebookOutlinePosition[      6660,        219]
CellTagsIndexPosition[      6617,        216]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Elements and Keyboard Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Structural Elements and Keyboard Characters\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[CloverLeaf]" :> 
          Documentation`HelpLookup["paclet:ref/character/CloverLeaf"], 
          "\\[LeftModified]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftModified"], 
          "\\[ControlKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/ControlKey"], 
          "\\[EscapeKey]" :> 
          Documentation`HelpLookup["paclet:ref/character/EscapeKey"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[CloverLeaf]\"\>", 
       2->"\<\"\\\\[LeftModified]\"\>", 3->"\<\"\\\\[ControlKey]\"\>", 
       4->"\<\"\\\\[EscapeKey]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[CommandKey]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[CommandKey]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->3632598],

Cell["\\[CommandKey]", "CharacterName",
 CellID->27754],

Cell["Unicode: F76A.", "Notes",
 CellID->289],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["cmd", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->32488],

Cell["Letter\[Hyphen]like form. ", "Notes",
 CellID->25215],

Cell[TextData[{
 "Representation of the ",
 StyleBox["Cmd", "KeyEvent"],
 " or ",
 StyleBox["Alt", "KeyEvent"],
 " key on a keyboard. "
}], "Notes",
 CellID->12008]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->940],

Cell[TextData[ButtonBox["Structural Elements and Keyboard Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralElementsAndKeyboardCharacters"]], "Tutorials",
 CellID->27799]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->8454],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[CloverLeaf]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CloverLeaf"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftModified]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftModified"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[ControlKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ControlKey"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[EscapeKey]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EscapeKey"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->304]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->4917042],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[CommandKey] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 36, 26.2880818}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F76A. Alias: Esc cmd Esc. Letter-like form. Representation of \
the Cmd or Alt key on a keyboard. ", "synonyms" -> {"command key"}, "title" -> 
    "\\[CommandKey]", "type" -> "Character Name", "uri" -> 
    "ref/character/CommandKey"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2285, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2908, 83, 589, 19, 70, "CharacterImage",
 CellID->3632598],
Cell[3500, 104, 55, 1, 70, "CharacterName",
 CellID->27754],
Cell[3558, 107, 45, 1, 70, "Notes",
 CellID->289],
Cell[3606, 110, 235, 9, 70, "Notes",
 CellID->32488],
Cell[3844, 121, 59, 1, 70, "Notes",
 CellID->25215],
Cell[3906, 124, 164, 7, 70, "Notes",
 CellID->12008]
}, Open  ]],
Cell[CellGroupData[{
Cell[4107, 136, 51, 1, 70, "TutorialsSection",
 CellID->940],
Cell[4161, 139, 196, 4, 70, "Tutorials",
 CellID->27799]
}, Open  ]],
Cell[CellGroupData[{
Cell[4394, 148, 49, 1, 70, "SeeAlsoSection",
 CellID->8454],
Cell[4446, 151, 853, 23, 70, "SeeAlso",
 CellID->304]
}, Open  ]],
Cell[CellGroupData[{
Cell[5336, 179, 56, 1, 70, "MoreAboutSection",
 CellID->4917042],
Cell[5395, 182, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5553, 187, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

