(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8339,        278]
NotebookOptionsPosition[      6188,        211]
NotebookOutlinePosition[      7402,        243]
CellTagsIndexPosition[      7359,        240]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[HermitianConjugate]" :> 
          Documentation`HelpLookup["paclet:ref/character/HermitianConjugate"],
           "\\[Conjugate]" :> 
          Documentation`HelpLookup["paclet:ref/character/Conjugate"], 
          "\\[Transpose]" :> 
          Documentation`HelpLookup["paclet:ref/character/Transpose"], 
          "\\[Dagger]" :> 
          Documentation`HelpLookup["paclet:ref/character/Dagger"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[HermitianConjugate]\"\>", 
       2->"\<\"\\\\[Conjugate]\"\>", 3->"\<\"\\\\[Transpose]\"\>", 
       4->"\<\"\\\\[Dagger]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[ConjugateTranspose]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[ConjugateTranspose]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->201225651],

Cell["\\[ConjugateTranspose]", "CharacterName",
 CellID->30742],

Cell["Unicode: F3C9.", "Notes",
 CellID->30037],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["ct", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->5506],

Cell["\<\
Superscript postfix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->6767],

Cell[TextData[{
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["m", "TI"], "\[ConjugateTranspose]"]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ConjugateTranspose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ConjugateTranspose"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5053],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[Dagger]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Dagger"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->9793]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->28505],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->24146],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->3609]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->29465],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[HermitianConjugate]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/HermitianConjugate"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Conjugate]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Conjugate"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Transpose]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Transpose"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Dagger]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Dagger"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->12239]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->161267889],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[ConjugateTranspose] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 36, 26.7724692}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F3C9. Alias: Esc ct Esc. Superscript postfix operator with \
built-in evaluation rules. m^\\[ConjugateTranspose] is by default interpreted \
as ConjugateTranspose[m]. Not the same as \\[Dagger]. ", 
    "synonyms" -> {"conjugate transpose"}, "title" -> 
    "\\[ConjugateTranspose]", "type" -> "Character Name", "uri" -> 
    "ref/character/ConjugateTranspose"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2313, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2936, 83, 607, 19, 70, "CharacterImage",
 CellID->201225651],
Cell[3546, 104, 63, 1, 70, "CharacterName",
 CellID->30742],
Cell[3612, 107, 47, 1, 70, "Notes",
 CellID->30037],
Cell[3662, 110, 233, 9, 70, "Notes",
 CellID->5506],
Cell[3898, 121, 109, 3, 70, "Notes",
 CellID->6767],
Cell[4010, 126, 373, 13, 70, "Notes",
 CellID->5053],
Cell[4386, 141, 201, 7, 70, "Notes",
 CellID->9793]
}, Open  ]],
Cell[CellGroupData[{
Cell[4624, 153, 53, 1, 70, "TutorialsSection",
 CellID->28505],
Cell[4680, 156, 144, 3, 70, "Tutorials",
 CellID->24146],
Cell[4827, 161, 128, 3, 70, "Tutorials",
 CellID->3609]
}, Open  ]],
Cell[CellGroupData[{
Cell[4992, 169, 50, 1, 70, "SeeAlsoSection",
 CellID->29465],
Cell[5045, 172, 860, 24, 70, "SeeAlso",
 CellID->12239]
}, Open  ]],
Cell[CellGroupData[{
Cell[5942, 201, 58, 1, 70, "MoreAboutSection",
 CellID->161267889],
Cell[6003, 204, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6161, 209, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

