(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7499,        255]
NotebookOptionsPosition[      5548,        194]
NotebookOutlinePosition[      6674,        224]
CellTagsIndexPosition[      6631,        221]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[ClockwiseContourIntegral]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/ClockwiseContourIntegral"], 
          "\\[DoubleContourIntegral]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/DoubleContourIntegral"], "\\[Integral]" :> 
          Documentation`HelpLookup["paclet:ref/character/Integral"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"\\\\[ClockwiseContourIntegral]\"\>", 
       2->"\<\"\\\\[DoubleContourIntegral]\"\>", 
       3->"\<\"\\\\[Integral]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[ContourIntegral]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[ContourIntegral]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->817230592],

Cell["\\[ContourIntegral]", "CharacterName",
 CellID->1411],

Cell["Unicode: 222E.", "Notes",
 CellID->16040],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["cint", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->250],

Cell["Compound operator. ", "Notes",
 CellID->11504],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[ContourIntegral]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[DifferentialD]", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{"ContourIntegral", "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23483]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->21766],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->16141]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->10506],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[ClockwiseContourIntegral]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ClockwiseContourIntegral"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[DoubleContourIntegral]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DoubleContourIntegral"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Integral]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Integral"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->9088]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->348903333],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[ContourIntegral] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 36, 27.1787296}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 222E. Alias: Esc cint Esc. Compound operator. \
\\[ContourIntegral] f dx is by default interpreted as ContourIntegral[f,x]. ",
     "synonyms" -> {"contour integral"}, "title" -> "\\[ContourIntegral]", 
    "type" -> "Character Name", "uri" -> "ref/character/ContourIntegral"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2124, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2747, 81, 601, 19, 70, "CharacterImage",
 CellID->817230592],
Cell[3351, 102, 59, 1, 70, "CharacterName",
 CellID->1411],
Cell[3413, 105, 47, 1, 70, "Notes",
 CellID->16040],
Cell[3463, 108, 234, 9, 70, "Notes",
 CellID->250],
Cell[3700, 119, 52, 1, 70, "Notes",
 CellID->11504],
Cell[3755, 122, 517, 19, 70, "Notes",
 CellID->23483]
}, Open  ]],
Cell[CellGroupData[{
Cell[4309, 146, 53, 1, 70, "TutorialsSection",
 CellID->21766],
Cell[4365, 149, 129, 3, 70, "Tutorials",
 CellID->16141]
}, Open  ]],
Cell[CellGroupData[{
Cell[4531, 157, 50, 1, 70, "SeeAlsoSection",
 CellID->10506],
Cell[4584, 160, 681, 19, 70, "SeeAlso",
 CellID->9088]
}, Open  ]],
Cell[CellGroupData[{
Cell[5302, 184, 58, 1, 70, "MoreAboutSection",
 CellID->348903333],
Cell[5363, 187, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5521, 192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

