(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8074,        275]
NotebookOptionsPosition[      5929,        209]
NotebookOutlinePosition[      7154,        241]
CellTagsIndexPosition[      7111,        238]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[NotCupCap]" :> 
          Documentation`HelpLookup["paclet:ref/character/NotCupCap"], 
          "\\[Cap]" :> Documentation`HelpLookup["paclet:ref/character/Cap"], 
          "\\[Cup]" :> 
          Documentation`HelpLookup["paclet:ref/character/Cup"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[NotCupCap]\"\>", 
       2->"\<\"\\\\[Cap]\"\>", 3->"\<\"\\\\[Cup]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Relational Operators & Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/RelationalOperatorsAndCharacters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Relational Operators & Characters\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[CupCap]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[CupCap]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->10978830],

Cell["\\[CupCap]", "CharacterName",
 CellID->30350],

Cell["Unicode: 224D.", "Notes",
 CellID->10405],

Cell["Infix similarity operator. ", "Notes",
 CellID->24346],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[CupCap]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CupCap",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CupCap"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1025],

Cell["\<\
Used in mathematics for various notions of equivalence, usually fairly weak. \
\
\>", "Notes",
 CellID->28970],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[CupCap]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " is often specifically used to indicate that ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "/", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 " has bounded variation. "
}], "Notes",
 CellID->14336]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->4795],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->9793]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->28856],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[NotCupCap]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotCupCap"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Cap]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Cap"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Cup]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Cup"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->15896]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->1754925],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Relational Operators & Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RelationalOperatorsAndCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[CupCap] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 36, 34.6632962}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 224D. Infix similarity operator. x \\[CupCap] y is by default \
interpreted as CupCap[x,y]. Used in mathematics for various notions of \
equivalence, usually fairly weak. f \\[CupCap] g is often specifically used \
to indicate that f/g has bounded variation. ", "synonyms" -> {"cup cap"}, 
    "title" -> "\\[CupCap]", "type" -> "Character Name", "uri" -> 
    "ref/character/CupCap"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2162, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2785, 80, 582, 19, 70, "CharacterImage",
 CellID->10978830],
Cell[3370, 101, 51, 1, 70, "CharacterName",
 CellID->30350],
Cell[3424, 104, 47, 1, 70, "Notes",
 CellID->10405],
Cell[3474, 107, 60, 1, 70, "Notes",
 CellID->24346],
Cell[3537, 110, 494, 20, 70, "Notes",
 CellID->1025],
Cell[4034, 132, 120, 4, 70, "Notes",
 CellID->28970],
Cell[4157, 138, 421, 16, 70, "Notes",
 CellID->14336]
}, Open  ]],
Cell[CellGroupData[{
Cell[4615, 159, 52, 1, 70, "TutorialsSection",
 CellID->4795],
Cell[4670, 162, 128, 3, 70, "Tutorials",
 CellID->9793]
}, Open  ]],
Cell[CellGroupData[{
Cell[4835, 170, 50, 1, 70, "SeeAlsoSection",
 CellID->28856],
Cell[4888, 173, 600, 17, 70, "SeeAlso",
 CellID->15896]
}, Open  ]],
Cell[CellGroupData[{
Cell[5525, 195, 56, 1, 70, "MoreAboutSection",
 CellID->1754925],
Cell[5584, 198, 143, 2, 70, "MoreAbout"],
Cell[5730, 202, 157, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5902, 207, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

